/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.Base64;
import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.marshalling.api.Marshallable;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.Transactions;
import io.mokamint.node.api.NonGenesisBlock;
import io.mokamint.node.api.NonGenesisBlockDescription;
import io.mokamint.node.api.Transaction;
import io.mokamint.node.internal.AbstractBlock;
import io.mokamint.node.internal.json.BlockJson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

public class NonGenesisBlockImpl
extends AbstractBlock<NonGenesisBlockDescription, NonGenesisBlockImpl>
implements NonGenesisBlock {
    private final Transaction[] transactions;

    public NonGenesisBlockImpl(NonGenesisBlockDescription description, Stream<Transaction> transactions, byte[] stateId, PrivateKey privateKey) throws InvalidKeyException, SignatureException {
        this(description, (Transaction[])transactions.map(Objects::requireNonNull).toArray(Transaction[]::new), stateId, privateKey);
    }

    private NonGenesisBlockImpl(NonGenesisBlockDescription description, Transaction[] transactions, byte[] stateId, PrivateKey privateKey) throws InvalidKeyException, SignatureException {
        super(description, stateId, privateKey, (B block) -> block.toByteArrayWithoutSignature(transactions));
        this.transactions = transactions;
        this.ensureTransactionsAreNotRepeated();
    }

    protected NonGenesisBlockImpl(NonGenesisBlockDescription description, BlockJson json) throws InconsistentJsonException {
        super(description, json);
        Stream<String> txs = json.getTransactions();
        if (txs == null) {
            throw new InconsistentJsonException("transactions cannot be null");
        }
        String[] txsAsArray = (String[])txs.toArray(String[]::new);
        this.transactions = new Transaction[txsAsArray.length];
        for (int pos = 0; pos < txsAsArray.length; ++pos) {
            String txBase64 = txsAsArray[pos];
            if (txBase64 == null) {
                throw new InconsistentJsonException("transactions cannot hold a null element");
            }
            this.transactions[pos] = Transactions.of(Base64.fromBase64String((String)txBase64, InconsistentJsonException::new));
        }
        try {
            this.ensureTransactionsAreNotRepeated();
        }
        catch (IllegalArgumentException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    protected NonGenesisBlockImpl(NonGenesisBlockDescription description, UnmarshallingContext context) throws IOException {
        super(description, context);
        this.transactions = (Transaction[])context.readLengthAndArray(Transactions::from, Transaction[]::new);
        try {
            this.ensureTransactionsAreNotRepeated();
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    private void ensureTransactionsAreNotRepeated() throws IllegalArgumentException {
        Transaction[] transactions = (Transaction[])Stream.of(this.transactions).sorted().toArray(Transaction[]::new);
        for (int pos = 0; pos < transactions.length - 1; ++pos) {
            if (!transactions[pos].equals((Object)transactions[pos + 1])) continue;
            throw new IllegalArgumentException("Repeated transaction");
        }
    }

    public byte[] getHashOfPreviousBlock() {
        return ((NonGenesisBlockDescription)this.getDescription()).getHashOfPreviousBlock();
    }

    public Stream<Transaction> getTransactions() {
        return Stream.of(this.transactions);
    }

    public int getTransactionsCount() {
        return this.transactions.length;
    }

    public Transaction getTransaction(int progressive) {
        if (progressive < 0 || progressive >= this.transactions.length) {
            throw new IndexOutOfBoundsException(progressive);
        }
        return this.transactions[progressive];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        Object[] objectArray;
        if (!(other instanceof NonGenesisBlock)) return false;
        NonGenesisBlock ongb = (NonGenesisBlock)other;
        if (!super.equals(other)) return false;
        if (other instanceof NonGenesisBlockImpl) {
            NonGenesisBlockImpl ongbi = (NonGenesisBlockImpl)((Object)other);
            objectArray = ongbi.transactions;
        } else {
            objectArray = ongb.getTransactions().toArray(Transaction[]::new);
        }
        if (!Arrays.equals(this.transactions, objectArray)) return false;
        return true;
    }

    @Override
    public void into(MarshallingContext context) throws IOException {
        super.into(context);
        context.writeLengthAndArray((Marshallable[])this.transactions);
    }

    @Override
    public void intoWithoutConfigurationData(MarshallingContext context) throws IOException {
        super.intoWithoutConfigurationData(context);
        context.writeLengthAndArray((Marshallable[])this.transactions);
    }

    @Override
    protected void intoWithoutSignature(MarshallingContext context) throws IOException {
        super.intoWithoutSignature(context);
        context.writeLengthAndArray((Marshallable[])this.transactions);
    }

    @Override
    protected void populate(StringBuilder builder) {
        super.populate(builder);
        builder.append("\n");
        if (this.transactions.length == 0) {
            builder.append("* 0 transactions");
        } else if (this.transactions.length == 1) {
            builder.append("* 1 transaction:");
        } else {
            builder.append("* " + this.transactions.length + " transactions:");
        }
        int n = 0;
        HashingAlgorithm hashingForTransactions = ((NonGenesisBlockDescription)this.getDescription()).getHashingForTransactions();
        for (Transaction transaction : this.transactions) {
            builder.append("\n * #" + n++ + ": " + transaction.getHexHash(hashingForTransactions) + " (" + String.valueOf(hashingForTransactions) + ")");
        }
    }

    @Override
    protected NonGenesisBlockImpl getThis() {
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] toByteArrayWithoutSignature(Transaction[] transactions) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            block13: {
                MarshallingContext context = this.createMarshallingContext(baos);
                try {
                    super.intoWithoutSignature(context);
                    context.writeLengthAndArray((Marshallable[])transactions);
                    context.flush();
                    byArray = baos.toByteArray();
                    if (context == null) break block13;
                }
                catch (Throwable throwable) {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                context.close();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }
}

