/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.exceptions.ExceptionSupplierFromMessage;
import io.hotmoka.exceptions.Objects;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.Versions;
import io.mokamint.node.api.NodeInfo;
import io.mokamint.node.api.Version;
import io.mokamint.node.internal.json.NodeInfoJson;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.UUID;

public class NodeInfoImpl
implements NodeInfo {
    private final Version version;
    private final UUID uuid;
    private final LocalDateTime localDateTimeUTC;
    private final int maxChainPortionLength;
    private final int maxMempoolPortionLength;

    public NodeInfoImpl(Version version, UUID uuid, LocalDateTime localDateTimeUTC, int maxChainPortionLength, int maxMempoolPortionLength) {
        this(version, uuid, localDateTimeUTC, maxChainPortionLength, maxMempoolPortionLength, IllegalArgumentException::new);
    }

    public NodeInfoImpl(NodeInfoJson json) throws InconsistentJsonException {
        this(((Versions.Json)Objects.requireNonNull((Object)json.getVersion(), (String)"version cannot be null", InconsistentJsonException::new)).unmap(), NodeInfoImpl.mkUuid(json.getUuid()), NodeInfoImpl.mkLocalDateTimeUTCUuid(json.getLocalDateTimeUTC()), json.getMaxChainPortionLength(), json.getMaxMempoolPortionLength());
    }

    private static LocalDateTime mkLocalDateTimeUTCUuid(String localDateTimeUTC) throws InconsistentJsonException {
        try {
            return LocalDateTime.parse((CharSequence)Objects.requireNonNull((Object)localDateTimeUTC, (String)"localDateTimeUTC cannot be null", InconsistentJsonException::new), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    private static UUID mkUuid(String uuid) throws InconsistentJsonException {
        try {
            return UUID.fromString((String)Objects.requireNonNull((Object)uuid, (String)"uuid cannot be null", InconsistentJsonException::new));
        }
        catch (IllegalArgumentException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    private <E extends Exception> NodeInfoImpl(Version version, UUID uuid, LocalDateTime localDateTimeUTC, int maxChainPortionLength, int maxMempoolPortionLength, ExceptionSupplierFromMessage<? extends E> onIllegalArgs) throws E {
        this.version = (Version)Objects.requireNonNull((Object)version, (String)"version cannot be null", onIllegalArgs);
        this.uuid = (UUID)Objects.requireNonNull((Object)uuid, (String)"uuid cannot be null", onIllegalArgs);
        this.localDateTimeUTC = (LocalDateTime)Objects.requireNonNull((Object)localDateTimeUTC, (String)"localDateTimeUTC cannot be null", onIllegalArgs);
        if (maxChainPortionLength < 2) {
            throw (Exception)onIllegalArgs.apply((Object)"maxChainPortionLength must be at least 2");
        }
        this.maxChainPortionLength = maxChainPortionLength;
        if (maxMempoolPortionLength < 1) {
            throw (Exception)onIllegalArgs.apply((Object)"maxMempoolPortionLength must be at least 1");
        }
        this.maxMempoolPortionLength = maxMempoolPortionLength;
    }

    public Version getVersion() {
        return this.version;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public LocalDateTime getLocalDateTimeUTC() {
        return this.localDateTimeUTC;
    }

    public int getMaxChainPortionLength() {
        return this.maxChainPortionLength;
    }

    public int getMaxMempoolPortionLength() {
        return this.maxMempoolPortionLength;
    }

    public boolean equals(Object other) {
        NodeInfo ni;
        return other instanceof NodeInfo && this.uuid.equals((ni = (NodeInfo)other).getUUID()) && this.version.equals((Object)ni.getVersion()) && this.maxChainPortionLength == ni.getMaxChainPortionLength() && this.maxMempoolPortionLength == ni.getMaxMempoolPortionLength() && this.localDateTimeUTC.equals(ni.getLocalDateTimeUTC());
    }

    public int hashCode() {
        return this.uuid.hashCode() ^ this.localDateTimeUTC.hashCode() ^ this.maxChainPortionLength ^ this.maxMempoolPortionLength;
    }

    public String toString() {
        return "version: " + String.valueOf(this.version) + ", UUID: " + String.valueOf(this.uuid) + ", UTC date and time: " + String.valueOf(this.localDateTimeUTC) + ", max chain portion length: " + this.maxChainPortionLength + ", max mempool portion length: " + this.maxMempoolPortionLength;
    }
}

