/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.MinerInfo;
import io.mokamint.node.internal.json.MinerInfoJson;
import java.util.Objects;
import java.util.UUID;

public class MinerInfoImpl
implements MinerInfo {
    private final UUID uuid;
    private final long points;
    private final String description;

    public MinerInfoImpl(UUID uuid, long points, String description) {
        this.uuid = Objects.requireNonNull(uuid);
        this.description = Objects.requireNonNull(description);
        if (points <= 0L) {
            throw new IllegalArgumentException("points must be positive");
        }
        this.points = points;
    }

    public MinerInfoImpl(MinerInfoJson json) throws InconsistentJsonException {
        String uuid = json.getUuid();
        if (uuid == null) {
            throw new InconsistentJsonException("uuid cannot be null");
        }
        try {
            this.uuid = UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
        String description = json.getDescription();
        if (description == null) {
            throw new InconsistentJsonException("description cannot be null");
        }
        this.description = description;
        long points = json.getPoints();
        if (points <= 0L) {
            throw new InconsistentJsonException("points must be positive");
        }
        this.points = points;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public long getPoints() {
        return this.points;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        MinerInfo info;
        return other instanceof MinerInfo && this.uuid.equals((info = (MinerInfo)other).getUUID()) && this.points == info.getPoints() && this.description.equals(info.getDescription());
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public int compareTo(MinerInfo other) {
        int diff = -Long.compare(this.points, other.getPoints());
        if (diff != 0) {
            return diff;
        }
        return this.uuid.compareTo(other.getUUID());
    }

    public String toString() {
        return String.valueOf(this.uuid) + ": " + this.description + ", points = " + this.points;
    }
}

