/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.Base58;
import io.hotmoka.crypto.Base58ConversionException;
import io.hotmoka.crypto.HashingAlgorithms;
import io.hotmoka.crypto.SignatureAlgorithms;
import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.ConsensusConfig;
import io.mokamint.node.api.GenesisBlockDescription;
import io.mokamint.node.internal.AbstractBlockDescription;
import io.mokamint.node.internal.json.BlockDescriptionJson;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Function;

public non-sealed class GenesisBlockDescriptionImpl
extends AbstractBlockDescription
implements GenesisBlockDescription {
    private final LocalDateTime startDateTimeUTC;
    private final HashingAlgorithm hashingForDeadlines;
    private final HashingAlgorithm hashingForGenerations;
    private final SignatureAlgorithm signatureForBlocks;
    private final PublicKey publicKey;
    private final String publicKeyBase58;

    public GenesisBlockDescriptionImpl(LocalDateTime startDateTimeUTC, int targetBlockCreationTime, int oblivion, HashingAlgorithm hashingForBlocks, HashingAlgorithm hashingForTransactions, HashingAlgorithm hashingForDeadlines, HashingAlgorithm hashingForGenerations, SignatureAlgorithm signatureForBlocks, PublicKey publicKey) throws InvalidKeyException {
        super(targetBlockCreationTime, oblivion, hashingForBlocks, hashingForTransactions);
        this.startDateTimeUTC = Objects.requireNonNull(startDateTimeUTC);
        this.hashingForDeadlines = Objects.requireNonNull(hashingForDeadlines);
        this.hashingForGenerations = Objects.requireNonNull(hashingForGenerations);
        this.signatureForBlocks = Objects.requireNonNull(signatureForBlocks);
        this.publicKey = Objects.requireNonNull(publicKey);
        this.publicKeyBase58 = Base58.toBase58String((byte[])signatureForBlocks.encodingOf(publicKey));
    }

    protected GenesisBlockDescriptionImpl(BlockDescriptionJson json) throws InconsistentJsonException, NoSuchAlgorithmException {
        super(json);
        String startDateTimeUTC = json.getStartDateTimeUTC();
        if (startDateTimeUTC == null) {
            throw new InconsistentJsonException("startDateTimeUTC cannot be null");
        }
        try {
            this.startDateTimeUTC = LocalDateTime.parse(startDateTimeUTC, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
        String hashingForDeadlines = json.getHashingForDeadlines();
        if (hashingForDeadlines == null) {
            throw new InconsistentJsonException("hashingForDeadlines cannot be null");
        }
        this.hashingForDeadlines = HashingAlgorithms.of((String)hashingForDeadlines);
        String hashingForGenerations = json.getHashingForGenerations();
        if (hashingForGenerations == null) {
            throw new InconsistentJsonException("hashingForGenerations cannot be null");
        }
        this.hashingForGenerations = HashingAlgorithms.of((String)hashingForGenerations);
        String signatureForBlocks = json.getSignatureForBlocks();
        if (signatureForBlocks == null) {
            throw new InconsistentJsonException("signatureForBlocks cannot be null");
        }
        this.signatureForBlocks = SignatureAlgorithms.of((String)signatureForBlocks);
        String publicKey = json.getPublicKey();
        if (publicKey == null) {
            throw new InconsistentJsonException("publicKey cannot be null");
        }
        try {
            this.publicKey = this.signatureForBlocks.publicKeyFromEncoding(Base58.fromBase58String((String)publicKey));
        }
        catch (Base58ConversionException | InvalidKeySpecException e) {
            throw new InconsistentJsonException(e);
        }
        try {
            this.publicKeyBase58 = Base58.toBase58String((byte[])this.signatureForBlocks.encodingOf(this.publicKey));
        }
        catch (InvalidKeyException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    protected GenesisBlockDescriptionImpl(UnmarshallingContext context) throws IOException, NoSuchAlgorithmException {
        super(context);
        try {
            this.startDateTimeUTC = LocalDateTime.parse(context.readStringUnshared(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            this.hashingForDeadlines = HashingAlgorithms.of((String)context.readStringShared());
            this.hashingForGenerations = HashingAlgorithms.of((String)context.readStringShared());
            this.signatureForBlocks = SignatureAlgorithms.of((String)context.readStringUnshared());
            byte[] publicKeyEncoding = this.readPublicKeyEncoding(context);
            this.publicKey = this.signatureForBlocks.publicKeyFromEncoding(publicKeyEncoding);
            this.publicKeyBase58 = Base58.toBase58String((byte[])publicKeyEncoding);
        }
        catch (InvalidKeySpecException | DateTimeParseException e) {
            throw new IOException(e);
        }
    }

    protected GenesisBlockDescriptionImpl(UnmarshallingContext context, ConsensusConfig<?, ?> config) throws IOException {
        super(config);
        try {
            this.startDateTimeUTC = LocalDateTime.parse(context.readStringUnshared(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            this.hashingForDeadlines = config.getHashingForDeadlines();
            this.hashingForGenerations = config.getHashingForGenerations();
            this.signatureForBlocks = config.getSignatureForBlocks();
            byte[] publicKeyEncoding = this.readPublicKeyEncoding(context);
            this.publicKey = this.signatureForBlocks.publicKeyFromEncoding(publicKeyEncoding);
            this.publicKeyBase58 = Base58.toBase58String((byte[])publicKeyEncoding);
        }
        catch (InvalidKeySpecException | DateTimeParseException e) {
            throw new IOException(e);
        }
    }

    private byte[] readPublicKeyEncoding(UnmarshallingContext context) throws IOException {
        OptionalInt maybeLength = this.signatureForBlocks.publicKeyLength();
        if (maybeLength.isPresent()) {
            return context.readBytes(maybeLength.getAsInt(), "Mismatch in the length of the public key");
        }
        return context.readLengthAndBytes("Mismatch in the length of the public key");
    }

    public BigInteger getPower() {
        return BigInteger.ZERO;
    }

    public long getTotalWaitingTime() {
        return 0L;
    }

    public long getWeightedWaitingTime() {
        return 0L;
    }

    public BigInteger getAcceleration() {
        byte[] averageValue = new byte[this.hashingForGenerations.length()];
        averageValue[0] = -128;
        byte[] newValueAsBytes = new BigInteger(1, averageValue).divide(BigInteger.valueOf(this.getTargetBlockCreationTime())).toByteArray();
        byte[] dividedValueAsBytes = new byte[averageValue.length];
        System.arraycopy(newValueAsBytes, 0, dividedValueAsBytes, dividedValueAsBytes.length - newValueAsBytes.length, newValueAsBytes.length);
        byte[] firstEightBytes = new byte[]{dividedValueAsBytes[0], dividedValueAsBytes[1], dividedValueAsBytes[2], dividedValueAsBytes[3], dividedValueAsBytes[4], dividedValueAsBytes[5], dividedValueAsBytes[6], dividedValueAsBytes[7]};
        BigInteger result = new BigInteger(1, firstEightBytes);
        return result.signum() == 0 ? BigInteger.ONE : result;
    }

    public long getHeight() {
        return 0L;
    }

    public HashingAlgorithm getHashingForDeadlines() {
        return this.hashingForDeadlines;
    }

    public HashingAlgorithm getHashingForGenerations() {
        return this.hashingForGenerations;
    }

    public SignatureAlgorithm getSignatureForBlocks() {
        return this.signatureForBlocks;
    }

    public PublicKey getPublicKeyForSigningBlock() {
        return this.publicKey;
    }

    public String getPublicKeyForSigningBlockBase58() {
        return this.publicKeyBase58;
    }

    public LocalDateTime getStartDateTimeUTC() {
        return this.startDateTimeUTC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GenesisBlockDescription)) return false;
        GenesisBlockDescription gbd = (GenesisBlockDescription)other;
        if (!super.equals(other)) return false;
        if (!this.startDateTimeUTC.equals(gbd.getStartDateTimeUTC())) return false;
        if (!this.publicKeyBase58.equals(gbd.getPublicKeyForSigningBlockBase58())) return false;
        if (!this.signatureForBlocks.equals((Object)gbd.getSignatureForBlocks())) return false;
        if (!this.hashingForDeadlines.equals((Object)gbd.getHashingForDeadlines())) return false;
        if (!this.hashingForGenerations.equals((Object)gbd.getHashingForGenerations())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.startDateTimeUTC.hashCode() ^ this.publicKeyBase58.hashCode();
    }

    @Override
    public void into(MarshallingContext context) throws IOException {
        try {
            super.into(context);
            context.writeStringUnshared(DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(this.startDateTimeUTC));
            context.writeStringShared(this.hashingForDeadlines.getName());
            context.writeStringShared(this.hashingForGenerations.getName());
            context.writeStringUnshared(this.signatureForBlocks.getName());
            this.writePublicKeyEncoding(context);
        }
        catch (InvalidKeyException | DateTimeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void intoWithoutConfigurationData(MarshallingContext context) throws IOException {
        try {
            super.intoWithoutConfigurationData(context);
            context.writeStringUnshared(DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(this.startDateTimeUTC));
            this.writePublicKeyEncoding(context);
        }
        catch (InvalidKeyException | DateTimeException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void populate(StringBuilder builder) {
        super.populate(builder);
        builder.append("\n* public key of the peer that signed the block: " + this.publicKeyBase58 + " (" + String.valueOf(this.signatureForBlocks) + ", base58)");
    }

    @Override
    protected byte[] getNextGenerationSignature() {
        return this.hashingForGenerations.getHasher(Function.identity()).hash((Object)new byte[]{13, 1, 19, 73});
    }

    private void writePublicKeyEncoding(MarshallingContext context) throws IOException, InvalidKeyException {
        byte[] publicKeyEncoding = this.signatureForBlocks.encodingOf(this.publicKey);
        if (this.signatureForBlocks.publicKeyLength().isEmpty()) {
            context.writeLengthAndBytes(publicKeyEncoding);
        } else {
            context.writeBytes(publicKeyEncoding);
        }
    }
}

