/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import com.moandjiezana.toml.Toml;
import io.hotmoka.crypto.HashingAlgorithms;
import io.hotmoka.crypto.SignatureAlgorithms;
import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.ConsensusConfig;
import io.mokamint.node.api.ConsensusConfigBuilder;
import io.mokamint.node.internal.json.BasicConsensusConfigJson;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public abstract class ConsensusConfigImpl<C extends ConsensusConfig<C, B>, B extends ConsensusConfigBuilder<C, B>>
implements ConsensusConfig<C, B> {
    public final String chainId;
    public final HashingAlgorithm hashingForDeadlines;
    public final HashingAlgorithm hashingForGenerations;
    public final HashingAlgorithm hashingForBlocks;
    public final HashingAlgorithm hashingForTransactions;
    public final SignatureAlgorithm signatureForBlocks;
    public final SignatureAlgorithm signatureForDeadlines;
    public final int targetBlockCreationTime;
    public final int maxBlockSize;
    public final int maxTransactionSize;
    public final int oblivion;

    protected ConsensusConfigImpl(ConsensusConfigBuilderImpl<C, B> builder) {
        this.chainId = builder.chainId;
        this.hashingForDeadlines = builder.hashingForDeadlines;
        this.hashingForGenerations = builder.hashingForGenerations;
        this.hashingForBlocks = builder.hashingForBlocks;
        this.hashingForTransactions = builder.hashingForTransactions;
        this.signatureForBlocks = builder.signatureForBlocks;
        this.signatureForDeadlines = builder.signatureForDeadlines;
        this.targetBlockCreationTime = builder.targetBlockCreationTime;
        this.maxBlockSize = builder.maxBlockSize;
        this.maxTransactionSize = builder.maxTransactionSize;
        this.oblivion = builder.oblivion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof ConsensusConfigImpl)) return false;
        ConsensusConfigImpl otherConfig = (ConsensusConfigImpl)other;
        if (this.getClass() != other.getClass()) return false;
        if (!this.chainId.equals(otherConfig.chainId)) return false;
        if (this.maxBlockSize != otherConfig.maxBlockSize) return false;
        if (this.maxTransactionSize != otherConfig.maxTransactionSize) return false;
        if (this.oblivion != otherConfig.oblivion) return false;
        if (this.targetBlockCreationTime != otherConfig.targetBlockCreationTime) return false;
        if (!this.hashingForDeadlines.equals((Object)otherConfig.hashingForDeadlines)) return false;
        if (!this.hashingForGenerations.equals((Object)otherConfig.hashingForGenerations)) return false;
        if (!this.hashingForBlocks.equals((Object)otherConfig.hashingForBlocks)) return false;
        if (!this.signatureForBlocks.equals((Object)otherConfig.getSignatureForBlocks())) return false;
        if (!this.signatureForDeadlines.equals((Object)otherConfig.getSignatureForDeadlines())) return false;
        return true;
    }

    public int hashCode() {
        return this.chainId.hashCode() ^ Long.hashCode(this.maxBlockSize) ^ Long.hashCode(this.maxTransactionSize) ^ Long.hashCode(this.targetBlockCreationTime) ^ this.oblivion;
    }

    public String toString() {
        return this.toToml();
    }

    public String toToml() {
        StringBuilder sb = new StringBuilder();
        sb.append("# This is a TOML config file for Mokamint nodes.\n");
        sb.append("# For more information about TOML, see https://github.com/toml-lang/toml\n");
        sb.append("# For more information about Mokamint, see https://www.mokamint.io\n");
        sb.append("\n");
        sb.append("## Consensus parameters\n");
        sb.append("\n");
        sb.append("# the chain identifier of the blockchain\n");
        sb.append("chain_id = \"" + this.chainId + "\"\n");
        sb.append("\n");
        sb.append("# the hashing algorithm used for the deadlines and hence for the plot files of the miners\n");
        sb.append("hashing_for_deadlines = \"" + String.valueOf(this.hashingForDeadlines) + "\"\n");
        sb.append("\n");
        sb.append("# the hashing algorithm used for the computation of the new generation and scoop number from the previous block\n");
        sb.append("hashing_for_generations = \"" + String.valueOf(this.hashingForGenerations) + "\"\n");
        sb.append("\n");
        sb.append("# the hashing algorithm used for the blocks of the blockchain\n");
        sb.append("hashing_for_blocks = \"" + String.valueOf(this.hashingForBlocks) + "\"\n");
        sb.append("\n");
        sb.append("# the hashing algorithm used for the transactions of the blockchain\n");
        sb.append("hashing_for_transactions = \"" + String.valueOf(this.hashingForTransactions) + "\"\n");
        sb.append("\n");
        sb.append("# the signature algorithm that nodes use to sign the blocks\n");
        sb.append("signature_for_blocks = \"" + String.valueOf(this.signatureForBlocks) + "\"\n");
        sb.append("\n");
        sb.append("# the signature algorithm that miners use to sign the deadlines\n");
        sb.append("signature_for_deadlines = \"" + String.valueOf(this.signatureForDeadlines) + "\"\n");
        sb.append("\n");
        sb.append("# time, in milliseconds, aimed between the creation of a block and the creation of a next block\n");
        sb.append("target_block_creation_time = " + this.targetBlockCreationTime + "\n");
        sb.append("\n");
        sb.append("# the maximal size, in bytes, of a block's transactions table\n");
        sb.append("max_block_size = " + this.maxBlockSize + "\n");
        sb.append("\n");
        sb.append("# the maximal size, in bytes, of a transaction\n");
        sb.append("max_transaction_size = " + this.maxTransactionSize + "\n");
        sb.append("\n");
        sb.append("# the rapidity of changes of the acceleration for the block creation time\n");
        sb.append("# between 0 (no change) and 100,000 (maximally fast change)\n");
        sb.append("oblivion = " + this.oblivion + "\n");
        return sb.toString();
    }

    public String getChainId() {
        return this.chainId;
    }

    public HashingAlgorithm getHashingForDeadlines() {
        return this.hashingForDeadlines;
    }

    public HashingAlgorithm getHashingForGenerations() {
        return this.hashingForGenerations;
    }

    public HashingAlgorithm getHashingForBlocks() {
        return this.hashingForBlocks;
    }

    public HashingAlgorithm getHashingForTransactions() {
        return this.hashingForTransactions;
    }

    public SignatureAlgorithm getSignatureForBlocks() {
        return this.signatureForBlocks;
    }

    public SignatureAlgorithm getSignatureForDeadlines() {
        return this.signatureForDeadlines;
    }

    public int getTargetBlockCreationTime() {
        return this.targetBlockCreationTime;
    }

    public int getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public int getMaxTransactionSize() {
        return this.maxTransactionSize;
    }

    public int getOblivion() {
        return this.oblivion;
    }

    public static abstract class ConsensusConfigBuilderImpl<C extends ConsensusConfig<C, B>, B extends ConsensusConfigBuilder<C, B>>
    implements ConsensusConfigBuilder<C, B> {
        private String chainId = "";
        private HashingAlgorithm hashingForDeadlines;
        private HashingAlgorithm hashingForGenerations;
        private HashingAlgorithm hashingForBlocks;
        private HashingAlgorithm hashingForTransactions;
        private SignatureAlgorithm signatureForBlocks;
        private SignatureAlgorithm signatureForDeadlines;
        private int targetBlockCreationTime = 240000;
        private int maxBlockSize = 1000000;
        private int maxTransactionSize = 500000;
        private int oblivion = 20000;

        protected ConsensusConfigBuilderImpl() throws NoSuchAlgorithmException {
            this.setHashingForDeadlines(HashingAlgorithms.shabal256());
            this.setHashingForGenerations(HashingAlgorithms.sha256());
            this.setHashingForBlocks(HashingAlgorithms.sha256());
            this.setHashingForTransactions(HashingAlgorithms.sha256());
            this.setSignatureForBlocks(SignatureAlgorithms.ed25519());
            this.setSignatureForDeadlines(SignatureAlgorithms.ed25519());
        }

        protected ConsensusConfigBuilderImpl(Toml toml) throws NoSuchAlgorithmException {
            this();
            Long oblivion;
            Long maxTransactionSize;
            Long maxBlockSize;
            Long targetBlockCreationTime;
            String signatureForDeadlines;
            String signatureForBlocks;
            String hashingForTransactions;
            String hashingForBlocks;
            String hashingForGenerations;
            String hashingForDeadlines;
            String chainId = toml.getString("chain_id");
            if (chainId != null) {
                this.setChainId(chainId);
            }
            if ((hashingForDeadlines = toml.getString("hashing_for_deadlines")) != null) {
                this.setHashingForDeadlines(hashingForDeadlines);
            }
            if ((hashingForGenerations = toml.getString("hashing_for_generations")) != null) {
                this.setHashingForGenerations(hashingForGenerations);
            }
            if ((hashingForBlocks = toml.getString("hashing_for_blocks")) != null) {
                this.setHashingForBlocks(hashingForBlocks);
            }
            if ((hashingForTransactions = toml.getString("hashing_for_transactions")) != null) {
                this.setHashingForTransactions(hashingForTransactions);
            }
            if ((signatureForBlocks = toml.getString("signature_for_blocks")) != null) {
                this.setSignatureForBlocks(signatureForBlocks);
            }
            if ((signatureForDeadlines = toml.getString("signature_for_deadlines")) != null) {
                this.setSignatureForDeadlines(signatureForDeadlines);
            }
            if ((targetBlockCreationTime = toml.getLong("target_block_creation_time")) != null) {
                this.setTargetBlockCreationTime(targetBlockCreationTime);
            }
            if ((maxBlockSize = toml.getLong("max_block_size")) != null) {
                this.setMaxBlockSize(maxBlockSize);
            }
            if ((maxTransactionSize = toml.getLong("max_transaction_size")) != null) {
                this.setMaxTransactionSize(maxTransactionSize);
            }
            if ((oblivion = toml.getLong("oblivion")) != null) {
                this.setOblivion(oblivion);
            }
        }

        protected ConsensusConfigBuilderImpl(ConsensusConfig<C, B> config) {
            this.chainId = config.getChainId();
            this.hashingForDeadlines = config.getHashingForDeadlines();
            this.hashingForGenerations = config.getHashingForGenerations();
            this.hashingForBlocks = config.getHashingForBlocks();
            this.hashingForTransactions = config.getHashingForTransactions();
            this.signatureForBlocks = config.getSignatureForBlocks();
            this.signatureForDeadlines = config.getSignatureForDeadlines();
            this.targetBlockCreationTime = config.getTargetBlockCreationTime();
            this.maxBlockSize = config.getMaxBlockSize();
            this.maxTransactionSize = config.getMaxTransactionSize();
            this.oblivion = config.getOblivion();
        }

        protected ConsensusConfigBuilderImpl(BasicConsensusConfigJson json) throws InconsistentJsonException, NoSuchAlgorithmException {
            Objects.requireNonNull(json);
            try {
                this.setChainId(json.getChainId());
                this.setHashingForDeadlines(json.getHashingForDeadlines());
                this.setHashingForGenerations(json.getHashingForGenerations());
                this.setHashingForBlocks(json.getHashingForBlocks());
                this.setHashingForTransactions(json.getHashingForTransactions());
                this.setSignatureForBlocks(json.getSignatureForBlocks());
                this.setSignatureForDeadlines(json.getSignatureForDeadlines());
                this.setTargetBlockCreationTime(json.getTargetBlockCreationTime());
                this.setMaxBlockSize(json.getMaxBlockSize());
                this.setOblivion(json.getOblivion());
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new InconsistentJsonException(e.getMessage());
            }
        }

        public B setChainId(String chainId) {
            this.chainId = Objects.requireNonNull(chainId, "chainId cannot be null");
            return this.getThis();
        }

        private void setHashingForDeadlines(String hashingForDeadlines) throws NoSuchAlgorithmException {
            this.hashingForDeadlines = HashingAlgorithms.of((String)Objects.requireNonNull(hashingForDeadlines, "hashingForDeadlines cannot be null"));
        }

        private void setHashingForGenerations(String hashingForGenerations) throws NoSuchAlgorithmException {
            this.hashingForGenerations = HashingAlgorithms.of((String)Objects.requireNonNull(hashingForGenerations, "hashingForGenerations cannot be null"));
        }

        private void setHashingForBlocks(String hashingForBlocks) throws NoSuchAlgorithmException {
            this.hashingForBlocks = HashingAlgorithms.of((String)Objects.requireNonNull(hashingForBlocks, "hashingForBlocks cannot be null"));
        }

        private void setHashingForTransactions(String hashingForTransactions) throws NoSuchAlgorithmException {
            this.hashingForTransactions = HashingAlgorithms.of((String)Objects.requireNonNull(hashingForTransactions, "hashingForTransactions cannot be null"));
        }

        private void setSignatureForBlocks(String signatureForBlocks) throws NoSuchAlgorithmException {
            this.signatureForBlocks = SignatureAlgorithms.of((String)Objects.requireNonNull(signatureForBlocks, "signatureForBlocks cannot be null"));
        }

        private void setSignatureForDeadlines(String signatureForDeadlines) throws NoSuchAlgorithmException {
            this.signatureForDeadlines = SignatureAlgorithms.of((String)Objects.requireNonNull(signatureForDeadlines, "signatureForDeadlines cannot be null"));
        }

        public B setHashingForDeadlines(HashingAlgorithm hashingForDeadlines) {
            this.hashingForDeadlines = Objects.requireNonNull(hashingForDeadlines, "hashingForDeadlines cannot be null");
            return this.getThis();
        }

        public B setHashingForGenerations(HashingAlgorithm hashingForGenerations) {
            this.hashingForGenerations = Objects.requireNonNull(hashingForGenerations, "hashingForGenerations cannot be null");
            return this.getThis();
        }

        public B setHashingForBlocks(HashingAlgorithm hashingForBlocks) {
            this.hashingForBlocks = Objects.requireNonNull(hashingForBlocks, "hashingForBlocks cannot be null");
            return this.getThis();
        }

        public B setHashingForTransactions(HashingAlgorithm hashingForTransactions) {
            this.hashingForTransactions = Objects.requireNonNull(hashingForTransactions, "hashingForTransactions cannot be null");
            return this.getThis();
        }

        public B setSignatureForBlocks(SignatureAlgorithm signatureForBlocks) {
            this.signatureForBlocks = Objects.requireNonNull(signatureForBlocks, "signatureForBlocks cannot be null");
            return this.getThis();
        }

        public B setSignatureForDeadlines(SignatureAlgorithm signatureForDeadlines) {
            this.signatureForDeadlines = Objects.requireNonNull(signatureForDeadlines, "signatureForDeadlines cannot be null");
            return this.getThis();
        }

        public B setTargetBlockCreationTime(int targetBlockCreationTime) {
            if (targetBlockCreationTime < 1) {
                throw new IllegalArgumentException("targetBlockCreationTime must be positive");
            }
            this.targetBlockCreationTime = targetBlockCreationTime;
            return this.getThis();
        }

        private B setTargetBlockCreationTime(long targetBlockCreationTime) {
            if (targetBlockCreationTime < 1L || targetBlockCreationTime > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("targetBlockCreationTime must be between 1 and 2147483647 inclusive");
            }
            this.targetBlockCreationTime = (int)targetBlockCreationTime;
            return this.getThis();
        }

        public B setMaxBlockSize(int maxBlockSize) {
            if (maxBlockSize < 0) {
                throw new IllegalArgumentException("maxBlockSize cannot be negative");
            }
            this.maxBlockSize = maxBlockSize;
            return this.getThis();
        }

        private B setMaxBlockSize(long maxBlockSize) {
            if (maxBlockSize < 0L || maxBlockSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("maxBlockSize must be between 0 and 2147483647 inclusive");
            }
            this.maxBlockSize = (int)maxBlockSize;
            return this.getThis();
        }

        public B setMaxTransactionSize(int maxTransactionSize) {
            if (maxTransactionSize < 0) {
                throw new IllegalArgumentException("maxTransactionSize cannot be negative");
            }
            this.maxTransactionSize = maxTransactionSize;
            return this.getThis();
        }

        private B setMaxTransactionSize(long maxTransactionSize) {
            if (maxTransactionSize < 0L || maxTransactionSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("maxTransactionSize must be between 0 and 2147483647 inclusive");
            }
            this.maxTransactionSize = (int)maxTransactionSize;
            return this.getThis();
        }

        public B setOblivion(int oblivion) {
            return this.setOblivion((long)oblivion);
        }

        private B setOblivion(long oblivion) {
            if (oblivion < 0L || oblivion > 100000L) {
                throw new IllegalArgumentException("oblivion must be between 0 and 100,000 (inclusive)");
            }
            this.oblivion = (int)oblivion;
            return this.getThis();
        }

        protected abstract B getThis();

        protected int getTargetBlockCreationTime() {
            return this.targetBlockCreationTime;
        }

        protected static Toml readToml(Path path) throws FileNotFoundException {
            try {
                return new Toml().read(path.toFile());
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof FileNotFoundException) {
                    FileNotFoundException fnfe = (FileNotFoundException)cause;
                    throw fnfe;
                }
                throw e;
            }
        }
    }
}

