/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.exceptions.ExceptionSupplierFromMessage;
import io.hotmoka.exceptions.Objects;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.ChainPortion;
import io.mokamint.node.internal.json.ChainPortionJson;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ChainPortionImpl
implements ChainPortion {
    private final byte[][] hashes;

    public ChainPortionImpl(Stream<byte[]> hashes) {
        this((T[])((byte[][])hashes.toArray(x$0 -> new byte[x$0][])), rec$ -> (byte[])((byte[])rec$).clone(), (ExceptionSupplierFromMessage)IllegalArgumentException::new);
    }

    public ChainPortionImpl(ChainPortionJson json) throws InconsistentJsonException {
        this((String[])json.getHashes().toArray(String[]::new), hash -> Hex.fromHexString((String)hash, InconsistentJsonException::new), InconsistentJsonException::new);
    }

    private <E extends Exception, T> ChainPortionImpl(T[] hashes, Transformation<T, E> transformation, ExceptionSupplierFromMessage<? extends E> onIllegalArgs) throws E {
        this.hashes = new byte[hashes.length][];
        for (int pos = 0; pos < hashes.length; ++pos) {
            this.hashes[pos] = transformation.apply(Objects.requireNonNull(hashes[pos], (String)"hashes cannot contain a null element", onIllegalArgs));
        }
    }

    public Stream<byte[]> getHashes() {
        return Stream.of(this.hashes).map(rec$ -> (byte[])((byte[])rec$).clone());
    }

    public boolean equals(Object other) {
        ChainPortion ocp;
        if (other instanceof ChainPortionImpl) {
            ChainPortionImpl cpi = (ChainPortionImpl)other;
            return Arrays.deepEquals((Object[])this.hashes, (Object[])cpi.hashes);
        }
        return other instanceof ChainPortion && Arrays.deepEquals((Object[])this.hashes, (ocp = (ChainPortion)other).getHashes().toArray(x$0 -> new byte[x$0][]));
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.hashes);
    }

    public String toString() {
        return Stream.of(this.hashes).map(Hex::toHexString).collect(Collectors.joining("\n"));
    }

    private static interface Transformation<T, E extends Exception> {
        public byte[] apply(T var1) throws E;
    }
}

