/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.HashingAlgorithms;
import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.marshalling.AbstractMarshallable;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.BlockDescription;
import io.mokamint.node.api.ConsensusConfig;
import io.mokamint.node.internal.GenesisBlockDescriptionImpl;
import io.mokamint.node.internal.NonGenesisBlockDescriptionImpl;
import io.mokamint.node.internal.json.BlockDescriptionJson;
import io.mokamint.nonce.Challenges;
import io.mokamint.nonce.api.Challenge;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.function.Function;

public abstract sealed class AbstractBlockDescription
extends AbstractMarshallable
implements BlockDescription
permits GenesisBlockDescriptionImpl, NonGenesisBlockDescriptionImpl {
    private final int targetBlockCreationTime;
    private final int oblivion;
    private final HashingAlgorithm hashingForBlocks;
    private final HashingAlgorithm hashingForTransactions;

    protected AbstractBlockDescription(int targetBlockCreationTime, int oblivion, HashingAlgorithm hashingForBlocks, HashingAlgorithm hashingForTransactions) {
        if (targetBlockCreationTime <= 0) {
            throw new IllegalArgumentException("The target block creation time must be positive");
        }
        if (oblivion < 0 || oblivion > 100000) {
            throw new IllegalArgumentException("oblivion must be between 0 and 100,000 (inclusive)");
        }
        this.targetBlockCreationTime = targetBlockCreationTime;
        this.oblivion = oblivion;
        this.hashingForBlocks = Objects.requireNonNull(hashingForBlocks);
        this.hashingForTransactions = Objects.requireNonNull(hashingForTransactions);
    }

    protected AbstractBlockDescription(UnmarshallingContext context) throws IOException, NoSuchAlgorithmException {
        this.targetBlockCreationTime = context.readCompactInt();
        if (this.targetBlockCreationTime <= 0) {
            throw new IOException("The target block creation time must be positive");
        }
        this.oblivion = context.readCompactInt();
        if (this.oblivion < 0 || this.oblivion > 100000) {
            throw new IOException("oblivion must be between 0 and 100,000 (inclusive)");
        }
        this.hashingForBlocks = HashingAlgorithms.of((String)context.readStringShared());
        this.hashingForTransactions = HashingAlgorithms.of((String)context.readStringShared());
    }

    protected AbstractBlockDescription(ConsensusConfig<?, ?> config) {
        this.targetBlockCreationTime = config.getTargetBlockCreationTime();
        this.oblivion = config.getOblivion();
        this.hashingForBlocks = config.getHashingForBlocks();
        this.hashingForTransactions = config.getHashingForTransactions();
    }

    protected AbstractBlockDescription(BlockDescriptionJson json) throws InconsistentJsonException, NoSuchAlgorithmException {
        int targetBlockCreationTime = json.getTargetBlockCreationTime();
        if (targetBlockCreationTime <= 0) {
            throw new InconsistentJsonException("The target block creation time must be positive");
        }
        this.targetBlockCreationTime = targetBlockCreationTime;
        int oblivion = json.getOblivion();
        if (oblivion < 0 || oblivion > 100000) {
            throw new InconsistentJsonException("oblivion must be between 0 and 100,000 (inclusive)");
        }
        this.oblivion = oblivion;
        String hashingForBlocks = json.getHashingForBlocks();
        if (hashingForBlocks == null) {
            throw new InconsistentJsonException("hashingForBlocks cannot be null");
        }
        this.hashingForBlocks = HashingAlgorithms.of((String)hashingForBlocks);
        String hashingForTransactions = json.getHashingForTransactions();
        if (hashingForTransactions == null) {
            throw new InconsistentJsonException("hashingForTransactions cannot be null");
        }
        this.hashingForTransactions = HashingAlgorithms.of((String)hashingForTransactions);
    }

    public static BlockDescription from(UnmarshallingContext context, ConsensusConfig<?, ?> config) throws IOException {
        long height = context.readCompactLong();
        return height == 0L ? new GenesisBlockDescriptionImpl(context, config) : new NonGenesisBlockDescriptionImpl(height, context, config);
    }

    public static BlockDescription from(BlockDescriptionJson json) throws NoSuchAlgorithmException, InconsistentJsonException {
        String startDateTimeUTC = json.getStartDateTimeUTC();
        return startDateTimeUTC == null ? new NonGenesisBlockDescriptionImpl(json) : new GenesisBlockDescriptionImpl(json);
    }

    public static BlockDescription from(UnmarshallingContext context) throws IOException, NoSuchAlgorithmException {
        long height = context.readCompactLong();
        return height == 0L ? new GenesisBlockDescriptionImpl(context) : new NonGenesisBlockDescriptionImpl(height, context);
    }

    public final int getTargetBlockCreationTime() {
        return this.targetBlockCreationTime;
    }

    public final int getOblivion() {
        return this.oblivion;
    }

    public final HashingAlgorithm getHashingForBlocks() {
        return this.hashingForBlocks;
    }

    public final HashingAlgorithm getHashingForTransactions() {
        return this.hashingForTransactions;
    }

    public final Challenge getNextChallenge() {
        byte[] nextGenerationSignature = this.getNextGenerationSignature();
        HashingAlgorithm hashingForGenerations = this.getHashingForGenerations();
        byte[] generationHash = hashingForGenerations.getHasher(Function.identity()).hash((Object)AbstractBlockDescription.concat(nextGenerationSignature, AbstractBlockDescription.longToBytesBE(this.getHeight() + 1L)));
        int nextScoopNumber = new BigInteger(1, generationHash).remainder(BigInteger.valueOf(4096L)).intValue();
        return Challenges.of((int)nextScoopNumber, (byte[])nextGenerationSignature, (HashingAlgorithm)this.getHashingForDeadlines(), (HashingAlgorithm)hashingForGenerations);
    }

    public boolean equals(Object other) {
        AbstractBlockDescription abd;
        return other instanceof AbstractBlockDescription && this.targetBlockCreationTime == (abd = (AbstractBlockDescription)((Object)other)).getTargetBlockCreationTime() && this.oblivion == abd.getOblivion() && this.hashingForBlocks.equals((Object)abd.getHashingForBlocks()) && this.hashingForTransactions.equals((Object)abd.getHashingForTransactions());
    }

    public int hashCode() {
        return this.targetBlockCreationTime ^ this.oblivion ^ this.hashingForBlocks.hashCode() ^ this.hashingForTransactions.hashCode();
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.populate(builder);
        return builder.toString();
    }

    public void into(MarshallingContext context) throws IOException {
        context.writeCompactLong(this.getHeight());
        context.writeCompactInt(this.targetBlockCreationTime);
        context.writeCompactInt(this.oblivion);
        context.writeStringShared(this.hashingForBlocks.getName());
        context.writeStringShared(this.hashingForTransactions.getName());
    }

    public void intoWithoutConfigurationData(MarshallingContext context) throws IOException {
        context.writeCompactLong(this.getHeight());
    }

    protected void populate(StringBuilder builder) {
        builder.append("* height: " + this.getHeight() + "\n");
        builder.append("* power: " + String.valueOf(this.getPower()) + "\n");
        builder.append("* total waiting time: " + this.getTotalWaitingTime() + " ms\n");
        builder.append("* weighted waiting time: " + this.getWeightedWaitingTime() + " ms (target is " + this.targetBlockCreationTime + " ms)\n");
        builder.append("* next generation signature: " + Hex.toHexString((byte[])this.getNextGenerationSignature()) + " (" + String.valueOf(this.getHashingForGenerations()) + ")\n");
        builder.append("* acceleration: " + String.valueOf(this.getAcceleration()));
    }

    protected abstract byte[] getNextGenerationSignature();

    protected static byte[] concat(byte[] array1, byte[] array2) {
        byte[] merge = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, merge, 0, array1.length);
        System.arraycopy(array2, 0, merge, array1.length, array2.length);
        return merge;
    }

    private static byte[] longToBytesBE(long l) {
        byte[] target = new byte[8];
        for (int i = 0; i <= 7; ++i) {
            target[7 - i] = (byte)(l >> 8 * i & 0xFFL);
        }
        return target;
    }
}

