/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import io.mokamint.application.api.Application;
import io.mokamint.application.api.ClosedApplicationException;
import io.mokamint.application.api.UnknownGroupIdException;
import io.mokamint.application.api.UnknownStateException;
import io.mokamint.node.Blocks;
import io.mokamint.node.api.ApplicationTimeoutException;
import io.mokamint.node.api.Block;
import io.mokamint.node.api.ClosedNodeException;
import io.mokamint.node.api.NonGenesisBlock;
import io.mokamint.node.api.NonGenesisBlockDescription;
import io.mokamint.node.api.Transaction;
import io.mokamint.node.api.TransactionRejectedException;
import io.mokamint.node.local.internal.LocalNodeImpl;
import io.mokamint.node.local.internal.Mempool;
import io.mokamint.node.local.internal.MisbehavingApplicationException;
import io.mokamint.node.local.internal.TaskRejectedExecutionException;
import io.mokamint.nonce.api.Deadline;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class TransactionsExecutionTask
implements LocalNodeImpl.Task {
    private final LocalNodeImpl node;
    private final Block previous;
    private final Application app;
    private final Source source;
    private final List<Transaction> successfullyDeliveredTransactions = new ArrayList<Transaction>();
    private final Set<Transaction> rejectedTransactions = new HashSet<Transaction>();
    private final long maxSize;
    private final int id;
    private final CountDownLatch done = new CountDownLatch(1);
    private final Object stopLock = new Object();
    private volatile Future<?> future;
    private static final Logger LOGGER = Logger.getLogger(TransactionsExecutionTask.class.getName());

    public TransactionsExecutionTask(LocalNodeImpl node, Source source, Block previous, LocalDateTime creationTimeOfPrevious) throws InterruptedException, ApplicationTimeoutException, ClosedNodeException, UnknownStateException, ClosedApplicationException {
        this.node = node;
        this.previous = previous;
        this.maxSize = node.getConfig().getMaxBlockSize();
        this.app = node.getApplication();
        this.source = source;
        try {
            this.id = this.app.beginBlock(previous.getDescription().getHeight() + 1L, creationTimeOfPrevious, previous.getStateId());
        }
        catch (TimeoutException e) {
            throw new ApplicationTimeoutException(e);
        }
    }

    public void start() throws TaskRejectedExecutionException {
        this.future = this.node.submit(this, "transactions execution over block " + this.previous.getHexHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.stopLock;
        synchronized (object) {
            this.future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void body() {
        long sizeUpToNow = 0L;
        try {
            while (true) {
                sizeUpToNow = this.processNextTransaction(this.source.take(), sizeUpToNow);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.done.countDown();
        }
        catch (ClosedApplicationException | ApplicationTimeoutException | MisbehavingApplicationException e) {
            try {
                LOGGER.warning("mining: transactions execution stops here because of an application problem: " + e.getMessage());
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.done.countDown();
            }
        }
    }

    public NonGenesisBlock getBlock(Deadline deadline) throws InterruptedException, ApplicationTimeoutException, MisbehavingApplicationException, ClosedApplicationException, InvalidKeyException, SignatureException {
        byte[] finalStateId;
        this.done.await();
        try {
            finalStateId = this.app.endBlock(this.id, deadline);
        }
        catch (TimeoutException e) {
            throw new ApplicationTimeoutException(e);
        }
        catch (UnknownGroupIdException e) {
            throw new MisbehavingApplicationException(e);
        }
        return Blocks.of((NonGenesisBlockDescription)this.previous.getNextBlockDescription(deadline), this.successfullyDeliveredTransactions.stream(), (byte[])finalStateId, (PrivateKey)this.node.getKeys().getPrivate());
    }

    void commitBlock() throws InterruptedException, ApplicationTimeoutException, MisbehavingApplicationException, ClosedApplicationException {
        this.done.await();
        try {
            this.app.commitBlock(this.id);
        }
        catch (TimeoutException e) {
            throw new ApplicationTimeoutException(e);
        }
        catch (UnknownGroupIdException e) {
            throw new MisbehavingApplicationException(e);
        }
    }

    void abortBlock() throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
        try {
            this.done.await();
        }
        finally {
            try {
                this.app.abortBlock(this.id);
            }
            catch (TimeoutException e) {
                throw new ApplicationTimeoutException(e);
            }
            catch (UnknownGroupIdException e) {
                throw new MisbehavingApplicationException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long processNextTransaction(Mempool.TransactionEntry next, long sizeUpToNow) throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
        int txSize;
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted");
        }
        Transaction tx = next.getTransaction();
        if (!this.successfullyDeliveredTransactions.contains(tx) && !this.rejectedTransactions.contains(tx) && sizeUpToNow + (long)(txSize = tx.size()) <= this.maxSize) {
            Object object = this.stopLock;
            synchronized (object) {
                try {
                    this.app.deliverTransaction(this.id, tx);
                }
                catch (TransactionRejectedException e) {
                    LOGGER.warning("mining: delivery of transaction " + String.valueOf(next) + " rejected: " + e.getMessage());
                    this.node.remove(next);
                    this.rejectedTransactions.add(tx);
                    return sizeUpToNow;
                }
                catch (UnknownGroupIdException e) {
                    throw new MisbehavingApplicationException(e);
                }
                catch (TimeoutException e) {
                    throw new ApplicationTimeoutException(e);
                }
                this.successfullyDeliveredTransactions.add(tx);
            }
            return sizeUpToNow + (long)txSize;
        }
        return sizeUpToNow;
    }

    public static interface Source {
        public Mempool.TransactionEntry take() throws InterruptedException;
    }
}

