/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import io.hotmoka.crypto.Hex;
import io.mokamint.application.api.ClosedApplicationException;
import io.mokamint.node.api.ApplicationTimeoutException;
import io.mokamint.node.api.Block;
import io.mokamint.node.api.BlockDescription;
import io.mokamint.node.api.ChainPortion;
import io.mokamint.node.api.ClosedNodeException;
import io.mokamint.node.api.ClosedPeerException;
import io.mokamint.node.api.Peer;
import io.mokamint.node.api.PeerInfo;
import io.mokamint.node.api.PortionRejectedException;
import io.mokamint.node.local.api.LocalNodeConfig;
import io.mokamint.node.local.internal.BlockVerification;
import io.mokamint.node.local.internal.Blockchain;
import io.mokamint.node.local.internal.ClosedDatabaseException;
import io.mokamint.node.local.internal.LocalNodeImpl;
import io.mokamint.node.local.internal.MisbehavingApplicationException;
import io.mokamint.node.local.internal.PeerTimeoutException;
import io.mokamint.node.local.internal.PeersSet;
import io.mokamint.node.local.internal.VerificationException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class Synchronization {
    private final LocalNodeImpl node;
    private final LocalNodeConfig config;
    private final PeersSet peers;
    private final Downloader[] downloaders;
    private final BlockNonContextualVerifier[] nonContextualVerifiers;
    private final BlockAdder[] blockAdders;
    private final SortedSet<Block> blocksDownloadedNotYetProcessed = new TreeSet<Block>(new BlockComparatorByHeight());
    private final SortedSet<Block> blocksToVerify = new TreeSet<Block>(new BlockComparatorByHeight());
    private final SortedSet<Block> blocksPartiallyVerified = new TreeSet<Block>(new BlockComparatorByHeight());
    private final ConcurrentMap<String, Block> hashToBlock = new ConcurrentHashMap<String, Block>();
    private final int synchronizationGroupSize;
    private final long startingHeight;
    private final Blockchain blockchain;
    private final ExecutorService executors;
    private final Semaphore blockAddersHaveTerminated = new Semaphore(0);
    private static final Logger LOGGER = Logger.getLogger(Synchronization.class.getName());
    private final AtomicInteger processingCounter = new AtomicInteger();

    public Synchronization(LocalNodeImpl node, ExecutorService executors) throws InterruptedException, ClosedNodeException, ClosedDatabaseException {
        LOGGER.info("sync: synchronization starts");
        this.node = node;
        this.config = node.getConfig();
        this.peers = node.getPeers();
        this.synchronizationGroupSize = this.config.getSynchronizationGroupSize();
        this.blockchain = node.getBlockchain();
        this.executors = executors;
        this.startingHeight = Math.max(this.blockchain.getStartOfNonFrozenPart().map(Block::getDescription).map(BlockDescription::getHeight).orElse(0L), this.blockchain.getHeightOfHead().orElse(0L) - 1000L);
        this.downloaders = this.mkBlockDownloaders();
        this.nonContextualVerifiers = this.mkNonContextualVerifiers();
        this.blockAdders = this.mkBlockAdders();
        this.startBlockAdders();
        this.startNonContextualVerifiers();
        this.startBlockDownloaders();
        this.waitUntilBlockAddersTerminate();
        LOGGER.info("sync: synchronization stops");
    }

    private void waitUntilBlockAddersTerminate() throws InterruptedException {
        this.blockAddersHaveTerminated.acquire(this.blockAdders.length);
    }

    private void startBlockAdders() {
        for (BlockAdder adder : this.blockAdders) {
            this.executors.submit(adder::run);
        }
    }

    private void startBlockDownloaders() {
        for (Downloader downloader : this.downloaders) {
            this.executors.submit(downloader::run);
        }
    }

    private void startNonContextualVerifiers() {
        for (BlockNonContextualVerifier verifier : this.nonContextualVerifiers) {
            this.executors.submit(verifier::run);
        }
    }

    private Downloader[] mkBlockDownloaders() {
        return (Downloader[])this.peers.get().filter(PeerInfo::isConnected).map(PeerInfo::getPeer).map(x$0 -> new Downloader((Peer)x$0)).toArray(Downloader[]::new);
    }

    private BlockNonContextualVerifier[] mkNonContextualVerifiers() {
        return (BlockNonContextualVerifier[])IntStream.range(0, 1 + Runtime.getRuntime().availableProcessors() / 2).mapToObj(x$0 -> new BlockNonContextualVerifier(x$0)).toArray(BlockNonContextualVerifier[]::new);
    }

    private BlockAdder[] mkBlockAdders() {
        return (BlockAdder[])IntStream.range(0, 1 + Runtime.getRuntime().availableProcessors() / 2).mapToObj(x$0 -> new BlockAdder(x$0)).toArray(BlockAdder[]::new);
    }

    private synchronized boolean requestToDownload(String blockHash, Downloader downloader) {
        for (Downloader other : this.downloaders) {
            if (!other.blocksRequestedByThis.contains(blockHash)) continue;
            downloader.blocksRequestedByThis.add(blockHash);
            return false;
        }
        downloader.blocksRequestedByThis.add(blockHash);
        return true;
    }

    private void cleanUpDownloaders() {
        long minHeight = this.minimalHeightStillToProcess();
        for (Map.Entry entry : this.hashToBlock.entrySet()) {
            Block block = (Block)entry.getValue();
            if (block.getDescription().getHeight() >= minHeight) continue;
            String blockHash = (String)entry.getKey();
            this.hashToBlock.remove(blockHash);
            for (Downloader downloader : this.downloaders) {
                downloader.blocksAddedToProcessByThis.remove(block);
                downloader.blocksRequestedByThis.remove(blockHash);
            }
        }
    }

    private boolean allDownloadersHaveTerminated() {
        for (Downloader downloader : this.downloaders) {
            if (downloader.terminated) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToProcess(Block block, Downloader downloader) throws InterruptedException {
        downloader.queueHasSpace.acquire();
        downloader.blocksAddedToProcessByThis.add(block);
        SortedSet<Block> sortedSet = this.blocksDownloadedNotYetProcessed;
        synchronized (sortedSet) {
            this.blocksDownloadedNotYetProcessed.add(block);
        }
        sortedSet = this.blocksToVerify;
        synchronized (sortedSet) {
            this.blocksToVerify.add(block);
            this.blocksToVerify.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAsProcessed(Block block) {
        Downloader[] downloaderArray = this.blocksDownloadedNotYetProcessed;
        synchronized (this.blocksDownloadedNotYetProcessed) {
            this.blocksDownloadedNotYetProcessed.remove(block);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (Downloader downloader : this.downloaders) {
                if (!downloader.blocksAddedToProcessByThis.contains(block)) continue;
                downloader.queueHasSpace.release();
            }
            if (this.processingCounter.incrementAndGet() % 1000 == 0) {
                this.cleanUpDownloaders();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long minimalHeightStillToProcess() {
        long result = Long.MAX_VALUE;
        for (Downloader downloader : this.downloaders) {
            if (downloader.terminated) continue;
            result = Math.min(result, downloader.getHeight());
        }
        SortedSet<Block> sortedSet = this.blocksDownloadedNotYetProcessed;
        synchronized (sortedSet) {
            if (!this.blocksDownloadedNotYetProcessed.isEmpty()) {
                result = Math.min(result, this.blocksDownloadedNotYetProcessed.first().getDescription().getHeight());
            }
        }
        return result;
    }

    private boolean allNonContextualVerifiersHaveTerminated() {
        for (BlockNonContextualVerifier verifier : this.nonContextualVerifiers) {
            if (verifier.terminated) continue;
            return false;
        }
        return true;
    }

    private void banDownloadersOf(String blockHash) throws ClosedDatabaseException {
        for (Downloader downloader : this.downloaders) {
            if (downloader.terminated || !downloader.blocksRequestedByThis.contains(blockHash)) continue;
            downloader.banOnIllegalBlock();
        }
    }

    private static class BlockComparatorByHeight
    implements Comparator<Block> {
        private BlockComparatorByHeight() {
        }

        @Override
        public int compare(Block block1, Block block2) {
            int diff = Long.compare(block1.getDescription().getHeight(), block2.getDescription().getHeight());
            if (diff != 0) {
                return diff;
            }
            return Arrays.compare(block1.getHash(), block2.getHash());
        }
    }

    private class Downloader {
        private final Peer peer;
        private volatile boolean terminated;
        private long height;
        private final Set<String> blocksRequestedByThis = ConcurrentHashMap.newKeySet();
        private final Set<Block> blocksAddedToProcessByThis = ConcurrentHashMap.newKeySet();
        private final Semaphore queueHasSpace;

        private Downloader(Peer peer) {
            this.queueHasSpace = new Semaphore(Synchronization.this.synchronizationGroupSize * 2);
            this.peer = peer;
            this.height = Synchronization.this.startingHeight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run() {
            try {
                byte[][] hashes;
                Optional<byte[][]> maybeHashes;
                Optional<byte[]> lastHashOfPreviousGroup = Optional.empty();
                while (!this.terminated && !(maybeHashes = this.downloadNextGroupOfBlockHashes(lastHashOfPreviousGroup)).isEmpty() && (hashes = maybeHashes.get()).length != 0) {
                    if (!this.downloadNextGroupOfBlocks(hashes)) {
                        return;
                    }
                    if (hashes.length < Synchronization.this.synchronizationGroupSize) break;
                    lastHashOfPreviousGroup = Optional.of(hashes[hashes.length - 1]);
                    Downloader downloader = this;
                    synchronized (downloader) {
                        this.height += (long)(Synchronization.this.synchronizationGroupSize - 1);
                    }
                }
                LOGGER.info("sync: block downloading from " + String.valueOf(this.peer) + " stops because no useful hashes have been provided anymore by the peer");
            }
            catch (ClosedPeerException e) {
                LOGGER.warning("sync: block downloading from " + String.valueOf(this.peer) + " stops because the peer is already closed: " + e.getMessage());
            }
            catch (PortionRejectedException e) {
                LOGGER.warning("sync: block downloading from " + String.valueOf(this.peer) + " stops because the peer rejected a request for fetching block hashes: " + e.getMessage());
            }
            catch (PeerTimeoutException e) {
                LOGGER.warning("sync: block downloading from " + String.valueOf(this.peer) + " stops because the peer is not answering: " + e.getMessage());
            }
            catch (ClosedDatabaseException e) {
                LOGGER.warning("sync: block downloading from " + String.valueOf(this.peer) + " stops because the database has been closed: " + e.getMessage());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warning("sync: block downloading from " + String.valueOf(this.peer) + " has been interrupted");
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "sync: block downloading from " + String.valueOf(this.peer) + " stops because the node is misbehaving", e);
            }
            finally {
                this.terminated = true;
                SortedSet<Block> e = Synchronization.this.blocksToVerify;
                synchronized (e) {
                    Synchronization.this.blocksToVerify.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void banOnIllegalBlock() throws ClosedDatabaseException {
            this.terminated = true;
            Synchronization.this.peers.ban(this.peer);
            HashSet<Block> toRemove = new HashSet<Block>(this.blocksAddedToProcessByThis);
            for (Downloader downloader : Synchronization.this.downloaders) {
                if (downloader == this) continue;
                toRemove.removeAll(downloader.blocksAddedToProcessByThis);
            }
            SortedSet<Block> sortedSet = Synchronization.this.blocksDownloadedNotYetProcessed;
            synchronized (sortedSet) {
                Synchronization.this.blocksDownloadedNotYetProcessed.removeAll(toRemove);
            }
            SortedSet<Block> sortedSet2 = Synchronization.this.blocksToVerify;
            synchronized (sortedSet2) {
                Synchronization.this.blocksToVerify.removeAll(toRemove);
            }
            SortedSet<Block> sortedSet3 = Synchronization.this.blocksPartiallyVerified;
            synchronized (sortedSet3) {
                Synchronization.this.blocksPartiallyVerified.removeAll(toRemove);
            }
        }

        private synchronized long getHeight() {
            return this.height;
        }

        private boolean downloadNextGroupOfBlocks(byte[][] hashes) throws InterruptedException, ClosedPeerException, PeerTimeoutException, ClosedDatabaseException {
            String blockHash;
            byte[] hash;
            int pos;
            Block[] blocks = new Block[hashes.length];
            int n = pos = this.height == Synchronization.this.startingHeight ? 0 : 1;
            while (pos < hashes.length) {
                if (this.terminated) {
                    return false;
                }
                hash = hashes[pos];
                blockHash = Hex.toHexString((byte[])hash);
                if (Synchronization.this.requestToDownload(blockHash, this) && this.downloadBlock(blocks, pos, hash, blockHash).isEmpty()) {
                    return false;
                }
                ++pos;
            }
            int n2 = pos = this.height == Synchronization.this.startingHeight ? 0 : 1;
            while (pos < hashes.length) {
                if (this.terminated) {
                    return false;
                }
                if (blocks[pos] == null && (blocks[pos] = (Block)Synchronization.this.hashToBlock.get(blockHash = Hex.toHexString((byte[])(hash = hashes[pos])))) == null && this.downloadBlock(blocks, pos, hash, blockHash).isEmpty()) {
                    return false;
                }
                ++pos;
            }
            return true;
        }

        private Optional<Block> downloadBlock(Block[] blocks, int pos, byte[] hash, String blockHash) throws InterruptedException, ClosedPeerException, PeerTimeoutException, ClosedDatabaseException {
            Optional<Block> maybeBlock = Synchronization.this.peers.getBlock(this.peer, hash);
            if (maybeBlock.isPresent()) {
                Block block = maybeBlock.get();
                if (!Arrays.equals(hash, block.getHash())) {
                    LOGGER.warning("sync: block downloading from " + String.valueOf(this.peer) + " stops because the peer answered with a block for the wrong hash");
                    Synchronization.this.peers.ban(this.peer);
                    return Optional.empty();
                }
                Synchronization.this.hashToBlock.put(blockHash, block);
                blocks[pos] = block;
                Synchronization.this.addToProcess(block, this);
                return maybeBlock;
            }
            LOGGER.warning("sync: block downloading from " + String.valueOf(this.peer) + " stops because the peer cannot find the block for a hash that it provided");
            return Optional.empty();
        }

        private Optional<byte[][]> downloadNextGroupOfBlockHashes(Optional<byte[]> lastHashOfPreviousGroup) throws InterruptedException, ClosedPeerException, PeerTimeoutException, ClosedDatabaseException, PortionRejectedException {
            long height = this.getHeight();
            LOGGER.info("sync: downloading from " + String.valueOf(this.peer) + " the hashes of the blocks at height [" + height + ", " + (height + (long)Synchronization.this.synchronizationGroupSize - 1L) + "]");
            Optional<ChainPortion> maybeChain = Synchronization.this.peers.getChainPortion(this.peer, height, Synchronization.this.synchronizationGroupSize);
            if (maybeChain.isPresent()) {
                Optional<byte[]> genesisHash;
                byte[][] hashes = (byte[][])maybeChain.get().getHashes().toArray(x$0 -> new byte[x$0][]);
                if (hashes.length > Synchronization.this.synchronizationGroupSize + 1) {
                    Synchronization.this.peers.ban(this.peer);
                    return Optional.empty();
                }
                if (hashes.length > 0 && lastHashOfPreviousGroup.isPresent() && !Arrays.equals(hashes[0], lastHashOfPreviousGroup.get())) {
                    return Optional.empty();
                }
                if (hashes.length > 0 && height == 0L && (genesisHash = Synchronization.this.blockchain.getGenesisHash()).isPresent() && !Arrays.equals(hashes[0], genesisHash.get())) {
                    Synchronization.this.peers.ban(this.peer);
                    return Optional.empty();
                }
                return Optional.of(hashes);
            }
            return Optional.empty();
        }
    }

    private class BlockNonContextualVerifier {
        private final int num;
        private volatile boolean terminated;

        private BlockNonContextualVerifier(int num) {
            this.num = num;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void run() {
            try {
                while (true) {
                    SortedSet<Block> sortedSet = Synchronization.this.blocksToVerify;
                    // MONITORENTER : sortedSet
                    while (Synchronization.this.blocksToVerify.isEmpty() && !Synchronization.this.allDownloadersHaveTerminated()) {
                        Synchronization.this.blocksToVerify.wait();
                    }
                    if (Synchronization.this.blocksToVerify.isEmpty()) {
                        LOGGER.info("sync: non-contextual block verifier #" + this.num + " stops since there are no more blocks to verify");
                        // MONITOREXIT : sortedSet
                        return;
                    }
                    Block block = Synchronization.this.blocksToVerify.removeFirst();
                    // MONITOREXIT : sortedSet
                    try {
                        if (!Synchronization.this.blockchain.containsBlock(block.getHash())) {
                            new BlockVerification(null, Synchronization.this.node, Synchronization.this.config, block, Optional.empty(), BlockVerification.Mode.ABSOLUTE);
                        }
                        sortedSet = Synchronization.this.blocksPartiallyVerified;
                        // MONITORENTER : sortedSet
                        Synchronization.this.blocksPartiallyVerified.add(block);
                        Synchronization.this.blocksPartiallyVerified.notifyAll();
                        // MONITOREXIT : sortedSet
                    }
                    catch (VerificationException e) {
                        Synchronization.this.markAsProcessed(block);
                        String blockHash = block.getHexHash();
                        LOGGER.warning("sync: non-contextual verification of block " + blockHash + " failed, I'm banning all peers that downloaded that block: " + e.getMessage());
                        Synchronization.this.banDownloadersOf(blockHash);
                    }
                    continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warning("sync: non-contextual block verifier #" + this.num + " has been interrupted");
                return;
            }
            catch (ClosedApplicationException | ApplicationTimeoutException | MisbehavingApplicationException e) {
                LOGGER.warning("sync: non-contextual block verifier #" + this.num + " stops since the application is misbehaving: " + e.getMessage());
                return;
            }
            catch (ClosedDatabaseException e) {
                LOGGER.warning("sync: non-contextual block verifier #" + this.num + " stops because the database has been closed: " + e.getMessage());
                return;
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "sync: non-contextual block verifier #" + this.num + " stops since the node is misbehaving", e);
                return;
            }
            finally {
                this.terminated = true;
                SortedSet<Block> e = Synchronization.this.blocksPartiallyVerified;
            }
        }
    }

    private class BlockAdder {
        private final int num;

        private BlockAdder(int num) {
            this.num = num;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void run() {
            try {
                while (true) {
                    SortedSet<Block> sortedSet = Synchronization.this.blocksPartiallyVerified;
                    synchronized (sortedSet) {
                        block28: {
                            while (Synchronization.this.blocksPartiallyVerified.isEmpty() && !Synchronization.this.allNonContextualVerifiersHaveTerminated()) {
                                Synchronization.this.blocksPartiallyVerified.wait();
                            }
                            if (!Synchronization.this.blocksPartiallyVerified.isEmpty()) break block28;
                            LOGGER.info("sync: block adder #" + this.num + " stops since there are no more blocks to add");
                            return;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        if (Synchronization.this.blocksPartiallyVerified.first().getDescription().getHeight() > Synchronization.this.minimalHeightStillToProcess()) {
                            Synchronization.this.blocksPartiallyVerified.wait(100L);
                            continue;
                        }
                        Block block = Synchronization.this.blocksPartiallyVerified.removeFirst();
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 4, 24, 11] lbl20 : MonitorExitStatement: MONITOREXIT : var2_6
                        String blockHash = block.getHexHash();
                        try {
                            if (!Synchronization.this.blockchain.connect(block, Optional.of(BlockVerification.Mode.RELATIVE))) {
                                LOGGER.warning("sync: block " + blockHash + " could not be connected: I'm banning all peers that downloaded that block");
                                Synchronization.this.banDownloadersOf(blockHash);
                            }
                        }
                        catch (VerificationException e) {
                            LOGGER.warning("sync: contextual verification of block " + blockHash + " failed, I'm banning all peers that downloaded that block: " + e.getMessage());
                            Synchronization.this.banDownloadersOf(blockHash);
                        }
                        finally {
                            Synchronization.this.markAsProcessed(block);
                        }
                        SortedSet<Block> sortedSet2 = Synchronization.this.blocksPartiallyVerified;
                        synchronized (sortedSet2) {
                            Synchronization.this.blocksPartiallyVerified.notifyAll();
                        }
                    }
                }
                {
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.warning("sync: block adder #" + this.num + " has been interrupted");
                        return;
                    }
                    catch (ClosedApplicationException | ApplicationTimeoutException | MisbehavingApplicationException e) {
                        LOGGER.warning("sync: block adder #" + this.num + " stops because of an application problem: " + e.getMessage());
                        return;
                    }
                    catch (ClosedDatabaseException e) {
                        LOGGER.warning("sync: block adder #" + this.num + " stops because the database has been closed: " + e.getMessage());
                        return;
                    }
                    catch (RuntimeException e) {
                        LOGGER.log(Level.SEVERE, "sync: block adder #" + this.num + " stops because the node is misbehaving", e);
                        return;
                    }
                }
            }
            finally {
                LOGGER.info("sync: stopped block adder #" + this.num);
                Synchronization.this.blockAddersHaveTerminated.release();
            }
        }
    }
}

