/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

public class PunishableSet<A> {
    private final ConcurrentMap<A, Long> actors = new ConcurrentHashMap<A, Long>();
    private final long initialPoints;

    public PunishableSet(Stream<A> actors, long initialPoints) {
        if (initialPoints <= 0L) {
            throw new IllegalArgumentException("initialPoints must be positive");
        }
        this.initialPoints = initialPoints;
        actors.forEach(actor -> this.actors.put(actor, initialPoints));
    }

    public boolean contains(A actor) {
        return this.actors.containsKey(actor);
    }

    public boolean isEmpty() {
        return this.actors.isEmpty();
    }

    public int size() {
        return this.actors.size();
    }

    public Stream<A> getElements() {
        return this.actors.keySet().stream();
    }

    public Stream<Map.Entry<A, Long>> getActorsWithPoints() {
        return this.actors.entrySet().stream();
    }

    public boolean punish(A actor, long points) {
        if (points < 0L) {
            throw new IllegalArgumentException("points cannot be negative");
        }
        AtomicBoolean result = new AtomicBoolean();
        this.actors.computeIfPresent(actor, (_actor, oldPoints) -> {
            long newPoints = oldPoints - points;
            if (newPoints > 0L) {
                return newPoints;
            }
            result.set(true);
            return null;
        });
        return result.get();
    }

    public long pardon(A actor, long points) {
        if (points < 0L) {
            throw new IllegalArgumentException("points cannot be negative");
        }
        AtomicLong oldPoints = new AtomicLong(0L);
        Long newPoints = this.actors.computeIfPresent(actor, (_actor, old) -> {
            oldPoints.set((long)old);
            return Math.min(this.initialPoints, old + points);
        });
        if (newPoints != null && newPoints > oldPoints.get()) {
            return newPoints - oldPoints.get();
        }
        return 0L;
    }

    public boolean remove(A actor) {
        return this.actors.remove(actor) != null;
    }

    public final boolean add(A actor) {
        AtomicBoolean result = new AtomicBoolean();
        this.actors.computeIfAbsent(actor, _actor -> {
            result.set(true);
            return this.initialPoints;
        });
        return result.get();
    }
}

