/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import io.hotmoka.websockets.api.FailedDeploymentException;
import io.mokamint.node.NodeInfos;
import io.mokamint.node.PeerInfos;
import io.mokamint.node.Peers;
import io.mokamint.node.Versions;
import io.mokamint.node.api.Block;
import io.mokamint.node.api.ChainInfo;
import io.mokamint.node.api.ChainPortion;
import io.mokamint.node.api.ClosedNodeException;
import io.mokamint.node.api.ClosedPeerException;
import io.mokamint.node.api.NodeInfo;
import io.mokamint.node.api.Peer;
import io.mokamint.node.api.PeerInfo;
import io.mokamint.node.api.PeerRejectedException;
import io.mokamint.node.api.PortionRejectedException;
import io.mokamint.node.api.Version;
import io.mokamint.node.api.WhisperMessage;
import io.mokamint.node.api.Whisperer;
import io.mokamint.node.local.api.LocalNodeConfig;
import io.mokamint.node.local.internal.ClosedDatabaseException;
import io.mokamint.node.local.internal.LocalNodeImpl;
import io.mokamint.node.local.internal.PeerTimeoutException;
import io.mokamint.node.local.internal.PeersDatabase;
import io.mokamint.node.local.internal.PunishableSet;
import io.mokamint.node.remote.RemotePublicNodes;
import io.mokamint.node.remote.api.RemotePublicNode;
import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PeersSet
implements AutoCloseable {
    private final LocalNodeImpl node;
    private final LocalNodeConfig config;
    private final PeersDatabase db;
    private final UUID uuid;
    private final Version version;
    private final Object lock = new Object();
    private final PunishableSet<Peer> peers;
    private final Map<Peer, RemotePublicNode> remotes = new HashMap<Peer, RemotePublicNode>();
    private final Map<Peer, Long> timeDifferences = new HashMap<Peer, Long>();
    private final Set<URI> bannedURIs = new HashSet<URI>();
    private static final Logger LOGGER = Logger.getLogger(PeersSet.class.getName());

    public PeersSet(LocalNodeImpl node) throws InterruptedException, ClosedNodeException {
        this.node = node;
        this.config = node.getConfig();
        try {
            this.version = Versions.current();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.db = new PeersDatabase(node);
        try {
            this.uuid = this.db.getUUID();
            this.peers = new PunishableSet<Peer>(this.db.getPeers(), this.config.getPeerInitialPoints());
            Set seeds = this.config.getSeeds().map(Peers::of).collect(Collectors.toSet());
            HashSet<Peer> all = new HashSet<Peer>(seeds);
            all.addAll(this.peers.getElements().collect(Collectors.toSet()));
            this.reconnectOrAdd(all, seeds::contains);
        }
        catch (ClosedNodeException e) {
            this.close();
            throw e;
        }
        catch (ClosedDatabaseException e) {
            throw new RuntimeException("The databse of peers has been unexpectedly closed", e);
        }
        catch (InterruptedException e) {
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<PeerInfo> get() {
        Object object = this.lock;
        synchronized (object) {
            return this.peers.getActorsWithPoints().map(entry -> PeerInfos.of((Peer)((Peer)entry.getKey()), (long)((Long)entry.getValue()), (boolean)this.remotes.containsKey(entry.getKey())));
        }
    }

    public NodeInfo getNodeInfo() {
        return NodeInfos.of((Version)this.version, (UUID)this.uuid, (LocalDateTime)LocalDateTime.now(ZoneId.of("UTC")), (int)this.config.getMaxChainPortionLength(), (int)this.config.getMaxMempoolPortionLength());
    }

    public Optional<PeerInfo> add(Peer peer) throws PeerTimeoutException, ClosedPeerException, InterruptedException, PeerRejectedException, ClosedNodeException, ClosedDatabaseException {
        if (this.reconnectOrAdd(peer, true)) {
            return Optional.of(PeerInfos.of((Peer)peer, (long)this.config.getPeerInitialPoints(), (boolean)true));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Peer peer) throws ClosedDatabaseException {
        boolean removed;
        Object object = this.lock;
        synchronized (object) {
            removed = this.peers.remove(peer);
            if (removed) {
                this.disconnect(peer);
                this.db.remove(peer);
            }
        }
        if (removed) {
            this.node.onRemoved(peer);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ban(Peer peer) throws ClosedDatabaseException {
        Object object = this.lock;
        synchronized (object) {
            this.bannedURIs.add(peer.getURI());
        }
        LOGGER.warning("peers: " + String.valueOf(peer) + " has been banned");
        return this.remove(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whisper(WhisperMessage<?> message, Predicate<Whisperer> seen, String description) {
        Object object = this.lock;
        synchronized (object) {
            this.remotes.forEach((_peer, remote) -> remote.whisper(message, seen, description));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDateTime asNetworkDateTime(LocalDateTime ldt) {
        long averageTimeDifference;
        Object object = this.lock;
        synchronized (object) {
            averageTimeDifference = (long)Stream.concat(this.timeDifferences.values().stream(), Stream.of(Long.valueOf(0L))).mapToLong(Long::valueOf).average().getAsDouble();
        }
        return ldt.plus(averageTimeDifference, ChronoUnit.MILLIS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                HashMap<Peer, RemotePublicNode> copyOfRemotes = new HashMap<Peer, RemotePublicNode>(this.remotes);
                this.remotes.clear();
                this.timeDifferences.clear();
                for (Map.Entry<Peer, RemotePublicNode> entry : copyOfRemotes.entrySet()) {
                    this.disconnect(entry.getKey(), entry.getValue());
                }
            }
        }
        finally {
            this.db.close();
        }
    }

    public Optional<Block> getBlock(Peer peer, byte[] hash) throws InterruptedException, ClosedDatabaseException, ClosedPeerException, PeerTimeoutException {
        Optional<RemotePublicNode> remote = this.getRemote(peer);
        if (remote.isEmpty()) {
            return Optional.empty();
        }
        try {
            return remote.get().getBlock(hash);
        }
        catch (ClosedNodeException e) {
            this.punishBecauseUnreachable(peer);
            throw new ClosedPeerException((Exception)((Object)e));
        }
        catch (TimeoutException e) {
            this.punishBecauseUnreachable(peer);
            throw new PeerTimeoutException(e);
        }
    }

    public Optional<ChainPortion> getChainPortion(Peer peer, long start, int count) throws PeerTimeoutException, InterruptedException, ClosedDatabaseException, ClosedPeerException, PortionRejectedException {
        Optional<RemotePublicNode> remote = this.getRemote(peer);
        if (remote.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(remote.get().getChainPortion(start, count));
        }
        catch (ClosedNodeException e) {
            this.punishBecauseUnreachable(peer);
            throw new ClosedPeerException((Exception)((Object)e));
        }
        catch (TimeoutException e) {
            this.punishBecauseUnreachable(peer);
            throw new PeerTimeoutException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pingAllAndReconnect() throws InterruptedException, ClosedNodeException, ClosedDatabaseException {
        Set peers;
        Object object = this.lock;
        synchronized (object) {
            peers = this.peers.getElements().collect(Collectors.toSet());
        }
        HashSet<Peer> unknownPeers = new HashSet<Peer>();
        boolean addedOrReconnected = false;
        for (Peer peer : peers) {
            addedOrReconnected |= this.reconnectAndCollectUnknownPeers(peer, unknownPeers);
        }
        return this.reconnectOrAdd(unknownPeers, _peer -> false) || addedOrReconnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void punishBecauseUnreachable(Peer peer) throws ClosedDatabaseException {
        boolean removed = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.peers.contains(peer)) {
                long lost = this.config.getPeerPunishmentForUnreachable();
                removed = this.peers.punish(peer, lost);
                if (removed) {
                    this.disconnect(peer);
                    this.db.remove(peer);
                }
                LOGGER.warning("peers: " + String.valueOf(peer) + " lost " + lost + " points because it is unreachable");
            }
        }
        if (removed) {
            this.node.onRemoved(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<RemotePublicNode> getRemote(Peer peer) {
        Object object = this.lock;
        synchronized (object) {
            return Optional.ofNullable(this.remotes.get(peer));
        }
    }

    private void pardonBecauseReachable(Peer peer) {
        long gained = this.peers.pardon(peer, this.config.getPeerPunishmentForUnreachable());
        if (gained > 0L) {
            LOGGER.info("peers: " + String.valueOf(peer) + " gained " + gained + " points because it is reachable");
        }
    }

    private boolean reconnectAndCollectUnknownPeers(Peer peer, Set<Peer> container) throws InterruptedException, ClosedNodeException, ClosedDatabaseException {
        boolean reconnected = false;
        Optional<RemotePublicNode> remote = this.getRemote(peer);
        if (remote.isEmpty() && (remote = this.reconnect(peer)).isPresent()) {
            reconnected = true;
        }
        if (remote.isPresent()) {
            this.collectUnknownPeers(peer, remote.get(), container);
        }
        return reconnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectUnknownPeers(Peer peer, RemotePublicNode remote, Set<Peer> container) throws ClosedDatabaseException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.peers.size() < this.config.getMaxPeers()) {
                try {
                    Stream peerInfos = remote.getPeerInfos();
                    this.pardonBecauseReachable(peer);
                    peerInfos.filter(PeerInfo::isConnected).map(PeerInfo::getPeer).filter(Predicate.not(this.peers::contains)).forEach(container::add);
                }
                catch (ClosedNodeException | TimeoutException e) {
                    LOGGER.warning("peers: cannot contact " + String.valueOf(peer) + ": " + e.getMessage());
                    this.punishBecauseUnreachable(peer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reconnectOrAdd(Peer peer, boolean force) throws InterruptedException, ClosedPeerException, PeerRejectedException, PeerTimeoutException, ClosedNodeException, ClosedDatabaseException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bannedURIs.contains(peer.getURI())) {
                throw new PeerRejectedException("Peer " + String.valueOf(peer) + " is in the list of banned peers");
            }
            if (this.peers.contains(peer)) {
                return !this.remotes.containsKey(peer) && this.reconnect(peer).isPresent();
            }
            return this.add(peer, force);
        }
    }

    private boolean reconnectOrAdd(Set<Peer> peers, Predicate<Peer> force) throws InterruptedException, ClosedNodeException, ClosedDatabaseException {
        boolean somethingChanged = false;
        for (Peer peer : peers) {
            try {
                somethingChanged |= this.reconnectOrAdd(peer, force.test(peer));
            }
            catch (ClosedPeerException | PeerRejectedException | PeerTimeoutException e) {
                LOGGER.warning("peers: cannot connect to " + String.valueOf(peer) + ": " + e.getMessage());
            }
        }
        return somethingChanged;
    }

    private boolean add(Peer peer, boolean force) throws PeerRejectedException, ClosedPeerException, PeerTimeoutException, InterruptedException, ClosedNodeException, ClosedDatabaseException {
        boolean added = false;
        if (force || this.peers.size() < this.config.getMaxPeers()) {
            RemotePublicNode remote = null;
            try {
                remote = this.openRemote(peer);
                long timeDifference = this.ensurePeerIsCompatible(remote);
                if (this.db.add(peer, force) && this.peers.add(peer)) {
                    this.connect(peer, remote, timeDifference);
                    added = true;
                    this.node.onConnected(peer);
                    this.node.onAdded(peer);
                }
            }
            catch (FailedDeploymentException e) {
                throw new PeerRejectedException("The peer has been rejected since it is unreachable", (Throwable)e);
            }
            finally {
                if (remote != null && !added) {
                    remote.close();
                }
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<RemotePublicNode> reconnect(Peer peer) throws ClosedNodeException, ClosedDatabaseException, InterruptedException {
        try {
            LOGGER.info("peers: trying to connect to " + String.valueOf(peer));
            boolean connected = false;
            RemotePublicNode remote = null;
            try {
                RemotePublicNode remoteCopy = remote = this.openRemote(peer);
                long timeDifference = this.ensurePeerIsCompatible(remote);
                Optional<RemotePublicNode> optional = this.lock;
                synchronized (optional) {
                    if (this.peers.contains(peer) && !this.remotes.containsKey(peer)) {
                        this.connect(peer, remote, timeDifference);
                        connected = true;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 11] lbl13 : MonitorExitStatement: MONITOREXIT : var7_8
                        this.node.onConnected(peer);
                        optional = Optional.of(remoteCopy);
                        return optional;
                    }
                    Optional<RemotePublicNode> optional2 = Optional.of(remote);
                    return optional2;
                }
            }
            finally {
                if (remote != null && !connected) {
                    remote.close();
                }
            }
        }
        catch (FailedDeploymentException | ClosedPeerException | PeerTimeoutException e) {
            LOGGER.log(Level.WARNING, "peers: cannot contact " + String.valueOf(peer) + ": " + e.getMessage());
            this.punishBecauseUnreachable(peer);
            return Optional.empty();
        }
        catch (PeerRejectedException e) {
            LOGGER.log(Level.WARNING, "peers: " + e.getMessage());
            this.remove(peer);
        }
        return Optional.empty();
    }

    private long ensurePeerIsCompatible(RemotePublicNode remote) throws PeerRejectedException, ClosedNodeException, ClosedPeerException, PeerTimeoutException, InterruptedException {
        ChainInfo nodeChainInfo;
        Optional nodeGenesisHash;
        ChainInfo peerChainInfo;
        NodeInfo peerInfo;
        try {
            peerInfo = remote.getInfo();
        }
        catch (ClosedNodeException e) {
            throw new ClosedPeerException((Exception)((Object)e));
        }
        catch (TimeoutException e) {
            throw new PeerTimeoutException(e);
        }
        NodeInfo nodeInfo = this.getNodeInfo();
        long timeDifference = ChronoUnit.MILLIS.between(nodeInfo.getLocalDateTimeUTC(), peerInfo.getLocalDateTimeUTC());
        if (Math.abs(timeDifference) > (long)this.config.getPeerMaxTimeDifference()) {
            throw new PeerRejectedException("The time of the peer is more than " + this.config.getPeerMaxTimeDifference() + " ms away from the time of this node");
        }
        UUID peerUUID = peerInfo.getUUID();
        if (peerUUID.equals(this.uuid)) {
            throw new PeerRejectedException("A peer cannot be added as a peer of itself: same UUID " + String.valueOf(peerUUID));
        }
        Version peerVersion = peerInfo.getVersion();
        if (!peerVersion.canWorkWith(this.version)) {
            throw new PeerRejectedException("Peer version " + String.valueOf(peerVersion) + " is incompatible with this node's version " + String.valueOf(this.version));
        }
        try {
            peerChainInfo = remote.getChainInfo();
        }
        catch (ClosedNodeException e) {
            throw new ClosedPeerException((Exception)((Object)e));
        }
        catch (TimeoutException e) {
            throw new PeerTimeoutException(e);
        }
        Optional peerGenesisHash = peerChainInfo.getGenesisHash();
        if (peerGenesisHash.isPresent() && (nodeGenesisHash = (nodeChainInfo = this.node.getChainInfo()).getGenesisHash()).isPresent() && !Arrays.equals((byte[])peerGenesisHash.get(), (byte[])nodeGenesisHash.get())) {
            throw new PeerRejectedException("The peers have distinct genesis blocks");
        }
        return timeDifference;
    }

    private RemotePublicNode openRemote(Peer peer) throws InterruptedException, FailedDeploymentException, PeerTimeoutException {
        try {
            return RemotePublicNodes.of((URI)peer.getURI(), (int)this.config.getPeerTimeout(), (int)-1, (int)this.config.getWhisperingMemorySize());
        }
        catch (TimeoutException e) {
            throw new PeerTimeoutException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRemoteClosed(Peer peer) {
        Object object = this.lock;
        synchronized (object) {
            this.disconnect(peer);
        }
    }

    private void connect(Peer peer, RemotePublicNode remote, long timeDifference) {
        this.remotes.put(peer, remote);
        this.timeDifferences.put(peer, timeDifference);
        remote.bindWhisperer((Whisperer)this.node);
        remote.addOnCloseHandler(() -> this.onRemoteClosed(peer));
    }

    private void disconnect(Peer peer) {
        RemotePublicNode remote = this.remotes.get(peer);
        if (remote != null) {
            this.remotes.remove(peer);
            this.timeDifferences.remove(peer);
            this.disconnect(peer, remote);
        }
    }

    private void disconnect(Peer peer, RemotePublicNode remote) {
        remote.unbindWhisperer((Whisperer)this.node);
        remote.close();
        this.node.onDisconnected(peer);
    }
}

