/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import io.hotmoka.closeables.AbstractAutoCloseableWithLock;
import io.hotmoka.closeables.api.ClosureLock;
import io.hotmoka.marshalling.AbstractMarshallable;
import io.hotmoka.marshalling.UnmarshallingContexts;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.hotmoka.xodus.ByteIterable;
import io.hotmoka.xodus.ExodusException;
import io.hotmoka.xodus.env.Environment;
import io.hotmoka.xodus.env.Store;
import io.hotmoka.xodus.env.Transaction;
import io.mokamint.node.Peers;
import io.mokamint.node.api.ClosedNodeException;
import io.mokamint.node.api.Peer;
import io.mokamint.node.local.LocalNodeException;
import io.mokamint.node.local.api.LocalNodeConfig;
import io.mokamint.node.local.internal.ClosedDatabaseException;
import io.mokamint.node.local.internal.LocalNodeImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class PeersDatabase
extends AbstractAutoCloseableWithLock<ClosedDatabaseException> {
    private final int maxPeers;
    private final Environment environment;
    private final Store storeOfPeers;
    private static final ByteIterable PEERS = ByteIterable.fromByte((byte)17);
    private static final ByteIterable UUID = ByteIterable.fromByte((byte)23);
    private static final Logger LOGGER = Logger.getLogger(PeersDatabase.class.getName());

    public PeersDatabase(LocalNodeImpl node) throws ClosedNodeException {
        super(ClosedDatabaseException::new);
        LocalNodeConfig config = node.getConfig();
        this.maxPeers = config.getMaxPeers();
        this.environment = this.createPeersEnvironment(config);
        this.storeOfPeers = this.openStore("peers");
        this.ensureNodeUUID();
    }

    public void close() {
        try {
            if (this.stopNewCalls()) {
                try {
                    this.environment.close();
                    LOGGER.info("db: closed the peers database");
                }
                catch (ExodusException e) {
                    LOGGER.log(Level.SEVERE, "db: failed to close the peers database", e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public UUID getUUID() throws ClosedDatabaseException {
        UUID uUID;
        block9: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                ByteIterable bi = (ByteIterable)this.environment.computeInReadonlyTransaction(txn -> this.storeOfPeers.get(txn, UUID));
                if (bi == null) {
                    throw new LocalNodeException("The UUID of the node is not in the peers database");
                }
                uUID = MarshallableUUID.from((ByteIterable)bi).uuid;
                if (scope == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException | IOException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return uUID;
    }

    public Stream<Peer> getPeers() throws ClosedDatabaseException {
        Stream<Peer> stream;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                ByteIterable bi = (ByteIterable)this.environment.computeInReadonlyTransaction(txn -> this.storeOfPeers.get(txn, PEERS));
                Stream<Peer> stream2 = stream = bi == null ? Stream.empty() : ArrayOfPeers.from(bi).stream();
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException | IOException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return stream;
    }

    public boolean add(Peer peer, boolean force) throws ClosedDatabaseException {
        boolean bl;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                bl = (Boolean)this.environment.computeInTransaction(txn -> this.add((Transaction)txn, peer, force));
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return bl;
    }

    public boolean remove(Peer peer) throws ClosedDatabaseException {
        boolean bl;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                bl = (Boolean)this.environment.computeInTransaction(txn -> this.remove((Transaction)txn, peer));
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return bl;
    }

    private void ensureNodeUUID() {
        this.environment.executeInTransaction(txn -> {
            try {
                ByteIterable bi = this.storeOfPeers.get(txn, UUID);
                if (bi == null) {
                    UUID nodeUUID = java.util.UUID.randomUUID();
                    this.storeOfPeers.put(txn, UUID, ByteIterable.fromBytes((byte[])new MarshallableUUID(nodeUUID).toByteArray()));
                    LOGGER.info("db: created a new UUID for the node: " + String.valueOf(nodeUUID));
                } else {
                    LOGGER.info("db: the UUID of the node is " + String.valueOf(MarshallableUUID.from((ByteIterable)bi).uuid));
                }
            }
            catch (ExodusException | IOException e) {
                throw new LocalNodeException(e);
            }
        });
    }

    private boolean add(Transaction txn, Peer peer, boolean force) {
        try {
            ByteIterable bi = this.storeOfPeers.get(txn, PEERS);
            if (bi == null) {
                if (force || this.maxPeers >= 1) {
                    this.storeOfPeers.put(txn, PEERS, new ArrayOfPeers(Stream.of(peer)).toByteIterable());
                    return true;
                }
                return false;
            }
            ArrayOfPeers aop = ArrayOfPeers.from(bi);
            if (aop.contains(peer) || !force && aop.length() >= this.maxPeers) {
                return false;
            }
            Stream<Peer> concat = Stream.concat(aop.stream(), Stream.of(peer));
            this.storeOfPeers.put(txn, PEERS, new ArrayOfPeers(concat).toByteIterable());
            return true;
        }
        catch (ExodusException | IOException e) {
            throw new LocalNodeException(e);
        }
    }

    private boolean remove(Transaction txn, Peer peer) {
        try {
            ByteIterable bi = this.storeOfPeers.get(txn, PEERS);
            if (bi == null) {
                return false;
            }
            ArrayOfPeers aop = ArrayOfPeers.from(bi);
            if (aop.contains(peer)) {
                Stream<Peer> result = aop.stream().filter(p -> !peer.equals(p));
                this.storeOfPeers.put(txn, PEERS, new ArrayOfPeers(result).toByteIterable());
                return true;
            }
            return false;
        }
        catch (ExodusException | IOException e) {
            throw new LocalNodeException(e);
        }
    }

    private Environment createPeersEnvironment(LocalNodeConfig config) {
        Path path = config.getDir().resolve("peers");
        Environment env = new Environment(path.toString());
        LOGGER.info("db: opened the peers database at " + String.valueOf(path));
        return env;
    }

    private Store openStore(String name) {
        try {
            Store store = (Store)this.environment.computeInTransaction(txn -> this.environment.openStoreWithoutDuplicates(name, txn));
            LOGGER.info("db: opened the store of " + name);
            return store;
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private static class MarshallableUUID
    extends AbstractMarshallable {
        private final UUID uuid;

        private MarshallableUUID(UUID uuid) {
            this.uuid = uuid;
        }

        public void into(MarshallingContext context) throws IOException {
            context.writeLong(this.uuid.getMostSignificantBits());
            context.writeLong(this.uuid.getLeastSignificantBits());
        }

        private static MarshallableUUID from(ByteIterable bi) throws IOException {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bi.getBytes());){
                MarshallableUUID marshallableUUID;
                block11: {
                    UnmarshallingContext context = UnmarshallingContexts.of((InputStream)bais);
                    try {
                        marshallableUUID = new MarshallableUUID(new UUID(context.readLong(), context.readLong()));
                        if (context == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (context != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    context.close();
                }
                return marshallableUUID;
            }
        }
    }

    private static class ArrayOfPeers
    extends AbstractMarshallable {
        private final Peer[] peers;

        private ArrayOfPeers(Stream<Peer> peers) {
            this.peers = (Peer[])peers.distinct().sorted().toArray(Peer[]::new);
        }

        private boolean contains(Peer peer) {
            for (Peer p : this.peers) {
                if (!p.equals((Object)peer)) continue;
                return true;
            }
            return false;
        }

        private Stream<Peer> stream() {
            return Stream.of(this.peers);
        }

        private int length() {
            return this.peers.length;
        }

        private ByteIterable toByteIterable() {
            return ByteIterable.fromBytes((byte[])this.toByteArray());
        }

        public void into(MarshallingContext context) throws IOException {
            context.writeCompactInt(this.peers.length);
            for (Peer peer : this.peers) {
                peer.into(context);
            }
        }

        private static ArrayOfPeers from(ByteIterable bi) throws IOException {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bi.getBytes());){
                ArrayOfPeers arrayOfPeers;
                block12: {
                    UnmarshallingContext context = UnmarshallingContexts.of((InputStream)bais);
                    try {
                        Peer[] peers = new Peer[context.readCompactInt()];
                        for (int pos = 0; pos < peers.length; ++pos) {
                            peers[pos] = Peers.from((UnmarshallingContext)context);
                        }
                        arrayOfPeers = new ArrayOfPeers(Stream.of(peers));
                        if (context == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (context != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    context.close();
                }
                return arrayOfPeers;
            }
        }
    }
}

