/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import io.mokamint.application.api.ClosedApplicationException;
import io.mokamint.application.api.UnknownStateException;
import io.mokamint.node.api.ApplicationTimeoutException;
import io.mokamint.node.api.ClosedNodeException;
import io.mokamint.node.local.internal.BlockMiner;
import io.mokamint.node.local.internal.ClosedDatabaseException;
import io.mokamint.node.local.internal.LocalNodeImpl;
import io.mokamint.node.local.internal.Mempool;
import io.mokamint.node.local.internal.MisbehavingApplicationException;
import io.mokamint.node.local.internal.TaskRejectedExecutionException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MiningTask
implements LocalNodeImpl.Task {
    private final LocalNodeImpl node;
    private final Object waitingLock = new Object();
    private volatile BlockMiner blockMiner;
    private static final Logger LOGGER = Logger.getLogger(MiningTask.class.getName());

    public MiningTask(LocalNodeImpl node) {
        this.node = node;
    }

    @Override
    public void body() throws InterruptedException {
        try {
            while (true) {
                this.mineOverHead();
            }
        }
        catch (TaskRejectedExecutionException e) {
            LOGGER.warning("mining: exiting since the mining task has been rejected: maibe the node is shutting down");
        }
        catch (InvalidKeyException e) {
            LOGGER.warning("mining: exiting since the key of the node is invalid: " + e.getMessage());
        }
        catch (ClosedDatabaseException e) {
            LOGGER.warning("mining: exiting since the database has been closed: " + e.getMessage());
        }
        catch (SignatureException e) {
            LOGGER.warning("mining: exiting since the signature of the mined block failed: " + e.getMessage());
        }
        catch (ClosedNodeException e) {
            LOGGER.warning("mining: exiting since the node has been closed: " + e.getMessage());
        }
    }

    public void restartFromCurrentHead() {
        BlockMiner blockMiner;
        if (!this.node.isSynchronizing() && (blockMiner = this.blockMiner) != null) {
            blockMiner.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueIfSuspended() {
        Object object = this.waitingLock;
        synchronized (object) {
            this.waitingLock.notify();
        }
    }

    public void add(Mempool.TransactionEntry entry) throws ClosedDatabaseException {
        BlockMiner blockMiner = this.blockMiner;
        if (blockMiner != null) {
            blockMiner.add(entry);
        }
    }

    private void mineOverHead() throws ClosedDatabaseException, InterruptedException, TaskRejectedExecutionException, InvalidKeyException, SignatureException, ClosedNodeException {
        if (this.node.getBlockchain().isEmpty()) {
            LOGGER.warning("mining: cannot mine on an empty blockchain, will retry later");
            this.suspendUntilSomethingChanges();
        } else if (this.node.getMiners().isEmpty()) {
            LOGGER.warning("mining: cannot mine with no miners attached, will retry later");
            this.node.onNoMinersAvailable();
            this.suspendUntilSomethingChanges();
        } else if (this.node.isSynchronizing()) {
            LOGGER.warning("mining: cannot mine since synchronization is in progress, will retry later");
            this.suspendUntilSomethingChanges();
        } else {
            try {
                this.blockMiner = new BlockMiner(this.node);
                this.blockMiner.mine();
            }
            catch (ClosedApplicationException | ApplicationTimeoutException | MisbehavingApplicationException e) {
                LOGGER.warning("mining: there is an application problem: I will wait five seconds and then try again: " + e.getMessage());
                Thread.sleep(5000L);
            }
            catch (UnknownStateException e) {
                LOGGER.log(Level.SEVERE, "the state information at the head of the blockchain is not available", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendUntilSomethingChanges() throws InterruptedException {
        Object object = this.waitingLock;
        synchronized (object) {
            this.waitingLock.wait(10000L);
        }
    }
}

