/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import io.mokamint.miner.api.Miner;
import io.mokamint.node.MinerInfos;
import io.mokamint.node.api.MinerInfo;
import io.mokamint.node.local.internal.LocalNodeImpl;
import io.mokamint.node.local.internal.PunishableSet;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public class MinersSet {
    private final LocalNodeImpl node;
    private final PunishableSet<Miner> miners;

    public MinersSet(LocalNodeImpl node) {
        this.node = node;
        this.miners = new PunishableSet(Stream.empty(), node.getConfigInternal().getMinerInitialPoints());
    }

    public Stream<Miner> get() {
        return this.miners.getElements();
    }

    public boolean isEmpty() {
        return this.miners.isEmpty();
    }

    public Stream<MinerInfo> getInfos() {
        return this.miners.getActorsWithPoints().map(entry -> MinerInfos.of((UUID)((Miner)entry.getKey()).getUUID(), (long)((Long)entry.getValue()), (String)((Miner)entry.getKey()).toString()));
    }

    public Optional<MinerInfo> add(Miner miner) {
        if (this.miners.add(miner)) {
            try {
                Optional<MinerInfo> optional = Optional.of(MinerInfos.of((UUID)miner.getUUID(), (long)this.node.getConfigInternal().getMinerInitialPoints(), (String)miner.toString()));
                return optional;
            }
            finally {
                this.node.onAdded(miner);
            }
        }
        return Optional.empty();
    }

    public boolean remove(Miner miner) {
        if (this.miners.remove(miner)) {
            this.node.onRemoved(miner);
            return true;
        }
        return false;
    }

    public boolean punish(Miner miner, long points) {
        if (this.miners.punish(miner, points)) {
            this.node.onRemoved(miner);
            return true;
        }
        return false;
    }

    public void pardon(Miner miner, long points) {
        this.miners.pardon(miner, points);
    }
}

