/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.api.Hasher;
import io.hotmoka.marshalling.api.Marshallable;
import io.mokamint.application.api.Application;
import io.mokamint.application.api.ClosedApplicationException;
import io.mokamint.node.MempoolEntries;
import io.mokamint.node.MempoolInfos;
import io.mokamint.node.MempoolPortions;
import io.mokamint.node.api.ApplicationTimeoutException;
import io.mokamint.node.api.Block;
import io.mokamint.node.api.ClosedNodeException;
import io.mokamint.node.api.MempoolEntry;
import io.mokamint.node.api.MempoolInfo;
import io.mokamint.node.api.MempoolPortion;
import io.mokamint.node.api.PortionRejectedException;
import io.mokamint.node.api.Transaction;
import io.mokamint.node.api.TransactionRejectedException;
import io.mokamint.node.local.api.LocalNodeConfig;
import io.mokamint.node.local.internal.Blockchain;
import io.mokamint.node.local.internal.ClosedDatabaseException;
import io.mokamint.node.local.internal.LocalNodeImpl;
import io.mokamint.node.local.internal.MisbehavingApplicationException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class Mempool {
    private final LocalNodeImpl node;
    private final LocalNodeConfig config;
    private final Blockchain blockchain;
    private final Application app;
    private final Hasher<Transaction> hasher;
    private Optional<Block> base;
    private final SortedSet<TransactionEntry> mempool;
    private static final Logger LOGGER = Logger.getLogger(Mempool.class.getName());

    public Mempool(LocalNodeImpl node) throws ClosedNodeException {
        this.node = node;
        this.config = node.getConfig();
        this.blockchain = node.getBlockchain();
        this.app = node.getApplication();
        this.hasher = node.getConfigInternal().getHashingForTransactions().getHasher(Marshallable::toByteArray);
        this.base = Optional.empty();
        this.mempool = new TreeSet(Comparator.reverseOrder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mempool(Mempool parent) {
        this.node = parent.node;
        this.config = parent.config;
        this.blockchain = parent.blockchain;
        this.app = parent.app;
        this.hasher = parent.hasher;
        SortedSet<TransactionEntry> sortedSet = parent.mempool;
        synchronized (sortedSet) {
            this.base = parent.base;
            this.mempool = new TreeSet<TransactionEntry>(parent.mempool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebaseAt(Block newBase) throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
        SortedSet<TransactionEntry> sortedSet = this.mempool;
        synchronized (sortedSet) {
            this.blockchain.rebase(this, newBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionEntry add(Transaction transaction) throws TransactionRejectedException, InterruptedException, ApplicationTimeoutException, ClosedApplicationException, ClosedDatabaseException {
        int size = transaction.getNumberOfBytes();
        if (size > this.config.getMaxTransactionSize()) {
            throw new TransactionRejectedException("The transaction is " + size + " bytes long, against a maximum of " + this.config.getMaxTransactionSize());
        }
        try {
            this.app.checkTransaction(transaction);
        }
        catch (TimeoutException e) {
            throw new ApplicationTimeoutException(e);
        }
        TransactionEntry entry = this.mkTransactionEntry(transaction);
        int maxSize = this.config.getMempoolSize();
        int maxBlockSize = this.config.getMaxBlockSize();
        SortedSet<TransactionEntry> sortedSet = this.mempool;
        synchronized (sortedSet) {
            if (this.base.isPresent() && this.blockchain.getTransactionAddress(this.base.get(), entry.hash).isPresent()) {
                throw new TransactionRejectedException("Repeated transaction " + String.valueOf(entry));
            }
            if (this.mempool.contains(entry)) {
                throw new TransactionRejectedException("Repeated transaction " + String.valueOf(entry));
            }
            int txSize = transaction.size();
            if (txSize > maxBlockSize) {
                throw new TransactionRejectedException("Cannot add transaction " + String.valueOf(entry) + ": it is too large (" + txSize + " bytes against a maximum block size of " + maxBlockSize + ")");
            }
            if (this.mempool.size() >= maxSize) {
                throw new TransactionRejectedException("Cannot add transaction " + String.valueOf(entry) + ": all " + maxSize + " slots of the mempool are full");
            }
            this.mempool.add(entry);
        }
        LOGGER.info("mempool: added transaction " + String.valueOf(entry));
        this.node.onAdded(transaction);
        return entry;
    }

    public TransactionEntry mkTransactionEntry(Transaction transaction) throws TransactionRejectedException, ClosedApplicationException, ApplicationTimeoutException, InterruptedException {
        long priority;
        try {
            priority = this.app.getPriority(transaction);
        }
        catch (TimeoutException e) {
            throw new ApplicationTimeoutException(e);
        }
        return new TransactionEntry(transaction, priority, this.hasher.hash((Object)transaction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TransactionEntry entry) {
        SortedSet<TransactionEntry> sortedSet = this.mempool;
        synchronized (sortedSet) {
            this.mempool.remove(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachTransaction(Consumer<TransactionEntry> action) {
        SortedSet<TransactionEntry> sortedSet = this.mempool;
        synchronized (sortedSet) {
            this.mempool.stream().forEachOrdered(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MempoolInfo getInfo() {
        long size;
        SortedSet<TransactionEntry> sortedSet = this.mempool;
        synchronized (sortedSet) {
            size = this.mempool.size();
        }
        return MempoolInfos.of((long)size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MempoolPortion getPortion(int start, int count) throws PortionRejectedException {
        if (start < 0 || count <= 0) {
            return MempoolPortions.of(Stream.empty());
        }
        int max = this.config.getMaxMempoolPortionLength();
        if (count > max) {
            throw new PortionRejectedException("count cannot be larger than " + max);
        }
        SortedSet<TransactionEntry> sortedSet = this.mempool;
        synchronized (sortedSet) {
            return MempoolPortions.of(this.mempool.stream().skip(start).limit(count).map(TransactionEntry::toMempoolEntry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<Block> getBase() {
        SortedSet<TransactionEntry> sortedSet = this.mempool;
        synchronized (sortedSet) {
            return this.base;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Block newBase, Stream<TransactionEntry> toAdd, Stream<TransactionEntry> toRemove) {
        SortedSet<TransactionEntry> sortedSet = this.mempool;
        synchronized (sortedSet) {
            toAdd.forEach(this.mempool::add);
            toRemove.forEach(this.mempool::remove);
            this.base = Optional.of(newBase);
        }
    }

    public static final class TransactionEntry
    implements Comparable<TransactionEntry> {
        private final Transaction transaction;
        private final long priority;
        private final byte[] hash;

        private TransactionEntry(Transaction transaction, long priority, byte[] hash) {
            this.transaction = transaction;
            this.priority = priority;
            this.hash = hash;
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public byte[] getHash() {
            return (byte[])this.hash.clone();
        }

        @Override
        public int compareTo(TransactionEntry other) {
            int diff = Long.compare(this.priority, other.priority);
            return diff != 0 ? diff : Arrays.compare(this.hash, other.hash);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (!(other instanceof TransactionEntry)) return false;
            TransactionEntry te = (TransactionEntry)other;
            if (!Arrays.equals(this.hash, te.hash)) return false;
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode(this.hash);
        }

        public String toString() {
            return Hex.toHexString((byte[])this.hash);
        }

        public MempoolEntry toMempoolEntry() {
            return MempoolEntries.of((byte[])this.hash, (long)this.priority);
        }
    }
}

