/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import io.hotmoka.closeables.AbstractAutoCloseableWithLockAndOnCloseHandlers;
import io.hotmoka.closeables.api.ClosureLock;
import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.hotmoka.websockets.api.FailedDeploymentException;
import io.mokamint.application.api.Application;
import io.mokamint.application.api.ClosedApplicationException;
import io.mokamint.miner.MiningSpecifications;
import io.mokamint.miner.api.Miner;
import io.mokamint.miner.api.MiningSpecification;
import io.mokamint.miner.remote.RemoteMiners;
import io.mokamint.miner.remote.api.DeadlineValidityCheckException;
import io.mokamint.miner.remote.api.IllegalDeadlineException;
import io.mokamint.miner.remote.api.RemoteMiner;
import io.mokamint.node.ChainPortions;
import io.mokamint.node.Memories;
import io.mokamint.node.Peers;
import io.mokamint.node.TaskInfos;
import io.mokamint.node.api.ApplicationTimeoutException;
import io.mokamint.node.api.Block;
import io.mokamint.node.api.BlockDescription;
import io.mokamint.node.api.ChainInfo;
import io.mokamint.node.api.ChainPortion;
import io.mokamint.node.api.ClosedNodeException;
import io.mokamint.node.api.ClosedPeerException;
import io.mokamint.node.api.Memory;
import io.mokamint.node.api.MempoolEntry;
import io.mokamint.node.api.MempoolInfo;
import io.mokamint.node.api.MempoolPortion;
import io.mokamint.node.api.MinerInfo;
import io.mokamint.node.api.NodeInfo;
import io.mokamint.node.api.NonGenesisBlock;
import io.mokamint.node.api.Peer;
import io.mokamint.node.api.PeerInfo;
import io.mokamint.node.api.PeerRejectedException;
import io.mokamint.node.api.PortionRejectedException;
import io.mokamint.node.api.TaskInfo;
import io.mokamint.node.api.Transaction;
import io.mokamint.node.api.TransactionAddress;
import io.mokamint.node.api.TransactionRejectedException;
import io.mokamint.node.api.WhisperMessage;
import io.mokamint.node.api.Whisperable;
import io.mokamint.node.api.Whisperer;
import io.mokamint.node.local.AlreadyInitializedException;
import io.mokamint.node.local.LocalNodeException;
import io.mokamint.node.local.api.LocalNode;
import io.mokamint.node.local.api.LocalNodeConfig;
import io.mokamint.node.local.internal.Blockchain;
import io.mokamint.node.local.internal.ClosedDatabaseException;
import io.mokamint.node.local.internal.Mempool;
import io.mokamint.node.local.internal.MinersSet;
import io.mokamint.node.local.internal.MiningTask;
import io.mokamint.node.local.internal.MisbehavingApplicationException;
import io.mokamint.node.local.internal.PeerTimeoutException;
import io.mokamint.node.local.internal.PeersSet;
import io.mokamint.node.local.internal.TaskRejectedExecutionException;
import io.mokamint.node.local.internal.VerificationException;
import io.mokamint.node.messages.WhisperBlockMessages;
import io.mokamint.node.messages.WhisperPeerMessages;
import io.mokamint.node.messages.WhisperTransactionMessages;
import io.mokamint.node.messages.api.WhisperBlockMessage;
import io.mokamint.node.messages.api.WhisperPeerMessage;
import io.mokamint.node.messages.api.WhisperTransactionMessage;
import io.mokamint.node.service.api.PublicNodeService;
import io.mokamint.nonce.api.Deadline;
import io.mokamint.nonce.api.Prolog;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SignatureException;
import java.time.LocalDateTime;
import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class LocalNodeImpl
extends AbstractAutoCloseableWithLockAndOnCloseHandlers<ClosedNodeException>
implements LocalNode {
    private final LocalNodeConfig config;
    private final KeyPair keyPair;
    private final Application app;
    private final MinersSet miners;
    private final PeersSet peers;
    private final Blockchain blockchain;
    private final Mempool mempool;
    private final UUID uuid;
    private final ExecutorService executors = Executors.newCachedThreadPool();
    private final ScheduledExecutorService periodicExecutors = Executors.newScheduledThreadPool(5);
    private final Set<RunnableTask> currentlyExecutingTasks = ConcurrentHashMap.newKeySet();
    private final Set<Miner> minersToCloseAtTheEnd = ConcurrentHashMap.newKeySet();
    private final CopyOnWriteArrayList<Whisperer> boundWhisperers = new CopyOnWriteArrayList();
    private final Memory<Whisperable> alreadyWhispered;
    private final Memory<WhisperPeerMessage> peersAlreadyWhispered;
    private final AtomicBoolean isSynchronizing = new AtomicBoolean(false);
    private final MiningTask miningTask;
    private final Predicate<Whisperer> isThis = Predicate.isEqual((Object)this);
    private final BlockingQueue<WhisperedInfo<WhisperPeerMessage>> whisperedPeersQueue = new ArrayBlockingQueue<WhisperedInfo<WhisperPeerMessage>>(1000);
    private final BlockingQueue<WhisperedInfo<WhisperBlockMessage>> whisperedBlocksQueue = new ArrayBlockingQueue<WhisperedInfo<WhisperBlockMessage>>(1000);
    private final BlockingQueue<WhisperedInfo<WhisperTransactionMessage>> whisperedTransactionsQueue = new ArrayBlockingQueue<WhisperedInfo<WhisperTransactionMessage>>(1000);
    private final BlockingQueue<Block> blocksToPublishQueue = new ArrayBlockingQueue<Block>(1000);
    private final MiningSpecification miningSpecification;
    private static final Logger LOGGER = Logger.getLogger(LocalNodeImpl.class.getName());

    public LocalNodeImpl(LocalNodeConfig config, KeyPair keyPair, Application app, boolean init) throws InterruptedException {
        super(ClosedNodeException::new);
        this.config = config;
        this.keyPair = keyPair;
        this.miningSpecification = MiningSpecifications.of((String)config.getChainId(), (HashingAlgorithm)config.getHashingForDeadlines(), (SignatureAlgorithm)config.getSignatureForBlocks(), (SignatureAlgorithm)config.getSignatureForDeadlines(), (PublicKey)this.getKeys().getPublic());
        this.app = app;
        this.peersAlreadyWhispered = Memories.of((int)config.getWhisperingMemorySize());
        this.alreadyWhispered = Memories.of((int)config.getWhisperingMemorySize());
        this.miningTask = new MiningTask(this);
        this.miners = new MinersSet(this);
        try {
            this.blockchain = new Blockchain(this);
            this.mempool = new Mempool(this);
            this.peers = new PeersSet(this);
            this.uuid = this.getInfo().getUUID();
        }
        catch (ClosedNodeException e) {
            throw new LocalNodeException("The node has been unexpectedly closed", e);
        }
        app.addOnCloseHandler(this::close);
        if (init) {
            this.initialize();
        }
        this.scheduleTasks();
    }

    private void initialize() throws InterruptedException {
        try {
            this.blockchain.initialize();
        }
        catch (AlreadyInitializedException e) {
            this.close();
            throw new LocalNodeException("The blockchain database is already initialized: delete \"" + String.valueOf(this.config.getDir()) + "\" and try again", e);
        }
        catch (ApplicationTimeoutException e) {
            this.close();
            throw new LocalNodeException("The application timed out", e);
        }
        catch (InvalidKeyException | SignatureException e) {
            this.close();
            throw new LocalNodeException("The genesis block could not be signed", e);
        }
        catch (ClosedDatabaseException e) {
            this.close();
            throw new LocalNodeException("The database has been unexpectedly closed", e);
        }
        catch (ClosedApplicationException e) {
            this.close();
            throw new LocalNodeException("The application is already closed", e);
        }
        catch (MisbehavingApplicationException e) {
            this.close();
            throw new LocalNodeException("The application is misbehaving", e);
        }
    }

    private void scheduleTasks() {
        try {
            this.schedulePeriodicSynchronization();
            this.schedule(this::processWhisperedPeers, "peers whispering process");
            this.schedule(this::processWhisperedBlocks, "blocks whispering process");
            this.schedule(this::processWhisperedTransactions, "transactions whispering process");
            this.schedule(this::publisher, "block publishing process");
            this.schedulePeriodicPingToAllPeersAndReconnection();
            this.schedulePeriodicWhisperingOfAllServices();
            this.schedulePeriodicIdentificationOfTheNonFrozenPartOfBlockchain();
            this.schedule(this.miningTask, "blocks mining process");
        }
        catch (TaskRejectedExecutionException e) {
            this.close();
            throw new LocalNodeException("Could not spawn the node's tasks", e);
        }
    }

    public void close() {
        try {
            if (this.stopNewCalls()) {
                this.closeExecutorsHandlersMinersPeersAndBlockchain();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void bindWhisperer(Whisperer whisperer) {
        this.boundWhisperers.add(whisperer);
        this.whisperAllServices();
    }

    public void unbindWhisperer(Whisperer whisperer) {
        this.boundWhisperers.remove(whisperer);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void whisper(WhisperMessage<?> message, Predicate<Whisperer> seen, String description) {
        WhisperPeerMessage wpm;
        if (seen.test((Whisperer)this)) return;
        if (message instanceof WhisperPeerMessage && this.peersAlreadyWhispered.add((Object)(wpm = (WhisperPeerMessage)message))) {
            this.whisperedPeersQueue.offer(new WhisperedInfo<WhisperPeerMessage>(wpm, seen, description, true));
            return;
        }
        if (message instanceof WhisperBlockMessage) {
            WhisperBlockMessage wbm = (WhisperBlockMessage)message;
            if (this.alreadyWhispered.add((Object)message.getWhispered())) {
                this.whisperedBlocksQueue.offer(new WhisperedInfo<WhisperBlockMessage>(wbm, seen, description, true));
                return;
            }
        }
        if (!(message instanceof WhisperTransactionMessage)) return;
        WhisperTransactionMessage wtm = (WhisperTransactionMessage)message;
        if (!this.alreadyWhispered.add((Object)message.getWhispered())) return;
        this.whisperedTransactionsQueue.offer(new WhisperedInfo<WhisperTransactionMessage>(wtm, seen, description, true));
    }

    public Optional<Block> getBlock(byte[] hash) throws ClosedNodeException {
        Optional<Block> optional;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                optional = this.blockchain.getBlock(hash);
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClosedDatabaseException e) {
                    throw new ClosedNodeException((Throwable)e);
                }
            }
            scope.close();
        }
        return optional;
    }

    public Optional<BlockDescription> getBlockDescription(byte[] hash) throws ClosedNodeException {
        Optional<BlockDescription> optional;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                optional = this.blockchain.getBlockDescription(hash);
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClosedDatabaseException e) {
                    throw new ClosedNodeException((Throwable)e);
                }
            }
            scope.close();
        }
        return optional;
    }

    public Stream<PeerInfo> getPeerInfos() throws ClosedNodeException {
        try (ClosureLock.Scope scope = this.mkScope();){
            Stream<PeerInfo> stream = this.peers.get();
            return stream;
        }
    }

    public Stream<MinerInfo> getMinerInfos() throws ClosedNodeException {
        try (ClosureLock.Scope scope = this.mkScope();){
            Stream<MinerInfo> stream = this.miners.getInfos();
            return stream;
        }
    }

    public Stream<TaskInfo> getTaskInfos() throws TimeoutException, InterruptedException, ClosedNodeException {
        try (ClosureLock.Scope scope = this.mkScope();){
            Stream<TaskInfo> stream = this.currentlyExecutingTasks.stream().map(Object::toString).map(TaskInfos::of);
            return stream;
        }
    }

    public NodeInfo getInfo() throws ClosedNodeException {
        try (ClosureLock.Scope scope = this.mkScope();){
            NodeInfo nodeInfo = this.peers.getNodeInfo();
            return nodeInfo;
        }
    }

    public LocalNodeConfig getConfig() throws ClosedNodeException {
        try (ClosureLock.Scope scope = this.mkScope();){
            LocalNodeConfig localNodeConfig = this.config;
            return localNodeConfig;
        }
    }

    public ChainInfo getChainInfo() throws ClosedNodeException {
        ClosureLock.Scope scope = this.mkScope();
        try {
            ChainInfo chainInfo = this.blockchain.getChainInfo();
            return chainInfo;
        }
        catch (ClosedDatabaseException e) {
            throw new ClosedNodeException((Throwable)e);
        }
        finally {
            if (scope != null) {
                try {
                    scope.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public ChainPortion getChainPortion(long start, int count) throws ClosedNodeException, PortionRejectedException {
        ClosureLock.Scope scope = this.mkScope();
        try {
            ChainPortion chainPortion = ChainPortions.of(this.blockchain.getChain(start, count));
            return chainPortion;
        }
        catch (ClosedDatabaseException e) {
            throw new ClosedNodeException((Throwable)e);
        }
        finally {
            if (scope != null) {
                try {
                    scope.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public MempoolEntry add(Transaction transaction) throws TransactionRejectedException, ClosedNodeException, ApplicationTimeoutException, InterruptedException {
        Mempool.TransactionEntry result;
        try {
            try (ClosureLock.Scope scope = this.mkScope();){
                result = this.mempool.add(transaction);
            }
            this.miningTask.add(result);
        }
        catch (ClosedApplicationException | ClosedDatabaseException e) {
            throw new ClosedNodeException(e);
        }
        this.whisperWithoutAddition(transaction);
        return result.toMempoolEntry();
    }

    public MempoolInfo getMempoolInfo() throws ClosedNodeException {
        try (ClosureLock.Scope scope = this.mkScope();){
            MempoolInfo mempoolInfo = this.mempool.getInfo();
            return mempoolInfo;
        }
    }

    public MempoolPortion getMempoolPortion(int start, int count) throws ClosedNodeException, PortionRejectedException {
        try (ClosureLock.Scope scope = this.mkScope();){
            MempoolPortion mempoolPortion = this.mempool.getPortion(start, count);
            return mempoolPortion;
        }
    }

    public Optional<Transaction> getTransaction(byte[] hash) throws ClosedNodeException {
        ClosureLock.Scope scope = this.mkScope();
        try {
            Optional<Transaction> optional = this.blockchain.getTransaction(hash);
            return optional;
        }
        catch (ClosedDatabaseException e) {
            throw new ClosedNodeException((Throwable)e);
        }
        finally {
            if (scope != null) {
                try {
                    scope.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> getTransactionRepresentation(byte[] hash) throws TransactionRejectedException, ClosedNodeException, TimeoutException, InterruptedException {
        try (ClosureLock.Scope scope = this.mkScope();){
            Optional<Transaction> maybeTransaction = this.blockchain.getTransaction(hash);
            if (maybeTransaction.isEmpty()) {
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            Optional<String> optional = Optional.of(this.app.getRepresentation(maybeTransaction.get()));
            return optional;
        }
        catch (ClosedApplicationException | ClosedDatabaseException e) {
            throw new ClosedNodeException(e);
        }
    }

    public Optional<TransactionAddress> getTransactionAddress(byte[] hash) throws ClosedNodeException {
        ClosureLock.Scope scope = this.mkScope();
        try {
            Optional<TransactionAddress> optional = this.blockchain.getTransactionAddress(hash);
            return optional;
        }
        catch (ClosedDatabaseException e) {
            throw new ClosedNodeException((Throwable)e);
        }
        finally {
            if (scope != null) {
                try {
                    scope.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public Optional<PeerInfo> add(Peer peer) throws TimeoutException, InterruptedException, ClosedNodeException, ClosedPeerException, PeerRejectedException {
        Optional<PeerInfo> result;
        try (ClosureLock.Scope scope = this.mkScope();){
            result = this.peers.add(peer);
        }
        catch (ClosedDatabaseException e) {
            throw new ClosedNodeException((Throwable)e);
        }
        if (result.isPresent()) {
            this.scheduleSynchronizationIfPossible();
            this.whisperAllServices();
            this.whisperWithoutAddition(peer);
        }
        return result;
    }

    public boolean remove(Peer peer) throws ClosedNodeException {
        ClosureLock.Scope scope = this.mkScope();
        try {
            boolean bl = this.peers.remove(peer);
            return bl;
        }
        catch (ClosedDatabaseException e) {
            throw new ClosedNodeException((Throwable)e);
        }
        finally {
            if (scope != null) {
                try {
                    scope.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public Optional<MinerInfo> openMiner(int port) throws FailedDeploymentException, ClosedNodeException {
        try (ClosureLock.Scope scope = this.mkScope();){
            RemoteMiner miner = RemoteMiners.open((int)port, (MiningSpecification)this.miningSpecification, this::checkForMiners);
            Optional<MinerInfo> maybeInfo = this.miners.add((Miner)miner);
            if (maybeInfo.isPresent()) {
                this.minersToCloseAtTheEnd.add((Miner)miner);
            } else {
                miner.close();
            }
            Optional<MinerInfo> optional = maybeInfo;
            return optional;
        }
    }

    public Optional<MinerInfo> add(Miner miner) throws ClosedNodeException {
        try (ClosureLock.Scope scope = this.mkScope();){
            Optional<MinerInfo> optional = this.miners.add(miner);
            return optional;
        }
    }

    public boolean removeMiner(UUID uuid) throws ClosedNodeException {
        try (ClosureLock.Scope scope = this.mkScope();){
            Miner[] toRemove;
            for (Miner miner2 : toRemove = (Miner[])this.miners.get().filter(miner -> miner.getUUID().equals(uuid)).toArray(Miner[]::new)) {
                this.miners.remove(miner2);
                if (!this.minersToCloseAtTheEnd.contains(miner2)) continue;
                miner2.close();
            }
            boolean bl = toRemove.length > 0;
            return bl;
        }
    }

    protected Application getApplication() {
        return this.app;
    }

    protected PeersSet getPeers() {
        return this.peers;
    }

    protected MinersSet getMiners() {
        return this.miners;
    }

    protected Blockchain getBlockchain() {
        return this.blockchain;
    }

    protected KeyPair getKeys() {
        return this.keyPair;
    }

    protected LocalNodeConfig getConfigInternal() {
        return this.config;
    }

    protected void remove(Mempool.TransactionEntry transactionEntry) {
        this.mempool.remove(transactionEntry);
    }

    protected void punish(Miner miner, long points, String reason) {
        if (points > 0L) {
            LOGGER.warning("punishing miner " + String.valueOf(miner.getUUID()) + " by removing " + points + " points since " + reason);
            if (this.miners.punish(miner, points) && this.minersToCloseAtTheEnd.contains(miner)) {
                miner.close();
            }
        }
    }

    protected void check(Deadline deadline) throws IllegalDeadlineException, ApplicationTimeoutException, InterruptedException, ClosedApplicationException {
        Prolog prolog = deadline.getProlog();
        if (!deadline.isValid()) {
            throw new IllegalDeadlineException("Invalid deadline");
        }
        try {
            if (!deadline.signatureIsValid()) {
                throw new IllegalDeadlineException("Invalid deadline's signature");
            }
        }
        catch (InvalidKeyException e) {
            throw new IllegalDeadlineException("The key in the prolog of the deadline is invalid");
        }
        catch (SignatureException e) {
            throw new IllegalDeadlineException("The signature of the deadline could not be verified");
        }
        if (!prolog.getChainId().equals(this.config.getChainId())) {
            throw new IllegalDeadlineException("Wrong chain identifier in deadline");
        }
        if (!prolog.getPublicKeyForSigningBlocks().equals(this.keyPair.getPublic())) {
            throw new IllegalDeadlineException("Wrong node key in deadline");
        }
        if (!prolog.getSignatureForBlocks().equals((Object)this.config.getSignatureForBlocks())) {
            throw new IllegalDeadlineException("Wrong blocks' signature algorithm in deadline");
        }
        if (!prolog.getSignatureForDeadlines().equals((Object)this.config.getSignatureForDeadlines())) {
            throw new IllegalDeadlineException("Wrong deadlines' signature algorithm in deadline");
        }
        try {
            if (!this.app.checkPrologExtra(prolog.getExtra())) {
                throw new IllegalDeadlineException("Invalid extra data in deadline");
            }
        }
        catch (TimeoutException e) {
            throw new ApplicationTimeoutException(e);
        }
    }

    private void checkForMiners(Deadline deadline) throws IllegalDeadlineException, DeadlineValidityCheckException, InterruptedException {
        try {
            this.check(deadline);
        }
        catch (ClosedApplicationException | ApplicationTimeoutException e) {
            throw new DeadlineValidityCheckException(e);
        }
    }

    protected void rebaseMempoolAt(Block block) throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
        this.mempool.rebaseAt(block);
    }

    protected void forEachMempoolTransactionAt(Block block, Consumer<Mempool.TransactionEntry> action) throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
        Mempool result = new Mempool(this.mempool);
        result.rebaseAt(block);
        result.forEachTransaction(action);
    }

    private void scheduleSynchronizationIfPossible() {
        try {
            this.schedule(this::synchronize, "synchronization from the peers");
        }
        catch (TaskRejectedExecutionException e) {
            LOGGER.warning("node " + String.valueOf(this.uuid) + ": synchronization request rejected, probably because the node is shutting down");
        }
    }

    protected boolean isSynchronizing() {
        return this.isSynchronizing.get();
    }

    private void whisperWithoutAddition(Peer peer) {
        WhisperPeerMessage whisperPeerMessage = WhisperPeerMessages.of((Peer)peer, (String)UUID.randomUUID().toString());
        if (this.peersAlreadyWhispered.add((Object)whisperPeerMessage)) {
            this.whisperedPeersQueue.offer(new WhisperedInfo<WhisperPeerMessage>(whisperPeerMessage, this.isThis, "peer " + String.valueOf(peer), false));
        }
    }

    protected void whisperWithoutAddition(Block block) {
        if (this.alreadyWhispered.add((Object)block)) {
            WhisperBlockMessage whisperBlockMessage = WhisperBlockMessages.of((Block)block, (String)UUID.randomUUID().toString());
            this.whisperedBlocksQueue.offer(new WhisperedInfo<WhisperBlockMessage>(whisperBlockMessage, this.isThis, "block " + block.getHexHash(), false));
        }
    }

    private void whisperWithoutAddition(Transaction transaction) {
        if (this.alreadyWhispered.add((Object)transaction)) {
            WhisperTransactionMessage whisperTransactionMessage = WhisperTransactionMessages.of((Transaction)transaction, (String)UUID.randomUUID().toString());
            this.whisperedTransactionsQueue.offer(new WhisperedInfo<WhisperTransactionMessage>(whisperTransactionMessage, this.isThis, "transaction " + transaction.getHexHash(this.config.getHashingForTransactions()), false));
        }
    }

    protected void onAdded(Peer peer) {
        LOGGER.info("added peer " + String.valueOf(peer));
    }

    protected void onConnected(Peer peer) {
        LOGGER.info("connected to peer " + String.valueOf(peer));
    }

    protected void onDisconnected(Peer peer) {
        LOGGER.info("disconnected from peer " + String.valueOf(peer));
    }

    protected void onRemoved(Peer peer) {
        LOGGER.info("removed peer " + String.valueOf(peer));
    }

    protected void onAdded(Miner miner) {
        LOGGER.info("added miner " + String.valueOf(miner.getUUID()) + " (" + String.valueOf(miner) + ")");
        this.miningTask.continueIfSuspended();
    }

    protected void onRemoved(Miner miner) {
        LOGGER.info("removed miner " + String.valueOf(miner.getUUID()) + " (" + String.valueOf(miner) + ")");
    }

    protected void onAdded(Transaction transaction) {
    }

    protected void onNoDeadlineFound(Block previous) {
    }

    protected void onIllegalDeadlineComputed(Deadline deadline, Miner miner) {
    }

    protected void onNoMinersAvailable() {
    }

    protected void onMiningStarted(Block previous) {
    }

    protected void onMiningCompleted(Block previous) {
    }

    protected void onSynchronizationCompleted() {
        this.isSynchronizing.set(false);
        this.miningTask.continueIfSuspended();
    }

    protected void onAdded(Block block) {
        this.miningTask.continueIfSuspended();
    }

    protected void onHeadChanged(Deque<Block> pathToNewHead) {
        pathToNewHead.forEach(block -> {
            if (!this.blocksToPublishQueue.offer((Block)block)) {
                LOGGER.warning("cannot shcedule the publication of block " + block.getHexHash() + " since the publishing queue is full");
            }
        });
        this.miningTask.restartFromCurrentHead();
    }

    protected void onMined(NonGenesisBlock block) {
    }

    protected void onWhispered(Peer peer) {
    }

    protected void onWhispered(Block block) {
    }

    protected void onWhispered(Transaction transaction) {
    }

    private void schedule(Task task, String description) throws TaskRejectedExecutionException {
        RunnableTask runnable = new RunnableTask(task, description);
        try {
            this.executors.execute(runnable);
            LOGGER.info("node " + String.valueOf(this.uuid) + ": " + String.valueOf(runnable) + " scheduled");
        }
        catch (RejectedExecutionException e) {
            throw new TaskRejectedExecutionException(e);
        }
    }

    Future<?> submit(Task task, String description) throws TaskRejectedExecutionException {
        RunnableTask runnable = new RunnableTask(task, description);
        try {
            Future<?> future = this.executors.submit(runnable);
            LOGGER.info("node " + String.valueOf(this.uuid) + ": " + String.valueOf(runnable) + " scheduled");
            return future;
        }
        catch (RejectedExecutionException e) {
            LOGGER.warning("node " + String.valueOf(this.uuid) + ": " + String.valueOf(runnable) + " rejected, probably because the node is shutting down");
            throw new TaskRejectedExecutionException(e);
        }
    }

    private void scheduleWithFixedDelay(Task task, String description, long initialDelay, long delay, TimeUnit unit) throws TaskRejectedExecutionException {
        RunnableTask runnable = new RunnableTask(task, description);
        try {
            this.periodicExecutors.scheduleWithFixedDelay(runnable, initialDelay, delay, unit);
            LOGGER.info("node " + String.valueOf(this.uuid) + ": " + String.valueOf(runnable) + " scheduled every " + delay + " " + String.valueOf((Object)unit));
        }
        catch (RejectedExecutionException e) {
            throw new TaskRejectedExecutionException(e);
        }
    }

    private void schedulePeriodicWhisperingOfAllServices() throws TaskRejectedExecutionException {
        long serviceBroadcastInterval = this.config.getServiceBrodcastInterval();
        if (serviceBroadcastInterval >= 0L) {
            this.scheduleWithFixedDelay(this::whisperAllServices, "whispering of all node's services", 0L, serviceBroadcastInterval, TimeUnit.MILLISECONDS);
        }
    }

    private void schedulePeriodicIdentificationOfTheNonFrozenPartOfBlockchain() throws TaskRejectedExecutionException {
        this.scheduleWithFixedDelay(this::identifyNonFrozenPartOfBlockchain, "identification of the non-frozen part of the blockchain", 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    private void schedulePeriodicSynchronization() throws TaskRejectedExecutionException {
        int interval = this.config.getSynchronizationInterval();
        if (interval >= 0) {
            this.scheduleWithFixedDelay(this::synchronize, "synchronization from the peers", 0L, interval, TimeUnit.MILLISECONDS);
        }
    }

    private void synchronize() throws InterruptedException {
        if (!this.isSynchronizing.getAndSet(true)) {
            try {
                this.blockchain.synchronize();
            }
            catch (ClosedNodeException e) {
                LOGGER.warning("sync: stop synchronizing since the node has been closed: " + e.getMessage());
            }
            catch (ClosedDatabaseException e) {
                LOGGER.warning("sync: stop synchronizing since the database has been closed: " + e.getMessage());
            }
        }
    }

    private void schedulePeriodicPingToAllPeersAndReconnection() throws TaskRejectedExecutionException {
        int interval = this.config.getPeerPingInterval();
        if (interval >= 0) {
            this.scheduleWithFixedDelay(this::pingAllPeersAndReconnect, "ping of all peers to check connection and collect their peers", 0L, interval, TimeUnit.MILLISECONDS);
        }
    }

    private void pingAllPeersAndReconnect() throws InterruptedException {
        try {
            if (this.peers.pingAllAndReconnect()) {
                this.scheduleSynchronizationIfPossible();
            }
        }
        catch (ClosedNodeException e) {
            LOGGER.warning("ping all peers exits since the node has been closed");
        }
        catch (ClosedDatabaseException e) {
            LOGGER.warning("ping all peers exits since the database has been closed");
        }
    }

    private void processWhisperedPeers() throws InterruptedException, ClosedNodeException, ClosedDatabaseException {
        while (!Thread.currentThread().isInterrupted()) {
            WhisperedInfo<WhisperPeerMessage> whisperedInfo = this.whisperedPeersQueue.take();
            WhisperPeerMessage whisperedPeerMessage = (WhisperPeerMessage)whisperedInfo.message;
            Peer peer = (Peer)whisperedPeerMessage.getWhispered();
            if (whisperedInfo.add) {
                try {
                    if (this.peers.add(peer).isPresent()) {
                        this.scheduleSynchronizationIfPossible();
                    }
                }
                catch (ClosedPeerException | PeerTimeoutException e) {
                    LOGGER.warning("node " + String.valueOf(this.uuid) + ": whispered " + whisperedInfo.description + " could not be added because it is misbehaving: " + e.getMessage());
                }
                catch (PeerRejectedException e) {
                    LOGGER.warning("node " + String.valueOf(this.uuid) + ": whispered " + whisperedInfo.description + " has been rejected: " + e.getMessage());
                }
            }
            Predicate<Whisperer> newSeen = whisperedInfo.seen.or(this.isThis);
            this.peers.whisper((WhisperMessage<?>)whisperedPeerMessage, newSeen, whisperedInfo.description);
            this.boundWhisperers.forEach(whisperer -> whisperer.whisper((WhisperMessage)whisperedPeerMessage, newSeen, whisperedInfo.description));
            this.onWhispered(peer);
        }
    }

    private void processWhisperedBlocks() throws InterruptedException, ClosedDatabaseException {
        while (!Thread.currentThread().isInterrupted()) {
            WhisperedInfo<WhisperBlockMessage> whisperedInfo = this.whisperedBlocksQueue.take();
            try {
                WhisperBlockMessage whisperedBlockMessage = (WhisperBlockMessage)whisperedInfo.message;
                Block block = (Block)whisperedBlockMessage.getWhispered();
                if (whisperedInfo.add) {
                    try {
                        this.blockchain.add(block);
                    }
                    catch (ClosedApplicationException | ApplicationTimeoutException | MisbehavingApplicationException e) {
                        LOGGER.warning("node " + String.valueOf(this.uuid) + ": whispered " + whisperedInfo.description + " could not be added because of a problem with the application: " + e.getMessage());
                    }
                }
                Predicate<Whisperer> newSeen = whisperedInfo.seen.or(this.isThis);
                this.peers.whisper((WhisperMessage<?>)whisperedBlockMessage, newSeen, whisperedInfo.description);
                this.boundWhisperers.forEach(whisperer -> whisperer.whisper((WhisperMessage)whisperedBlockMessage, newSeen, whisperedInfo.description));
                this.onWhispered(block);
            }
            catch (VerificationException e) {
                LOGGER.warning("node " + String.valueOf(this.uuid) + ": whispered " + whisperedInfo.description + " failed verification: " + e.getMessage());
            }
        }
    }

    private void processWhisperedTransactions() throws InterruptedException, ClosedDatabaseException {
        while (!Thread.currentThread().isInterrupted()) {
            WhisperedInfo<WhisperTransactionMessage> whisperedInfo = this.whisperedTransactionsQueue.take();
            WhisperTransactionMessage whisperedTransactionMessage = (WhisperTransactionMessage)whisperedInfo.message;
            Transaction tx = (Transaction)whisperedTransactionMessage.getWhispered();
            if (whisperedInfo.add) {
                try {
                    this.mempool.add(tx);
                }
                catch (ClosedApplicationException | ApplicationTimeoutException e) {
                    LOGGER.warning("node " + String.valueOf(this.uuid) + ": whispered " + whisperedInfo.description + " could not be added because the application is not responding: " + e.getMessage());
                }
                catch (TransactionRejectedException e) {
                    LOGGER.warning("node " + String.valueOf(this.uuid) + ": whispered " + whisperedInfo.description + " has been rejected: " + e.getMessage());
                }
            }
            Predicate<Whisperer> newSeen = whisperedInfo.seen.or(this.isThis);
            this.peers.whisper((WhisperMessage<?>)whisperedTransactionMessage, newSeen, whisperedInfo.description);
            this.boundWhisperers.forEach(whisperer -> whisperer.whisper((WhisperMessage)whisperedTransactionMessage, newSeen, whisperedInfo.description));
            this.onWhispered(tx);
        }
    }

    private void publisher() throws InterruptedException, ClosedApplicationException {
        while (true) {
            Block block = this.blocksToPublishQueue.take();
            try {
                this.app.publish(block);
                continue;
            }
            catch (TimeoutException e) {
                LOGGER.warning("cannot publish block " + block.getHexHash() + " since the application is unresponsive");
                continue;
            }
            break;
        }
    }

    private void whisperAllServices() {
        this.boundWhisperers.stream().filter(whisperer -> whisperer instanceof PublicNodeService).map(whisperer -> (PublicNodeService)whisperer).map(PublicNodeService::getURI).flatMap(Optional::stream).distinct().map(Peers::of).forEach(this::whisperWithoutAddition);
    }

    private void identifyNonFrozenPartOfBlockchain() throws InterruptedException, ClosedApplicationException, ClosedDatabaseException {
        try {
            Optional<LocalDateTime> maybeStartTimeOfNonFrozenPart = this.blockchain.getStartingTimeOfNonFrozenHistory();
            if (maybeStartTimeOfNonFrozenPart.isPresent()) {
                this.app.keepFrom(maybeStartTimeOfNonFrozenPart.get());
            }
        }
        catch (TimeoutException e) {
            LOGGER.log(Level.WARNING, "cannot identify the non-frozen part of the blockchain because the application is unresponsive: " + e.getMessage());
        }
    }

    private void closeExecutorsHandlersMinersPeersAndBlockchain() {
        try {
            this.executors.shutdownNow();
        }
        finally {
            try {
                this.periodicExecutors.shutdownNow();
            }
            finally {
                this.closeHandlersMinersPeersAndBlockchain();
            }
        }
    }

    private void closeHandlersMinersPeersAndBlockchain() {
        try {
            this.callCloseHandlers();
        }
        finally {
            this.closeMinersPeersAndBlockchain((Miner[])this.minersToCloseAtTheEnd.toArray(Miner[]::new), 0);
        }
    }

    private void closeMinersPeersAndBlockchain(Miner[] miners, int pos) {
        if (pos < miners.length) {
            try {
                miners[pos].close();
            }
            finally {
                this.closeMinersPeersAndBlockchain(miners, pos + 1);
            }
        } else {
            this.closePeersAndBlockchain();
        }
    }

    private void closePeersAndBlockchain() {
        try {
            this.peers.close();
        }
        finally {
            this.blockchain.close();
        }
    }

    public static interface Task {
        public void body() throws InterruptedException, ClosedDatabaseException, ClosedNodeException, ClosedApplicationException;
    }

    private static class WhisperedInfo<M extends WhisperMessage<?>> {
        private final M message;
        private final Predicate<Whisperer> seen;
        private final String description;
        private final boolean add;

        private WhisperedInfo(M message, Predicate<Whisperer> seen, String description, boolean add) {
            this.message = message;
            this.seen = seen;
            this.description = description;
            this.add = add;
        }
    }

    private class RunnableTask
    implements Runnable {
        private final Task task;
        private final String description;

        private RunnableTask(Task task, String description) {
            this.task = task;
            this.description = description;
        }

        @Override
        public final void run() {
            LocalNodeImpl.this.currentlyExecutingTasks.add(this);
            try {
                this.task.body();
            }
            catch (ClosedDatabaseException e) {
                LOGGER.warning("node " + String.valueOf(LocalNodeImpl.this.uuid) + ": " + String.valueOf(this) + " exits since the database has been closed: " + e.getMessage());
            }
            catch (ClosedNodeException e) {
                LOGGER.warning("node " + String.valueOf(LocalNodeImpl.this.uuid) + ": " + String.valueOf(this) + " exits since the node has been closed: " + e.getMessage());
            }
            catch (ClosedApplicationException e) {
                LOGGER.warning("node " + String.valueOf(LocalNodeImpl.this.uuid) + ": " + String.valueOf(this) + " exits since the application has been closed: " + e.getMessage());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warning("node " + String.valueOf(LocalNodeImpl.this.uuid) + ": " + String.valueOf(this) + " exits since the node is shutting down");
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "node " + String.valueOf(LocalNodeImpl.this.uuid) + ": " + String.valueOf(this) + " threw an exception", e);
            }
            finally {
                LocalNodeImpl.this.currentlyExecutingTasks.remove(this);
            }
        }

        public String toString() {
            return this.description;
        }
    }
}

