/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import com.moandjiezana.toml.Toml;
import io.mokamint.node.AbstractConsensusConfig;
import io.mokamint.node.AbstractConsensusConfigBuilder;
import io.mokamint.node.api.ConsensusConfig;
import io.mokamint.node.local.api.LocalNodeConfig;
import io.mokamint.node.local.api.LocalNodeConfigBuilder;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LocalNodeConfigImpl
extends AbstractConsensusConfig<LocalNodeConfig, LocalNodeConfigBuilder>
implements LocalNodeConfig {
    public final Path dir;
    public final int deadlineWaitTimeout;
    public final long minerInitialPoints;
    public final long minerPunishmentForTimeout;
    public final long minerPunishmentForIllegalDeadline;
    private final Set<URI> seeds;
    public final int maxPeers;
    public final long peerInitialPoints;
    public final int peerMaxTimeDifference;
    public final long peerPunishmentForUnreachable;
    public final int peerTimeout;
    public final int peerPingInterval;
    public final int serviceBroadcastInterval;
    public final int synchronizationInterval;
    public final int whisperingMemorySize;
    public final int orphansMemorySize;
    public final int mempoolSize;
    public final int synchronizationGroupSize;
    public final long blockMaxTimeInTheFuture;
    public final long maxHistoryChangeTime;
    public final int maxChainPortionLength;
    public final int maxMempoolPortionLength;

    private LocalNodeConfigImpl(LocalNodeConfigBuilderImpl builder) {
        super((AbstractConsensusConfigBuilder)builder);
        this.dir = builder.dir;
        this.deadlineWaitTimeout = builder.deadlineWaitTimeout;
        this.minerInitialPoints = builder.minerInitialPoints;
        this.minerPunishmentForTimeout = builder.minerPunishmentForTimeout;
        this.minerPunishmentForIllegalDeadline = builder.minerPunishmentForIllegalDeadline;
        this.seeds = builder.seeds;
        this.maxPeers = builder.maxPeers;
        this.peerInitialPoints = builder.peerInitialPoints;
        this.peerMaxTimeDifference = builder.peerMaxTimeDifference;
        this.peerPunishmentForUnreachable = builder.peerPunishmentForUnreachable;
        this.peerTimeout = builder.peerTimeout;
        this.peerPingInterval = builder.peerPingInterval;
        this.serviceBroadcastInterval = builder.serviceBroadcastInterval;
        this.synchronizationInterval = builder.synchronizationInterval;
        this.whisperingMemorySize = builder.whisperingMemorySize;
        this.orphansMemorySize = builder.orphansMemorySize;
        this.mempoolSize = builder.mempoolSize;
        this.synchronizationGroupSize = builder.synchronizationGroupSize;
        this.blockMaxTimeInTheFuture = builder.blockMaxTimeInTheFuture;
        this.maxHistoryChangeTime = builder.maxHistoryChangeTime;
        this.maxChainPortionLength = builder.maxChainPortionLength;
        this.maxMempoolPortionLength = builder.maxMempoolPortionLength;
    }

    public Path getDir() {
        return this.dir;
    }

    public int getDeadlineWaitTimeout() {
        return this.deadlineWaitTimeout;
    }

    public long getMinerInitialPoints() {
        return this.minerInitialPoints;
    }

    public long getMinerPunishmentForTimeout() {
        return this.minerPunishmentForTimeout;
    }

    public long getMinerPunishmentForIllegalDeadline() {
        return this.minerPunishmentForIllegalDeadline;
    }

    public Stream<URI> getSeeds() {
        return this.seeds.stream();
    }

    public int getMaxPeers() {
        return this.maxPeers;
    }

    public long getPeerInitialPoints() {
        return this.peerInitialPoints;
    }

    public int getPeerMaxTimeDifference() {
        return this.peerMaxTimeDifference;
    }

    public long getPeerPunishmentForUnreachable() {
        return this.peerPunishmentForUnreachable;
    }

    public int getPeerTimeout() {
        return this.peerTimeout;
    }

    public int getPeerPingInterval() {
        return this.peerPingInterval;
    }

    public int getServiceBrodcastInterval() {
        return this.serviceBroadcastInterval;
    }

    public int getSynchronizationInterval() {
        return this.synchronizationInterval;
    }

    public int getWhisperingMemorySize() {
        return this.whisperingMemorySize;
    }

    public int getOrphansMemorySize() {
        return this.orphansMemorySize;
    }

    public int getMempoolSize() {
        return this.mempoolSize;
    }

    public int getSynchronizationGroupSize() {
        return this.synchronizationGroupSize;
    }

    public long getBlockMaxTimeInTheFuture() {
        return this.blockMaxTimeInTheFuture;
    }

    public long getMaxHistoryChangeTime() {
        return this.maxHistoryChangeTime;
    }

    public int getMaxChainPortionLength() {
        return this.maxChainPortionLength;
    }

    public int getMaxMempoolPortionLength() {
        return this.maxMempoolPortionLength;
    }

    public String toToml() {
        StringBuilder sb = new StringBuilder(super.toToml());
        sb.append("\n");
        sb.append("## Local parameters\n");
        sb.append("\n");
        sb.append("# the path where the node's data will be persisted\n");
        sb.append("dir = \"" + String.valueOf(this.dir) + "\"\n");
        sb.append("\n");
        sb.append("# maximal milliseconds to wait between deadline request to the miners and first deadline reception\n");
        sb.append("deadline_wait_timeout = " + this.deadlineWaitTimeout + "\n");
        sb.append("\n");
        sb.append("# the initial points of a miner, freshly connected to a node\n");
        sb.append("miner_initial_points = " + this.minerInitialPoints + "\n");
        sb.append("\n");
        sb.append("# the points that a miner loses as punishment for a timeout at a request for a deadline\n");
        sb.append("miner_punishment_for_timeout = " + this.minerPunishmentForTimeout + "\n");
        sb.append("\n");
        sb.append("# the points that a miner loses as punishment for providing an illegal deadline\n");
        sb.append("miner_punishment_for_illegal_deadline = " + this.minerPunishmentForIllegalDeadline + "\n");
        sb.append("\n");
        sb.append("# the URIs of the initial peers, that will always get added to the previous set of peers\n");
        sb.append("# (if any) and contacted at start-up\n");
        sb.append("seeds = " + this.getSeeds().map(uri -> "\"" + String.valueOf(uri) + "\"").collect(Collectors.joining(",", "[", "]")) + "\n");
        sb.append("\n");
        sb.append("# the maximum amount of peers of a node; their actual number can be larger\n");
        sb.append("# only if peers are explicitly added as seeds or through the addPeer() method\n");
        sb.append("# of the restricted API of the node\n");
        sb.append("max_peers = " + this.maxPeers + "\n");
        sb.append("\n");
        sb.append("# the initial points of a peer, freshly added to a node\n");
        sb.append("peer_initial_points = " + this.peerInitialPoints + "\n");
        sb.append("\n");
        sb.append("# the maximal time difference (in milliseconds) between a node and each of its peers\n");
        sb.append("peer_max_time_difference = " + this.peerMaxTimeDifference + "\n");
        sb.append("\n");
        sb.append("# the points that a peer loses as punishment for not answering a ping\n");
        sb.append("peer_punishment_for_unreachable = " + this.peerPunishmentForUnreachable + "\n");
        sb.append("\n");
        sb.append("# the time (in milliseconds) for communications to the peers\n");
        sb.append("peer_timeout = " + this.peerTimeout + "\n");
        sb.append("\n");
        sb.append("# the time, in milliseconds, between successive pings to a peer\n");
        sb.append("peer_ping_interval = " + this.peerPingInterval + "\n");
        sb.append("\n");
        sb.append("# the time, in milliseconds, between successive broadcasts of a service\n");
        sb.append("service_broadcast_interval = " + this.serviceBroadcastInterval + "\n");
        sb.append("\n");
        sb.append("# the size of the memory used to avoid whispering the same message again\n");
        sb.append("whispering_memory_size = " + this.whisperingMemorySize + "\n");
        sb.append("\n");
        sb.append("# the size of the memory used to hold orphan nodes\n");
        sb.append("orphans_memory_size = " + this.orphansMemorySize + "\n");
        sb.append("\n");
        sb.append("# the size of the memory used to hold incoming transactions before they get put into blocks\n");
        sb.append("mempool_size = " + this.mempoolSize + "\n");
        sb.append("\n");
        sb.append("# the size of the group of blocks whose hashes get downloaded in one shot during synchronization\n");
        sb.append("synchronization_group_size = " + this.synchronizationGroupSize + "\n");
        sb.append("\n");
        sb.append("# the time, in milliseconds, between successive synchronizations\n");
        sb.append("synchronization_interval = " + this.synchronizationInterval + "\n");
        sb.append("\n");
        sb.append("# the maximal creation time in the future (in milliseconds) of a block\n");
        sb.append("block_max_time_in_the_future = " + this.blockMaxTimeInTheFuture + "\n");
        sb.append("\n");
        sb.append("# the maximal time (in milliseconds) that history can be changed before being considered as definitely frozen;\n");
        sb.append("# a negative value means that the history is always allowed to be changed, without limits\n");
        sb.append("max_history_change_time = " + this.maxHistoryChangeTime + "\n");
        sb.append("\n");
        sb.append("# the maximal number of block hashes that can be fetched with a single call to PublicNode.getChainPortion()\n");
        sb.append("max_chain_portion_length = " + this.maxChainPortionLength + "\n");
        sb.append("\n");
        sb.append("# the maximal number of mempool elements that can be fetched with a single call to PublicNode.getMempoolPortion()\n");
        sb.append("max_mempool_portion_length = " + this.maxMempoolPortionLength + "\n");
        return sb.toString();
    }

    public LocalNodeConfigBuilder toBuilder() {
        return new LocalNodeConfigBuilderImpl(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!super.equals(other)) return false;
        if (!(other instanceof LocalNodeConfigImpl)) return false;
        LocalNodeConfigImpl otherConfig = (LocalNodeConfigImpl)((Object)other);
        if (!this.dir.equals(otherConfig.dir)) return false;
        if (this.deadlineWaitTimeout != otherConfig.deadlineWaitTimeout) return false;
        if (this.minerInitialPoints != otherConfig.minerInitialPoints) return false;
        if (this.minerPunishmentForTimeout != otherConfig.minerPunishmentForTimeout) return false;
        if (this.minerPunishmentForIllegalDeadline != otherConfig.minerPunishmentForIllegalDeadline) return false;
        if (!this.seeds.equals(otherConfig.seeds)) return false;
        if (this.maxPeers != otherConfig.maxPeers) return false;
        if (this.peerInitialPoints != otherConfig.peerInitialPoints) return false;
        if (this.peerMaxTimeDifference != otherConfig.peerMaxTimeDifference) return false;
        if (this.peerPunishmentForUnreachable != otherConfig.peerPunishmentForUnreachable) return false;
        if (this.peerTimeout != otherConfig.peerTimeout) return false;
        if (this.peerPingInterval != otherConfig.peerPingInterval) return false;
        if (this.serviceBroadcastInterval != otherConfig.serviceBroadcastInterval) return false;
        if (this.synchronizationInterval != otherConfig.synchronizationInterval) return false;
        if (this.whisperingMemorySize != otherConfig.whisperingMemorySize) return false;
        if (this.orphansMemorySize != otherConfig.orphansMemorySize) return false;
        if (this.mempoolSize != otherConfig.mempoolSize) return false;
        if (this.synchronizationGroupSize != otherConfig.synchronizationGroupSize) return false;
        if (this.blockMaxTimeInTheFuture != otherConfig.blockMaxTimeInTheFuture) return false;
        if (this.maxHistoryChangeTime != otherConfig.maxHistoryChangeTime) return false;
        if (this.maxChainPortionLength != otherConfig.maxChainPortionLength) return false;
        if (this.maxMempoolPortionLength != otherConfig.maxMempoolPortionLength) return false;
        return true;
    }

    public static class LocalNodeConfigBuilderImpl
    extends AbstractConsensusConfigBuilder<LocalNodeConfig, LocalNodeConfigBuilder>
    implements LocalNodeConfigBuilder {
        private Path dir = Paths.get("mokamint-chain", new String[0]);
        private int deadlineWaitTimeout = 20000;
        private long minerInitialPoints = 1000L;
        private long minerPunishmentForTimeout = 0L;
        private long minerPunishmentForIllegalDeadline = 500L;
        private final Set<URI> seeds = new HashSet<URI>();
        private int maxPeers = 20;
        private long peerInitialPoints = 1000L;
        private int peerMaxTimeDifference = 15000;
        private long peerPunishmentForUnreachable = 1L;
        private int peerTimeout = 10000;
        private int peerPingInterval = 120000;
        private int serviceBroadcastInterval = 240000;
        private int synchronizationInterval = 300000;
        private int whisperingMemorySize = 1000;
        private int orphansMemorySize = 1000;
        private int mempoolSize = 100000;
        private int synchronizationGroupSize = 500;
        private long blockMaxTimeInTheFuture = 10000L;
        private long maxHistoryChangeTime = 5 * this.synchronizationGroupSize * this.getTargetBlockCreationTime();
        private int maxChainPortionLength = 1024;
        private int maxMempoolPortionLength = 1024;

        public LocalNodeConfigBuilderImpl() throws NoSuchAlgorithmException {
        }

        private LocalNodeConfigBuilderImpl(Toml toml) throws NoSuchAlgorithmException, URISyntaxException {
            super(toml);
            Long maxMempoolPortionLength;
            Long maxChainPortionLength;
            Long maximalHistoryChangeTime;
            Long blockMaxTimeInTheFuture;
            Long synchronizationGroupSize;
            Long mempoolSize;
            Long orphansMemorySize;
            Long whisperingMemorySize;
            Long synhronizationInterval;
            Long serviceBroadcastInterval;
            Long peerPingInterval;
            Long peerTimeout;
            Long peerPunishmentForUnreachable;
            Long peerMaxTimeDifference;
            Long peerInitialPoints;
            Long maxCandidatePeers;
            Long maxPeers;
            List seeds;
            Long minerPunishmentForIllegalDeadline;
            Long minerPunishmentForTimeout;
            Long minerInitialPoints;
            Long deadlineWaitTimeout;
            String dir = toml.getString("dir");
            if (dir != null) {
                this.setDir(Paths.get(dir, new String[0]));
            }
            if ((deadlineWaitTimeout = toml.getLong("deadline_wait_timeout")) != null) {
                this.setDeadlineWaitTimeout(deadlineWaitTimeout);
            }
            if ((minerInitialPoints = toml.getLong("miner_initial_points")) != null) {
                this.setMinerInitialPoints(minerInitialPoints);
            }
            if ((minerPunishmentForTimeout = toml.getLong("miner_punishment_for_timeout")) != null) {
                this.setMinerPunishmentForTimeout(minerPunishmentForTimeout);
            }
            if ((minerPunishmentForIllegalDeadline = toml.getLong("miner_punishment_for_illegal_deadline")) != null) {
                this.setMinerPunishmentForIllegalDeadline(minerPunishmentForIllegalDeadline);
            }
            if ((seeds = toml.getList("seeds")) != null) {
                for (String uri : seeds) {
                    this.seeds.add(new URI(uri));
                }
            }
            if ((maxPeers = toml.getLong("max_peers")) != null) {
                this.setMaxPeers(maxPeers);
            }
            if ((maxCandidatePeers = toml.getLong("max_candidate_peers")) != null) {
                this.setMaxPeers(maxCandidatePeers);
            }
            if ((peerInitialPoints = toml.getLong("peer_initial_points")) != null) {
                this.setPeerInitialPoints(peerInitialPoints);
            }
            if ((peerMaxTimeDifference = toml.getLong("peer_max_time_difference")) != null) {
                this.setPeerMaxTimeDifference(peerMaxTimeDifference);
            }
            if ((peerPunishmentForUnreachable = toml.getLong("peer_punishment_for_unreachable")) != null) {
                this.setPeerPunishmentForUnreachable(peerPunishmentForUnreachable);
            }
            if ((peerTimeout = toml.getLong("peer_timeout")) != null) {
                this.setPeerTimeout(peerTimeout);
            }
            if ((peerPingInterval = toml.getLong("peer_ping_interval")) != null) {
                this.setPeerPingInterval(peerPingInterval);
            }
            if ((serviceBroadcastInterval = toml.getLong("service_broadcast_interval")) != null) {
                this.setServiceBroadcastInterval(serviceBroadcastInterval);
            }
            if ((synhronizationInterval = toml.getLong("synchronization_interval")) != null) {
                this.setSynchronizationInterval(synhronizationInterval);
            }
            if ((whisperingMemorySize = toml.getLong("whispering_memory_size")) != null) {
                this.setWhisperingMemorySize(whisperingMemorySize);
            }
            if ((orphansMemorySize = toml.getLong("orphans_memory_size")) != null) {
                this.setOrphansMemorySize(orphansMemorySize);
            }
            if ((mempoolSize = toml.getLong("mempool_size")) != null) {
                this.setMempoolSize(mempoolSize);
            }
            if ((synchronizationGroupSize = toml.getLong("synchronization_group_size")) != null) {
                this.setSynchronizationGroupSize(synchronizationGroupSize);
            }
            if ((blockMaxTimeInTheFuture = toml.getLong("block_max_time_in_the_future")) != null) {
                this.setBlockMaxTimeInTheFuture(blockMaxTimeInTheFuture);
            }
            if ((maximalHistoryChangeTime = toml.getLong("max_history_change_time")) != null) {
                this.setMaxHistoryChangeTime(maximalHistoryChangeTime);
            }
            if ((maxChainPortionLength = toml.getLong("max_chain_portion_length")) != null) {
                this.setMaxChainPortionLength(maxChainPortionLength);
            }
            if ((maxMempoolPortionLength = toml.getLong("max_mempool_portion_length")) != null) {
                this.setMaxMempoolPortionLength(maxMempoolPortionLength);
            }
        }

        public LocalNodeConfigBuilderImpl(Path toml) throws FileNotFoundException, NoSuchAlgorithmException, URISyntaxException {
            this(LocalNodeConfigBuilderImpl.readToml((Path)toml));
        }

        private LocalNodeConfigBuilderImpl(LocalNodeConfigImpl config) {
            super((ConsensusConfig)config);
            this.dir = config.dir;
            this.deadlineWaitTimeout = config.deadlineWaitTimeout;
            this.minerInitialPoints = config.minerInitialPoints;
            this.minerPunishmentForTimeout = config.minerPunishmentForTimeout;
            this.minerPunishmentForIllegalDeadline = config.minerPunishmentForIllegalDeadline;
            this.seeds.addAll(config.seeds);
            this.maxPeers = config.maxPeers;
            this.peerInitialPoints = config.peerInitialPoints;
            this.peerMaxTimeDifference = config.peerMaxTimeDifference;
            this.peerPunishmentForUnreachable = config.peerPunishmentForUnreachable;
            this.peerTimeout = config.peerTimeout;
            this.peerPingInterval = config.peerPingInterval;
            this.serviceBroadcastInterval = config.serviceBroadcastInterval;
            this.synchronizationInterval = config.synchronizationInterval;
            this.whisperingMemorySize = config.whisperingMemorySize;
            this.orphansMemorySize = config.orphansMemorySize;
            this.mempoolSize = config.mempoolSize;
            this.synchronizationGroupSize = config.synchronizationGroupSize;
            this.blockMaxTimeInTheFuture = config.blockMaxTimeInTheFuture;
            this.maxHistoryChangeTime = config.maxHistoryChangeTime;
            this.maxChainPortionLength = config.maxChainPortionLength;
            this.maxMempoolPortionLength = config.maxMempoolPortionLength;
        }

        public LocalNodeConfigBuilder setDir(Path dir) {
            Objects.requireNonNull(dir);
            this.dir = dir;
            return this.getThis();
        }

        public LocalNodeConfigBuilder setDeadlineWaitTimeout(int deadlineWaitTimeout) {
            if (deadlineWaitTimeout < 0) {
                throw new IllegalArgumentException("deadlineWaitTimeout must be non-negative");
            }
            this.deadlineWaitTimeout = deadlineWaitTimeout;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setDeadlineWaitTimeout(long deadlineWaitTimeout) {
            if (deadlineWaitTimeout < 0L || deadlineWaitTimeout > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("deadlineWaitTimeout must be between 0 and 2147483647 inclusive");
            }
            this.deadlineWaitTimeout = (int)deadlineWaitTimeout;
            return this.getThis();
        }

        public LocalNodeConfigBuilder setMinerInitialPoints(long minerInitialPoints) {
            if (minerInitialPoints <= 0L) {
                throw new IllegalArgumentException("minerInitialPoints must be positive");
            }
            this.minerInitialPoints = minerInitialPoints;
            return this.getThis();
        }

        public LocalNodeConfigBuilder setMinerPunishmentForTimeout(long minerPunishmentForTimeout) {
            if (minerPunishmentForTimeout < 0L) {
                throw new IllegalArgumentException("minerPunishmentForTimeout must be non-negative");
            }
            this.minerPunishmentForTimeout = minerPunishmentForTimeout;
            return this.getThis();
        }

        public LocalNodeConfigBuilder setMinerPunishmentForIllegalDeadline(long minerPunishmentForIllegalDeadline) {
            if (minerPunishmentForIllegalDeadline < 0L) {
                throw new IllegalArgumentException("minerPunishmentForIllegalDeadline must be non-negative");
            }
            this.minerPunishmentForIllegalDeadline = minerPunishmentForIllegalDeadline;
            return this.getThis();
        }

        public LocalNodeConfigBuilder addSeed(URI uri) {
            this.seeds.add(Objects.requireNonNull(uri));
            return this.getThis();
        }

        public LocalNodeConfigBuilder setMaxPeers(int maxPeers) {
            if (maxPeers < 0) {
                throw new IllegalArgumentException("maxPeers must be non-negative");
            }
            this.maxPeers = maxPeers;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setMaxPeers(long maxPeers) {
            if (maxPeers < 0L || maxPeers > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("maxPeers must be between 0 and 2147483647 inclusive");
            }
            return this.setMaxPeers((int)maxPeers);
        }

        public LocalNodeConfigBuilder setPeerInitialPoints(long peerInitialPoints) {
            if (peerInitialPoints <= 0L) {
                throw new IllegalArgumentException("peerInitialPoints must be positive");
            }
            this.peerInitialPoints = peerInitialPoints;
            return this.getThis();
        }

        public LocalNodeConfigBuilder setPeerMaxTimeDifference(int peerMaxTimeDifference) {
            if ((long)peerMaxTimeDifference < 0L) {
                throw new IllegalArgumentException("peerMaxTimeDifference must be non-negative");
            }
            this.peerMaxTimeDifference = peerMaxTimeDifference;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setPeerMaxTimeDifference(long peerMaxTimeDifference) {
            if (peerMaxTimeDifference < 0L || peerMaxTimeDifference > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("peerMaxTimeDifference must be between 0 and 2147483647 inclusive");
            }
            return this.setPeerMaxTimeDifference((int)peerMaxTimeDifference);
        }

        public LocalNodeConfigBuilder setPeerPunishmentForUnreachable(long peerPunishmentForUnreachable) {
            if (peerPunishmentForUnreachable < 0L) {
                throw new IllegalArgumentException("peerPunishmentForUnreachable must be non-negative");
            }
            this.peerPunishmentForUnreachable = peerPunishmentForUnreachable;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setPeerTimeout(long peerTimeout) {
            if (peerTimeout > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("peerTimeout cannot be larger than 2147483647");
            }
            return this.setPeerTimeout((int)peerTimeout);
        }

        public LocalNodeConfigBuilder setPeerTimeout(int peerTimeout) {
            if (peerTimeout < 0) {
                throw new IllegalArgumentException("peerTimeout must be non-negative");
            }
            this.peerTimeout = peerTimeout;
            return this.getThis();
        }

        public LocalNodeConfigBuilder setPeerPingInterval(int peerPingInterval) {
            this.peerPingInterval = peerPingInterval;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setPeerPingInterval(long peerPingInterval) {
            if (peerPingInterval < Integer.MIN_VALUE || peerPingInterval > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("peerTimeout must be between -2147483648 and 2147483647 inclusive");
            }
            return this.setPeerPingInterval((int)peerPingInterval);
        }

        public LocalNodeConfigBuilder setServiceBroadcastInterval(int serviceBroadcastInterval) {
            this.serviceBroadcastInterval = serviceBroadcastInterval;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setServiceBroadcastInterval(long serviceBroadcastInterval) {
            if (serviceBroadcastInterval < Integer.MIN_VALUE || serviceBroadcastInterval > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("serviceBroadcastInterval must be between -2147483648 and 2147483647 inclusive");
            }
            return this.setServiceBroadcastInterval((int)serviceBroadcastInterval);
        }

        public LocalNodeConfigBuilder setSynchronizationInterval(int synchronizationInterval) {
            this.synchronizationInterval = synchronizationInterval;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setSynchronizationInterval(long synchronizationInterval) {
            if (synchronizationInterval < Integer.MIN_VALUE || synchronizationInterval > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("synchronizationInterval must be between -2147483648 and 2147483647 inclusive");
            }
            return this.setSynchronizationInterval((int)synchronizationInterval);
        }

        public LocalNodeConfigBuilder setWhisperingMemorySize(int whisperingMemorySize) {
            if (whisperingMemorySize < 0) {
                throw new IllegalArgumentException("whisperingMemorySize must be non-negative");
            }
            this.whisperingMemorySize = whisperingMemorySize;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setWhisperingMemorySize(long whisperingMemorySize) {
            if (whisperingMemorySize < 0L || whisperingMemorySize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("whisperingMemorySize must be between 0 and 2147483647 inclusive");
            }
            return this.setWhisperingMemorySize((int)whisperingMemorySize);
        }

        public LocalNodeConfigBuilder setOrphansMemorySize(int orphansMemorySize) {
            if (orphansMemorySize < 0) {
                throw new IllegalArgumentException("orphansMemorySize must be non-negative");
            }
            this.orphansMemorySize = orphansMemorySize;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setOrphansMemorySize(long orphansMemorySize) {
            if (orphansMemorySize < 0L || orphansMemorySize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("orphansMemorySize must be between 0 and 2147483647 inclusive");
            }
            return this.setOrphansMemorySize((int)orphansMemorySize);
        }

        public LocalNodeConfigBuilder setMempoolSize(int mempoolSize) {
            if (mempoolSize < 0) {
                throw new IllegalArgumentException("mempoolSize must be non-negative");
            }
            this.mempoolSize = mempoolSize;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setMempoolSize(long mempoolSize) {
            if (mempoolSize < 0L || mempoolSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("mempoolSize must be between 0 and 2147483647 inclusive");
            }
            return this.setMempoolSize((int)mempoolSize);
        }

        public LocalNodeConfigBuilder setSynchronizationGroupSize(int synchronizationGroupSize) {
            if (synchronizationGroupSize <= 0) {
                throw new IllegalArgumentException("synchronizationGroupSize must be positive");
            }
            this.synchronizationGroupSize = synchronizationGroupSize;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setSynchronizationGroupSize(long synchronizationGroupSize) {
            if (synchronizationGroupSize <= 0L || synchronizationGroupSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("synchronizationGroupSize must be between 1 and 2147483647 inclusive");
            }
            return this.setSynchronizationGroupSize((int)synchronizationGroupSize);
        }

        public LocalNodeConfigBuilder setBlockMaxTimeInTheFuture(long blockMaxTimeInTheFuture) {
            if (blockMaxTimeInTheFuture < 0L) {
                throw new IllegalArgumentException("blockMaxTimeInTheFuture must be non-negative");
            }
            this.blockMaxTimeInTheFuture = blockMaxTimeInTheFuture;
            return this.getThis();
        }

        public LocalNodeConfigBuilder setMaxHistoryChangeTime(long maxHistoryChangeTime) {
            this.maxHistoryChangeTime = maxHistoryChangeTime;
            return this.getThis();
        }

        public LocalNodeConfigBuilder setMaxChainPortionLength(int maxChainPortionLength) {
            if (maxChainPortionLength < 2) {
                throw new IllegalArgumentException("maxChainPortionLength must be at least 2");
            }
            this.maxChainPortionLength = maxChainPortionLength;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setMaxChainPortionLength(long maxChainPortionLength) {
            if (maxChainPortionLength < 2L || maxChainPortionLength > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("maxChainPortionLength must be between 2 and 2147483647 inclusive");
            }
            return this.setMaxChainPortionLength((int)maxChainPortionLength);
        }

        public LocalNodeConfigBuilder setMaxMempoolPortionLength(int maximalMempoolPortionLength) {
            if (maximalMempoolPortionLength < 1) {
                throw new IllegalArgumentException("maxMempoolPortionLength must be at least 1");
            }
            this.maxMempoolPortionLength = maximalMempoolPortionLength;
            return this.getThis();
        }

        private LocalNodeConfigBuilder setMaxMempoolPortionLength(long maxMempoolPortionLength) {
            if (maxMempoolPortionLength < 1L || maxMempoolPortionLength > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("maxMempoolPortionLength must be between 1 and 2147483647 inclusive");
            }
            return this.setMaxMempoolPortionLength((int)maxMempoolPortionLength);
        }

        public LocalNodeConfig build() {
            return new LocalNodeConfigImpl(this);
        }

        protected LocalNodeConfigBuilder getThis() {
            return this;
        }
    }
}

