/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import io.hotmoka.closeables.AbstractAutoCloseableWithLock;
import io.hotmoka.closeables.api.ClosureLock;
import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.hotmoka.exceptions.functions.FunctionWithExceptions4;
import io.hotmoka.exceptions.functions.FunctionWithExceptions5;
import io.hotmoka.marshalling.AbstractMarshallable;
import io.hotmoka.marshalling.UnmarshallingContexts;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.hotmoka.xodus.ByteIterable;
import io.hotmoka.xodus.ExodusException;
import io.hotmoka.xodus.env.Environment;
import io.hotmoka.xodus.env.Store;
import io.hotmoka.xodus.env.Transaction;
import io.mokamint.application.api.ClosedApplicationException;
import io.mokamint.node.BlockDescriptions;
import io.mokamint.node.Blocks;
import io.mokamint.node.ChainInfos;
import io.mokamint.node.Memories;
import io.mokamint.node.TransactionAddresses;
import io.mokamint.node.api.ApplicationTimeoutException;
import io.mokamint.node.api.Block;
import io.mokamint.node.api.BlockDescription;
import io.mokamint.node.api.ChainInfo;
import io.mokamint.node.api.ClosedNodeException;
import io.mokamint.node.api.ConsensusConfig;
import io.mokamint.node.api.GenesisBlock;
import io.mokamint.node.api.GenesisBlockDescription;
import io.mokamint.node.api.Memory;
import io.mokamint.node.api.NonGenesisBlock;
import io.mokamint.node.api.PortionRejectedException;
import io.mokamint.node.api.TransactionAddress;
import io.mokamint.node.api.TransactionRejectedException;
import io.mokamint.node.local.AlreadyInitializedException;
import io.mokamint.node.local.LocalNodeException;
import io.mokamint.node.local.api.LocalNodeConfig;
import io.mokamint.node.local.internal.BlockVerification;
import io.mokamint.node.local.internal.ClosedDatabaseException;
import io.mokamint.node.local.internal.LocalNodeImpl;
import io.mokamint.node.local.internal.Mempool;
import io.mokamint.node.local.internal.MisbehavingApplicationException;
import io.mokamint.node.local.internal.Synchronization;
import io.mokamint.node.local.internal.VerificationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class Blockchain
extends AbstractAutoCloseableWithLock<ClosedDatabaseException> {
    private final LocalNodeImpl node;
    private final LocalNodeConfig config;
    private final Environment environment;
    private final Store storeOfBlocks;
    private final Store storeOfForwards;
    private final Store storeOfChain;
    private final Store storeOfTransactions;
    private final long maximalHistoryChangeTime;
    private volatile Optional<byte[]> genesisHashCache;
    private volatile Optional<GenesisBlock> genesisCache;
    private final Memory<NonGenesisBlock> orphans;
    private final ExecutorService executors = Executors.newCachedThreadPool();
    private static final ByteIterable HASH_OF_GENESIS = ByteIterable.fromByte((byte)0);
    private static final ByteIterable HASH_OF_HEAD = ByteIterable.fromByte((byte)1);
    private static final ByteIterable POWER_OF_HEAD = ByteIterable.fromByte((byte)2);
    private static final ByteIterable HEIGHT_OF_HEAD = ByteIterable.fromByte((byte)3);
    private static final ByteIterable STATE_ID_OF_HEAD = ByteIterable.fromByte((byte)4);
    private static final ByteIterable HASH_OF_START_OF_NON_FROZEN_PART = ByteIterable.fromByte((byte)5);
    private static final ByteIterable TOTAL_WAITING_TIME_OF_START_OF_NON_FROZEN_PART = ByteIterable.fromByte((byte)6);
    private static final Logger LOGGER = Logger.getLogger(Blockchain.class.getName());

    public Blockchain(LocalNodeImpl node) throws ClosedNodeException {
        super(ClosedDatabaseException::new);
        this.node = node;
        this.config = node.getConfig();
        this.maximalHistoryChangeTime = this.config.getMaxHistoryChangeTime();
        this.orphans = Memories.of((int)this.config.getOrphansMemorySize());
        this.environment = this.createBlockchainEnvironment();
        this.storeOfBlocks = this.openStore("blocks");
        this.storeOfForwards = this.openStore("forwards");
        this.storeOfChain = this.openStore("chain");
        this.storeOfTransactions = this.openStore("transactions");
        this.genesisHashCache = Optional.empty();
        this.genesisCache = Optional.empty();
    }

    public void close() {
        block7: {
            try {
                if (!this.stopNewCalls()) break block7;
                try {
                    this.environment.close();
                    LOGGER.info("blockchain: closed the blocks database");
                }
                catch (ExodusException e) {
                    LOGGER.warning("blockchain: failed to close the blocks database: " + e.getMessage());
                }
                finally {
                    this.executors.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isEmpty() throws ClosedDatabaseException {
        boolean bl;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                bl = (Boolean)this.environment.computeInReadonlyTransaction(this::isEmpty);
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return bl;
    }

    public Optional<byte[]> getGenesisHash() throws ClosedDatabaseException {
        Optional result;
        if (this.genesisHashCache.isPresent()) {
            return this.genesisHashCache.map(rec$ -> (byte[])((byte[])rec$).clone());
        }
        try (ClosureLock.Scope scope = this.mkScope();){
            result = (Optional)this.environment.computeInReadonlyTransaction(this::getGenesisHash);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
        this.genesisHashCache = result.map(rec$ -> (byte[])((byte[])rec$).clone());
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<GenesisBlock> getGenesis() throws ClosedDatabaseException {
        try (ClosureLock.Scope scope = this.mkScope();){
            if (this.genesisCache.isPresent()) {
                Optional<GenesisBlock> optional2 = this.genesisCache;
                return optional2;
            }
            Optional optional = this.genesisCache = (Optional)this.environment.computeInReadonlyTransaction(this::getGenesis);
            return optional;
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    public Optional<Block> getHead() throws ClosedDatabaseException {
        Optional optional;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                optional = (Optional)this.environment.computeInReadonlyTransaction(this::getHead);
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return optional;
    }

    public Optional<Block> getStartOfNonFrozenPart() throws ClosedDatabaseException {
        Optional optional;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                optional = (Optional)this.environment.computeInReadonlyTransaction(this::getStartOfNonFrozenPart);
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return optional;
    }

    public Optional<LocalDateTime> getStartingTimeOfNonFrozenHistory() throws ClosedDatabaseException {
        Optional optional;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                optional = (Optional)this.environment.computeInReadonlyTransaction(this::getStartingTimeOfNonFrozenHistory);
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return optional;
    }

    public OptionalLong getHeightOfHead() throws ClosedDatabaseException {
        OptionalLong optionalLong;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                optionalLong = (OptionalLong)this.environment.computeInReadonlyTransaction(this::getHeightOfHead);
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return optionalLong;
    }

    public Optional<Block> getBlock(byte[] hash) throws ClosedDatabaseException {
        Optional optional;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                optional = (Optional)this.environment.computeInReadonlyTransaction(txn -> this.getBlock((Transaction)txn, hash));
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return optional;
    }

    public Optional<BlockDescription> getBlockDescription(byte[] hash) throws ClosedDatabaseException {
        Optional optional;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                optional = (Optional)this.environment.computeInReadonlyTransaction(txn -> this.getBlockDescription((Transaction)txn, hash));
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return optional;
    }

    public Optional<io.mokamint.node.api.Transaction> getTransaction(byte[] hash) throws ClosedDatabaseException {
        Optional optional;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                optional = (Optional)this.environment.computeInReadonlyTransaction(txn -> this.getTransaction((Transaction)txn, hash));
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return optional;
    }

    public Optional<TransactionAddress> getTransactionAddress(byte[] hash) throws ClosedDatabaseException {
        Optional optional;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                optional = (Optional)this.environment.computeInReadonlyTransaction(txn -> this.getTransactionAddress((Transaction)txn, hash));
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return optional;
    }

    public Optional<TransactionAddress> getTransactionAddress(Block block, byte[] hash) throws ClosedDatabaseException {
        Optional optional;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                optional = (Optional)this.environment.computeInReadonlyTransaction(txn -> this.getTransactionAddress((Transaction)txn, block, hash));
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return optional;
    }

    public ChainInfo getChainInfo() throws ClosedDatabaseException {
        ChainInfo chainInfo;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                chainInfo = (ChainInfo)this.environment.computeInReadonlyTransaction(this::getChainInfo);
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return chainInfo;
    }

    public Stream<byte[]> getChain(long start, int count) throws ClosedDatabaseException, PortionRejectedException {
        Stream stream;
        block9: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                int max = this.config.getMaxChainPortionLength();
                if (count > max) {
                    throw new PortionRejectedException("count cannot be larger than " + max);
                }
                stream = (Stream)this.environment.computeInReadonlyTransaction(txn -> this.getChain((Transaction)txn, start, count));
                if (scope == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return stream;
    }

    public boolean containsBlock(byte[] hash) throws ClosedDatabaseException {
        boolean bl;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                bl = (Boolean)this.environment.computeInReadonlyTransaction(txn -> this.containsBlock((Transaction)txn, hash));
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return bl;
    }

    public boolean isBetterThanHead(NonGenesisBlock block) throws ClosedDatabaseException {
        boolean bl;
        block8: {
            ClosureLock.Scope scope = this.mkScope();
            try {
                bl = (Boolean)this.environment.computeInReadonlyTransaction(txn -> this.isBetterThanHead((Transaction)txn, block));
                if (scope == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExodusException e) {
                    throw new LocalNodeException(e);
                }
            }
            scope.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<LocalDateTime> creationTimeOf(Block block) throws ClosedDatabaseException {
        try (ClosureLock.Scope scope = this.mkScope();){
            if (block instanceof GenesisBlock) {
                GenesisBlock gb = (GenesisBlock)block;
                Optional<LocalDateTime> optional2 = Optional.of(gb.getStartDateTimeUTC());
                return optional2;
            }
            Optional<LocalDateTime> optional = this.getGenesis().map(genesis -> genesis.getStartDateTimeUTC().plus(block.getDescription().getTotalWaitingTime(), ChronoUnit.MILLIS));
            return optional;
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    void initialize() throws InterruptedException, ApplicationTimeoutException, AlreadyInitializedException, ClosedDatabaseException, InvalidKeyException, SignatureException, ClosedApplicationException, MisbehavingApplicationException {
        if (!this.isEmpty()) {
            throw new AlreadyInitializedException("Initialization cannot be required for an already initialized blockchain");
        }
        KeyPair keys = this.node.getKeys();
        try {
            GenesisBlockDescription description = BlockDescriptions.genesis((LocalDateTime)LocalDateTime.now(ZoneId.of("UTC")), (int)this.config.getTargetBlockCreationTime(), (int)this.config.getOblivion(), (HashingAlgorithm)this.config.getHashingForBlocks(), (HashingAlgorithm)this.config.getHashingForTransactions(), (HashingAlgorithm)this.config.getHashingForDeadlines(), (HashingAlgorithm)this.config.getHashingForGenerations(), (SignatureAlgorithm)this.config.getSignatureForBlocks(), (PublicKey)keys.getPublic());
            this.addVerified((Block)Blocks.genesis((GenesisBlockDescription)description, (byte[])this.node.getApplication().getInitialStateId(), (PrivateKey)keys.getPrivate()));
        }
        catch (TimeoutException e) {
            throw new ApplicationTimeoutException(e);
        }
    }

    public boolean add(Block block) throws VerificationException, InterruptedException, ApplicationTimeoutException, ClosedDatabaseException, ClosedApplicationException, MisbehavingApplicationException {
        return this.add(block, Optional.of(BlockVerification.Mode.COMPLETE));
    }

    boolean addVerified(Block block) throws InterruptedException, ApplicationTimeoutException, ClosedDatabaseException, ClosedApplicationException, MisbehavingApplicationException {
        try {
            return this.add(block, Optional.empty());
        }
        catch (VerificationException e) {
            throw new RuntimeException("Unexpected exception: verification was not required", e);
        }
    }

    public void synchronize() throws InterruptedException, ClosedNodeException, ClosedDatabaseException {
        try {
            new Synchronization(this.node, this.executors);
        }
        finally {
            this.node.onSynchronizationCompleted();
        }
    }

    public void rebase(Mempool mempool, Block newBase) throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
        FunctionWithExceptions4 function = txn -> new Rebase((Transaction)txn, mempool, newBase);
        ((Rebase)this.environment.computeInReadonlyTransaction(InterruptedException.class, ApplicationTimeoutException.class, ClosedApplicationException.class, MisbehavingApplicationException.class, function)).updateMempool();
    }

    public boolean add(Block block, Optional<BlockVerification.Mode> verification) throws ClosedDatabaseException, VerificationException, InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
        BlockAdder adder;
        FunctionWithExceptions5 function = txn -> new BlockAdder((Transaction)txn).add(block, verification);
        try (ClosureLock.Scope scope = this.mkScope();){
            adder = (BlockAdder)this.environment.computeInTransaction(VerificationException.class, InterruptedException.class, ApplicationTimeoutException.class, ClosedApplicationException.class, MisbehavingApplicationException.class, function);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
        adder.informNode();
        adder.updateMempool();
        return adder.somethingHasBeenAdded();
    }

    public boolean connect(Block block, Optional<BlockVerification.Mode> verification) throws VerificationException, InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException, ClosedDatabaseException {
        BlockAdder adder;
        FunctionWithExceptions5 function = txn -> new BlockAdder((Transaction)txn).add(block, verification);
        try (ClosureLock.Scope scope = this.mkScope();){
            adder = (BlockAdder)this.environment.computeInTransaction(VerificationException.class, InterruptedException.class, ApplicationTimeoutException.class, ClosedApplicationException.class, MisbehavingApplicationException.class, function);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
        adder.informNode();
        adder.updateMempool();
        return adder.addedBlockHasBeenConnected();
    }

    private boolean isInFrozenPart(Transaction txn, BlockDescription blockDescription) {
        OptionalLong totalWaitingTimeOfStartOfNonFrozenPart = this.getTotalWaitingTimeOfStartOfNonFrozenPart(txn);
        return totalWaitingTimeOfStartOfNonFrozenPart.isPresent() && totalWaitingTimeOfStartOfNonFrozenPart.getAsLong() > blockDescription.getTotalWaitingTime();
    }

    private Environment createBlockchainEnvironment() {
        try {
            Path path = this.config.getDir().resolve("blocks");
            Environment env = new Environment(path.toString());
            LOGGER.info("blockchain: opened the blocks database at " + String.valueOf(path));
            return env;
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private Store openStore(String name) {
        try {
            Store store = (Store)this.environment.computeInTransaction(txn -> this.environment.openStoreWithoutDuplicatesWithPrefixing(name, txn));
            LOGGER.info("blockchain: opened the store of " + name + " inside the blocks database");
            return store;
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private Optional<byte[]> getHeadHash(Transaction txn) {
        try {
            return Optional.ofNullable(this.storeOfBlocks.get(txn, HASH_OF_HEAD)).map(ByteIterable::getBytes);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private Optional<byte[]> getStateIdOfHead(Transaction txn) {
        try {
            return Optional.ofNullable(this.storeOfBlocks.get(txn, STATE_ID_OF_HEAD)).map(ByteIterable::getBytes);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private Optional<byte[]> getStartOfNonFrozenPartHash(Transaction txn) {
        try {
            return Optional.ofNullable(this.storeOfBlocks.get(txn, HASH_OF_START_OF_NON_FROZEN_PART)).map(ByteIterable::getBytes);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private Optional<LocalDateTime> getStartingTimeOfNonFrozenHistory(Transaction txn) {
        Optional<byte[]> maybeStartOfNonFrozenPartHash = this.getStartOfNonFrozenPartHash(txn);
        if (maybeStartOfNonFrozenPartHash.isEmpty()) {
            return Optional.empty();
        }
        Block startOfNonFrozenPart = this.getBlock(txn, maybeStartOfNonFrozenPartHash.get()).orElseThrow(() -> new LocalNodeException("The hash of the start of the non-frozen part of the blockchain is set but its block cannot be found in the database"));
        if (startOfNonFrozenPart instanceof GenesisBlock) {
            GenesisBlock gb = (GenesisBlock)startOfNonFrozenPart;
            return Optional.of(gb.getStartDateTimeUTC());
        }
        return Optional.of(this.getGenesis(txn).orElseThrow(() -> new LocalNodeException("The database is not empty but its genesis block is not set")).getStartDateTimeUTC().plus(startOfNonFrozenPart.getDescription().getTotalWaitingTime(), ChronoUnit.MILLIS));
    }

    private Optional<byte[]> getGenesisHash(Transaction txn) {
        try {
            return Optional.ofNullable(this.storeOfBlocks.get(txn, HASH_OF_GENESIS)).map(ByteIterable::getBytes);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private Optional<BigInteger> getPowerOfHead(Transaction txn) {
        try {
            return Optional.ofNullable(this.storeOfBlocks.get(txn, POWER_OF_HEAD)).map(ByteIterable::getBytes).map(BigInteger::new);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private OptionalLong getHeightOfHead(Transaction txn) {
        try {
            ByteIterable heightBI = this.storeOfBlocks.get(txn, HEIGHT_OF_HEAD);
            if (heightBI == null) {
                return OptionalLong.empty();
            }
            long chainHeight = Blockchain.bytesToLong(heightBI.getBytes());
            if (chainHeight < 0L) {
                throw new LocalNodeException("The database contains a negative chain length");
            }
            return OptionalLong.of(chainHeight);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private OptionalLong getTotalWaitingTimeOfStartOfNonFrozenPart(Transaction txn) {
        try {
            ByteIterable totalWaitingTimeBI = this.storeOfBlocks.get(txn, TOTAL_WAITING_TIME_OF_START_OF_NON_FROZEN_PART);
            if (totalWaitingTimeBI == null) {
                return OptionalLong.empty();
            }
            long totalWaitingTime = Blockchain.bytesToLong(totalWaitingTimeBI.getBytes());
            if (totalWaitingTime < 0L) {
                throw new LocalNodeException("The database contains a negative total waiting time for the start of the non-frozen part of the blockchain");
            }
            return OptionalLong.of(totalWaitingTime);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private Stream<byte[]> getForwards(Transaction txn, byte[] hash) {
        ByteIterable forwards;
        try {
            forwards = this.storeOfForwards.get(txn, ByteIterable.fromBytes((byte[])hash));
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
        if (forwards == null) {
            return Stream.empty();
        }
        int size = this.config.getHashingForBlocks().length();
        byte[] hashes = forwards.getBytes();
        if (hashes.length % size != 0) {
            throw new LocalNodeException("The forward map has been corrupted");
        }
        if (hashes.length == size) {
            return Stream.of(hashes);
        }
        return IntStream.range(0, hashes.length / size).mapToObj(n -> Blockchain.slice(hashes, n, size));
    }

    private static byte[] slice(byte[] all, int n, int size) {
        byte[] result = new byte[size];
        System.arraycopy(all, n * size, result, 0, size);
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Optional<Block> getBlock(Transaction txn, byte[] hash) {
        try {
            ByteIterable blockBI = this.storeOfBlocks.get(txn, ByteIterable.fromBytes((byte[])hash));
            if (blockBI == null) {
                return Optional.empty();
            }
            try (ByteArrayInputStream bais = new ByteArrayInputStream(blockBI.getBytes());){
                Optional<Block> optional;
                block14: {
                    UnmarshallingContext context = UnmarshallingContexts.of((InputStream)bais);
                    try {
                        optional = Optional.of(Blocks.from((UnmarshallingContext)context, (ConsensusConfig)this.config));
                        if (context == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (context != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    context.close();
                }
                return optional;
            }
        }
        catch (ExodusException | IOException e) {
            throw new LocalNodeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Optional<BlockDescription> getBlockDescription(Transaction txn, byte[] hash) {
        try {
            ByteIterable blockBI = this.storeOfBlocks.get(txn, ByteIterable.fromBytes((byte[])hash));
            if (blockBI == null) {
                return Optional.empty();
            }
            try (ByteArrayInputStream bais = new ByteArrayInputStream(blockBI.getBytes());){
                Optional<BlockDescription> optional;
                block14: {
                    UnmarshallingContext context = UnmarshallingContexts.of((InputStream)bais);
                    try {
                        optional = Optional.of(BlockDescriptions.from((UnmarshallingContext)context, (ConsensusConfig)this.config));
                        if (context == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (context != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    context.close();
                }
                return optional;
            }
        }
        catch (ExodusException | IOException e) {
            throw new LocalNodeException(e);
        }
    }

    private Optional<io.mokamint.node.api.Transaction> getTransaction(Transaction txn, byte[] hash) {
        try {
            ByteIterable txBI = this.storeOfTransactions.get(txn, ByteIterable.fromBytes((byte[])hash));
            if (txBI == null) {
                return Optional.empty();
            }
            TransactionRef ref = TransactionRef.from(txBI);
            ByteIterable blockHash = this.storeOfChain.get(txn, ByteIterable.fromBytes((byte[])Blockchain.longToBytes(ref.height)));
            if (blockHash == null) {
                throw new LocalNodeException("The hash of the block of the best chain at height " + ref.height + " is not in the database");
            }
            Block block = this.getBlock(txn, blockHash.getBytes()).orElseThrow(() -> new LocalNodeException("The current best chain misses the block at height " + ref.height + " with hash " + Hex.toHexString((byte[])blockHash.getBytes())));
            if (block instanceof NonGenesisBlock) {
                NonGenesisBlock ngb = (NonGenesisBlock)block;
                try {
                    return Optional.of(ngb.getTransaction(ref.progressive));
                }
                catch (IndexOutOfBoundsException e) {
                    throw new LocalNodeException("Transaction " + Hex.toHexString((byte[])hash) + " has a progressive number outside the bounds for the block where it is contained");
                }
            }
            throw new LocalNodeException("Transaction " + Hex.toHexString((byte[])hash) + " seems contained in a genesis block, which is impossible");
        }
        catch (ExodusException | IOException e) {
            throw new LocalNodeException(e);
        }
    }

    private Optional<TransactionAddress> getTransactionAddress(Transaction txn, byte[] hash) {
        try {
            ByteIterable txBI = this.storeOfTransactions.get(txn, ByteIterable.fromBytes((byte[])hash));
            if (txBI == null) {
                return Optional.empty();
            }
            TransactionRef ref = TransactionRef.from(txBI);
            ByteIterable blockHash = this.storeOfChain.get(txn, ByteIterable.fromBytes((byte[])Blockchain.longToBytes(ref.height)));
            if (blockHash == null) {
                throw new LocalNodeException("The hash of the block of the best chain at height " + ref.height + " is not in the database");
            }
            return Optional.of(TransactionAddresses.of((byte[])blockHash.getBytes(), (int)ref.progressive));
        }
        catch (ExodusException | IOException e) {
            throw new LocalNodeException(e);
        }
    }

    Optional<TransactionAddress> getTransactionAddress(Transaction txn, Block block, byte[] hash) {
        try {
            byte[] hashOfBlock = block.getHash();
            String initialHash = block.getHexHash();
            while (true) {
                if (this.isContainedInTheBestChain(txn, block, hashOfBlock)) {
                    ByteIterable txBI = this.storeOfTransactions.get(txn, ByteIterable.fromBytes((byte[])hash));
                    if (txBI == null) {
                        return Optional.empty();
                    }
                    TransactionRef ref = TransactionRef.from(txBI);
                    if (ref.height > block.getDescription().getHeight()) {
                        return Optional.empty();
                    }
                    ByteIterable blockHash = this.storeOfChain.get(txn, ByteIterable.fromBytes((byte[])Blockchain.longToBytes(ref.height)));
                    if (blockHash == null) {
                        throw new LocalNodeException("The hash of the block of the best chain at height " + ref.height + " is not in the database");
                    }
                    return Optional.of(TransactionAddresses.of((byte[])blockHash.getBytes(), (int)ref.progressive));
                }
                if (!(block instanceof NonGenesisBlock)) break;
                NonGenesisBlock ngb = (NonGenesisBlock)block;
                int length = ngb.getTransactionsCount();
                HashingAlgorithm hashingForTransactions = this.config.getHashingForTransactions();
                for (int pos = 0; pos < length; ++pos) {
                    if (!Arrays.equals(hash, ngb.getTransaction(pos).getHash(hashingForTransactions))) continue;
                    return Optional.of(TransactionAddresses.of((byte[])hashOfBlock, (int)pos));
                }
                byte[] hashOfPrevious = ngb.getHashOfPreviousBlock();
                Optional<Block> maybePreviousBlock = this.getBlock(txn, hashOfPrevious);
                if (maybePreviousBlock.isEmpty()) {
                    return Optional.empty();
                }
                block = maybePreviousBlock.get();
                hashOfBlock = hashOfPrevious;
            }
            throw new LocalNodeException("The block " + initialHash + " is not connected to the best chain");
        }
        catch (ExodusException | IOException e) {
            throw new LocalNodeException(e);
        }
    }

    Optional<LocalDateTime> creationTimeOf(Transaction txn, Block block) {
        if (block instanceof GenesisBlock) {
            GenesisBlock gb = (GenesisBlock)block;
            return Optional.of(gb.getStartDateTimeUTC());
        }
        return this.getGenesis(txn).map(genesis -> genesis.getStartDateTimeUTC().plus(block.getDescription().getTotalWaitingTime(), ChronoUnit.MILLIS));
    }

    private boolean isBetterThanHead(Transaction txn, NonGenesisBlock block) {
        if (this.isEmpty(txn)) {
            return true;
        }
        BigInteger powerOfHead = this.getPowerOfHead(txn).orElseThrow(() -> new LocalNodeException("The database of blocks is non-empty but the power of the head is not set"));
        return block.getDescription().getPower().compareTo(powerOfHead) > 0;
    }

    private boolean isContainedInTheBestChain(Transaction txn, Block block, byte[] blockHash) {
        try {
            long height = block.getDescription().getHeight();
            ByteIterable hashOfBlockFromBestChain = this.storeOfChain.get(txn, ByteIterable.fromBytes((byte[])Blockchain.longToBytes(height)));
            return hashOfBlockFromBestChain != null && Arrays.equals(hashOfBlockFromBestChain.getBytes(), blockHash);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private boolean isEmpty(Transaction txn) {
        return this.getGenesisHash(txn).isEmpty();
    }

    private Optional<Block> getHead(Transaction txn) {
        try {
            Optional<byte[]> maybeHeadHash = this.getHeadHash(txn);
            if (maybeHeadHash.isEmpty()) {
                return Optional.empty();
            }
            Optional<Block> maybeHead = this.getBlock(txn, maybeHeadHash.get());
            if (maybeHead.isPresent()) {
                return maybeHead;
            }
            throw new LocalNodeException("The head hash is set but it is not in the database");
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private Optional<Block> getStartOfNonFrozenPart(Transaction txn) {
        try {
            Optional<byte[]> maybeStartOfNonFrozenPartHash = this.getStartOfNonFrozenPartHash(txn);
            if (maybeStartOfNonFrozenPartHash.isEmpty()) {
                return Optional.empty();
            }
            Optional<Block> maybeStartOfNonFrozenPart = this.getBlock(txn, maybeStartOfNonFrozenPartHash.get());
            if (maybeStartOfNonFrozenPart.isPresent()) {
                return maybeStartOfNonFrozenPart;
            }
            throw new LocalNodeException("The hash of the start of non-frozen part of the blockchain is set but it is not in the database");
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private Optional<GenesisBlock> getGenesis(Transaction txn) {
        try {
            Optional<byte[]> maybeGenesisHash = this.getGenesisHash(txn);
            if (maybeGenesisHash.isEmpty()) {
                return Optional.empty();
            }
            Block genesis = this.getBlock(txn, maybeGenesisHash.get()).orElseThrow(() -> new LocalNodeException("The genesis hash is set but it is not in the database"));
            if (genesis instanceof GenesisBlock) {
                GenesisBlock gb = (GenesisBlock)genesis;
                return Optional.of(gb);
            }
            throw new LocalNodeException("The genesis hash is set but it refers to a non-genesis block in the database");
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private void putBlockInStore(Transaction txn, byte[] hashOfBlock, Block block) {
        try {
            this.storeOfBlocks.put(txn, ByteIterable.fromBytes((byte[])hashOfBlock), ByteIterable.fromBytes((byte[])block.toByteArrayWithoutConfigurationData()));
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private boolean containsBlock(Transaction txn, byte[] hashOfBlock) {
        try {
            return this.storeOfBlocks.get(txn, ByteIterable.fromBytes((byte[])hashOfBlock)) != null;
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private void setGenesisHash(Transaction txn, byte[] newGenesisHash) {
        try {
            this.storeOfBlocks.put(txn, HASH_OF_GENESIS, ByteIterable.fromBytes((byte[])newGenesisHash));
            LOGGER.info("blockchain: height 0: block " + Hex.toHexString((byte[])newGenesisHash) + " set as genesis");
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private void setStartOfNonFrozenPartHash(Transaction txn, byte[] startOfNonFrozenPartHash) {
        try {
            this.storeOfBlocks.put(txn, HASH_OF_START_OF_NON_FROZEN_PART, ByteIterable.fromBytes((byte[])startOfNonFrozenPartHash));
            BlockDescription descriptionOfStartOfNonFrozenPart = this.getBlockDescription(txn, startOfNonFrozenPartHash).orElseThrow(() -> new LocalNodeException("Trying to set the start of the non-frozen part of the blockchain to a block not present in the database"));
            this.storeOfBlocks.put(txn, TOTAL_WAITING_TIME_OF_START_OF_NON_FROZEN_PART, ByteIterable.fromBytes((byte[])Blockchain.longToBytes(descriptionOfStartOfNonFrozenPart.getTotalWaitingTime())));
            LOGGER.fine(() -> "blockchain: block " + Hex.toHexString((byte[])startOfNonFrozenPartHash) + " set as start of non-frozen part, at height " + descriptionOfStartOfNonFrozenPart.getHeight());
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private void gcBlocksRootedAt(Transaction txn, byte[] hash) {
        ArrayList<byte[]> ws = new ArrayList<byte[]>();
        ws.add(hash);
        do {
            byte[] currentHash = (byte[])ws.remove(ws.size() - 1);
            this.getForwards(txn, currentHash).forEach(ws::add);
            ByteIterable currentHashBI = ByteIterable.fromBytes((byte[])currentHash);
            try {
                this.storeOfBlocks.delete(txn, currentHashBI);
                if (this.storeOfForwards.get(txn, currentHashBI) != null) {
                    this.storeOfForwards.delete(txn, currentHashBI);
                }
            }
            catch (ExodusException e) {
                throw new LocalNodeException(e);
            }
            LOGGER.fine(() -> "blockchain: garbage-collected block " + Hex.toHexString((byte[])currentHash));
        } while (!ws.isEmpty());
    }

    private ChainInfo getChainInfo(Transaction txn) {
        Optional<byte[]> maybeGenesisHash = this.getGenesisHash(txn);
        if (maybeGenesisHash.isEmpty()) {
            return ChainInfos.of((long)0L, Optional.empty(), Optional.empty(), Optional.empty());
        }
        Optional<byte[]> maybeHeadHash = this.getHeadHash(txn);
        if (maybeHeadHash.isEmpty()) {
            throw new LocalNodeException("The hash of the genesis is set but there is no head hash set in the database");
        }
        OptionalLong maybeChainHeight = this.getHeightOfHead(txn);
        if (maybeChainHeight.isEmpty()) {
            throw new LocalNodeException("The hash of the genesis is set but the height of the current best chain is missing");
        }
        Optional<byte[]> maybeStateId = this.getStateIdOfHead(txn);
        if (maybeStateId.isEmpty()) {
            throw new LocalNodeException("The hash of the genesis is set but the state identifier for the head is missing");
        }
        return ChainInfos.of((long)(maybeChainHeight.getAsLong() + 1L), maybeGenesisHash, maybeHeadHash, maybeStateId);
    }

    private Stream<byte[]> getChain(Transaction txn, long start, int count) {
        try {
            ByteIterable[] hashes;
            if (start < 0L || count <= 0) {
                return Stream.empty();
            }
            OptionalLong chainHeight = this.getHeightOfHead(txn);
            if (chainHeight.isEmpty()) {
                return Stream.empty();
            }
            for (ByteIterable bi : hashes = (ByteIterable[])LongStream.range(start, Math.min(start + (long)count, chainHeight.getAsLong() + 1L)).mapToObj(height -> this.storeOfChain.get(txn, ByteIterable.fromBytes((byte[])Blockchain.longToBytes(height)))).toArray(ByteIterable[]::new)) {
                if (bi != null) continue;
                throw new LocalNodeException("The current best chain misses an element");
            }
            return Stream.of(hashes).map(ByteIterable::getBytes);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private void addToForwards(Transaction txn, NonGenesisBlock block, byte[] hashOfBlock) {
        try {
            ByteIterable hashOfPrevious = ByteIterable.fromBytes((byte[])block.getHashOfPreviousBlock());
            ByteIterable oldForwards = this.storeOfForwards.get(txn, hashOfPrevious);
            ByteIterable newForwards = ByteIterable.fromBytes((byte[])(oldForwards != null ? Blockchain.concat(oldForwards.getBytes(), hashOfBlock) : hashOfBlock));
            this.storeOfForwards.put(txn, hashOfPrevious, newForwards);
        }
        catch (ExodusException e) {
            throw new LocalNodeException(e);
        }
    }

    private static byte[] longToBytes(long l) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return result;
    }

    private static long bytesToLong(byte[] b) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }

    private static byte[] concat(byte[] array1, byte[] array2) {
        byte[] merge = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, merge, 0, array1.length);
        System.arraycopy(array2, 0, merge, array1.length, array2.length);
        return merge;
    }

    private class Rebase {
        private final Transaction txn;
        private final Mempool mempool;
        private final Block newBase;
        private final Set<Mempool.TransactionEntry> toRemove = new HashSet<Mempool.TransactionEntry>();
        private final Set<Mempool.TransactionEntry> toAdd = new HashSet<Mempool.TransactionEntry>();
        private Block newBlock;
        private Block oldBlock;

        private Rebase(Transaction txn, Mempool mempool, Block newBase) throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
            this.txn = txn;
            this.mempool = mempool;
            this.newBase = newBase;
            this.newBlock = newBase;
            this.oldBlock = mempool.getBase().orElse(null);
            if (this.oldBlock == null) {
                this.markToRemoveAllTransactionsFromNewBaseToGenesis();
            } else {
                while (this.newBlock.getDescription().getHeight() > this.oldBlock.getDescription().getHeight()) {
                    this.markToRemoveAllTransactionsInNewBlockAndMoveItBackwards();
                }
                while (this.newBlock.getDescription().getHeight() < this.oldBlock.getDescription().getHeight()) {
                    this.markToAddAllTransactionsInOldBlockAndMoveItBackwards();
                }
                while (!this.reachedSharedAncestor()) {
                    this.markToRemoveAllTransactionsInNewBlockAndMoveItBackwards();
                    this.markToAddAllTransactionsInOldBlockAndMoveItBackwards();
                }
            }
        }

        private void updateMempool() {
            this.mempool.update(this.newBase, this.toAdd.stream(), this.toRemove.stream());
        }

        private boolean reachedSharedAncestor() {
            if (this.newBlock.equals((Object)this.oldBlock)) {
                return true;
            }
            if (this.newBlock instanceof GenesisBlock || this.oldBlock instanceof GenesisBlock) {
                throw new LocalNodeException("Cannot identify a shared ancestor block between " + this.oldBlock.getHexHash() + " and " + this.newBlock.getHexHash());
            }
            return false;
        }

        private void markToRemoveAllTransactionsInNewBlockAndMoveItBackwards() throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
            Block block = this.newBlock;
            if (!(block instanceof NonGenesisBlock)) {
                throw new LocalNodeException("The database contains a genesis block " + this.newBlock.getHexHash() + " at height " + this.newBlock.getDescription().getHeight());
            }
            NonGenesisBlock ngb = (NonGenesisBlock)block;
            this.markAllTransactionsAsToRemove(ngb);
            this.newBlock = this.getBlock(ngb.getHashOfPreviousBlock());
        }

        private void markToAddAllTransactionsInOldBlockAndMoveItBackwards() throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
            Block block = this.oldBlock;
            if (!(block instanceof NonGenesisBlock)) {
                throw new LocalNodeException("The database contains a genesis block " + this.oldBlock.getHexHash() + " at height " + this.oldBlock.getDescription().getHeight());
            }
            NonGenesisBlock ngb = (NonGenesisBlock)block;
            this.markAllTransactionsAsToAdd(ngb);
            this.oldBlock = this.getBlock(ngb.getHashOfPreviousBlock());
        }

        private void markToRemoveAllTransactionsFromNewBaseToGenesis() throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
            Block block;
            while ((block = this.newBlock) instanceof NonGenesisBlock) {
                NonGenesisBlock ngb = (NonGenesisBlock)block;
                this.markAllTransactionsAsToRemove(ngb);
                this.newBlock = this.getBlock(ngb.getHashOfPreviousBlock());
            }
        }

        private void markAllTransactionsAsToAdd(NonGenesisBlock block) throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
            for (int pos = 0; pos < block.getTransactionsCount(); ++pos) {
                this.toAdd.add(this.intoTransactionEntry(block.getTransaction(pos)));
            }
        }

        private void markAllTransactionsAsToRemove(NonGenesisBlock block) throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
            for (io.mokamint.node.api.Transaction transaction : (io.mokamint.node.api.Transaction[])block.getTransactions().toArray(io.mokamint.node.api.Transaction[]::new)) {
                this.toRemove.add(this.intoTransactionEntry(transaction));
            }
        }

        private Mempool.TransactionEntry intoTransactionEntry(io.mokamint.node.api.Transaction transaction) throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
            try {
                return this.mempool.mkTransactionEntry(transaction);
            }
            catch (TransactionRejectedException e) {
                throw new MisbehavingApplicationException(e);
            }
        }

        private Block getBlock(byte[] hash) {
            return Blockchain.this.getBlock(this.txn, hash).orElseThrow(() -> new LocalNodeException("Missing block with hash " + Hex.toHexString((byte[])hash)));
        }
    }

    private class BlockAdder {
        private final Transaction txn;
        private final List<Block> blocksAdded = new ArrayList<Block>();
        private final Deque<Block> blocksAddedToTheCurrentBestChain = new LinkedList<Block>();
        private final Set<NonGenesisBlock> blocksToAddAmongOrphans = new HashSet<NonGenesisBlock>();
        private final Set<NonGenesisBlock> blocksToRemoveFromOrphans = new HashSet<NonGenesisBlock>();
        private boolean connected;

        private BlockAdder(Transaction txn) {
            this.txn = txn;
        }

        private BlockAdder add(Block block, Optional<BlockVerification.Mode> verification) throws VerificationException, InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
            byte[] hashOfBlockToAdd = block.getHash();
            if (Blockchain.this.containsBlock(this.txn, hashOfBlockToAdd)) {
                this.connected = true;
                LOGGER.fine(() -> "blockchain: not adding block " + block.getHexHash() + " since it is already in blockchain");
            } else {
                Optional<byte[]> initialHeadHash = Blockchain.this.getHeadHash(this.txn);
                this.addBlockAndConnectOrphans(block, verification);
                this.computeBlocksAddedToTheCurrentBestChain(initialHeadHash);
                this.connected |= this.somethingHasBeenAdded();
            }
            return this;
        }

        private void informNode() {
            this.blocksToAddAmongOrphans.forEach(arg_0 -> Blockchain.this.orphans.add(arg_0));
            this.blocksToRemoveFromOrphans.forEach(arg_0 -> Blockchain.this.orphans.remove(arg_0));
            this.blocksAdded.forEach(Blockchain.this.node::onAdded);
            if (!this.blocksAddedToTheCurrentBestChain.isEmpty()) {
                Blockchain.this.node.onHeadChanged(this.blocksAddedToTheCurrentBestChain);
            }
        }

        private void updateMempool() throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
            if (!this.blocksAddedToTheCurrentBestChain.isEmpty()) {
                Blockchain.this.node.rebaseMempoolAt(this.blocksAddedToTheCurrentBestChain.getLast());
            }
        }

        private boolean somethingHasBeenAdded() {
            return !this.blocksAdded.isEmpty();
        }

        private boolean addedBlockHasBeenConnected() {
            return this.connected;
        }

        private void addBlockAndConnectOrphans(Block blockToAdd, Optional<BlockVerification.Mode> verification) throws VerificationException, InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
            ArrayList<Block> ws = new ArrayList<Block>();
            ws.add(blockToAdd);
            do {
                Block cursor = (Block)ws.remove(ws.size() - 1);
                Optional<Block> previous = Optional.empty();
                if (cursor instanceof GenesisBlock || (previous = Blockchain.this.getBlock(this.txn, ((NonGenesisBlock)cursor).getHashOfPreviousBlock())).isPresent()) {
                    byte[] hashOfCursor = cursor.getHash();
                    if (!this.add(cursor, hashOfCursor, previous, blockToAdd != cursor, verification)) continue;
                    this.blocksAdded.add(cursor);
                    this.forEachOrphanWithParent(hashOfCursor, ws::add);
                    if (blockToAdd == cursor) continue;
                    this.blocksToRemoveFromOrphans.add((NonGenesisBlock)cursor);
                    continue;
                }
                if (!(cursor instanceof NonGenesisBlock)) continue;
                NonGenesisBlock ngb = (NonGenesisBlock)cursor;
                this.blocksToAddAmongOrphans.add(ngb);
                LOGGER.fine(() -> "blockchain: added block " + cursor.getHexHash() + " to the orphans");
            } while (!ws.isEmpty());
        }

        private void computeBlocksAddedToTheCurrentBestChain(Optional<byte[]> initialHeadHash) {
            ByteIterable hashOfBlockFromBestChain;
            Block start;
            if (this.blocksAdded.isEmpty()) {
                return;
            }
            if (initialHeadHash.isEmpty()) {
                start = (Block)Blockchain.this.getGenesis(this.txn).orElseThrow(() -> new LocalNodeException("The blockchain has been expanded but it still misses a genesis block"));
            } else {
                byte[] hashOfCursor = initialHeadHash.get();
                Block cursor = Blockchain.this.getBlock(this.txn, hashOfCursor).orElseThrow(() -> new LocalNodeException("Cannot find the original head of the blockchain"));
                while (!Blockchain.this.isContainedInTheBestChain(this.txn, cursor, hashOfCursor)) {
                    if (cursor instanceof NonGenesisBlock) {
                        NonGenesisBlock ngb = (NonGenesisBlock)cursor;
                        hashOfCursor = ngb.getHashOfPreviousBlock();
                        cursor = Blockchain.this.getBlock(this.txn, hashOfCursor).orElseThrow(() -> new LocalNodeException("Cannot follow the path to the original head of the blockchain, backwards"));
                        continue;
                    }
                    throw new LocalNodeException("The original head is in a dangling path");
                }
                start = cursor;
            }
            long height = start.getDescription().getHeight();
            do {
                if ((hashOfBlockFromBestChain = Blockchain.this.storeOfChain.get(this.txn, ByteIterable.fromBytes((byte[])Blockchain.longToBytes(++height)))) == null) continue;
                this.blocksAddedToTheCurrentBestChain.addLast(Blockchain.this.getBlock(this.txn, hashOfBlockFromBestChain.getBytes()).orElseThrow(() -> new LocalNodeException("Cannot follow the new best chain upwards")));
            } while (hashOfBlockFromBestChain != null);
        }

        private boolean add(Block blockToAdd, byte[] hashOfBlockToAdd, Optional<Block> previous, boolean isOrphan, Optional<BlockVerification.Mode> verification) throws VerificationException, InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
            if (verification.isPresent() || isOrphan) {
                try {
                    new BlockVerification(this.txn, Blockchain.this.node, Blockchain.this.config, blockToAdd, previous, isOrphan ? BlockVerification.Mode.COMPLETE : verification.get());
                    LOGGER.fine(() -> "blockchain: verified block " + blockToAdd.getHexHash() + " [" + String.valueOf((Object)(isOrphan ? BlockVerification.Mode.COMPLETE : (BlockVerification.Mode)((Object)((Object)verification.get())))) + "]");
                }
                catch (VerificationException e) {
                    LOGGER.warning("blockchain: failed verification of block " + blockToAdd.getHexHash());
                    if (isOrphan) {
                        LOGGER.warning("blockchain: discarding orphan block " + blockToAdd.getHexHash() + " since it does not pass verification: " + e.getMessage());
                        this.blocksToRemoveFromOrphans.add((NonGenesisBlock)blockToAdd);
                        return false;
                    }
                    throw e;
                }
            }
            return this.add(blockToAdd, hashOfBlockToAdd, previous);
        }

        private boolean add(Block block, byte[] hashOfBlock, Optional<Block> previous) {
            if (block instanceof NonGenesisBlock) {
                NonGenesisBlock ngb = (NonGenesisBlock)block;
                if (Blockchain.this.isInFrozenPart(this.txn, previous.get().getDescription())) {
                    LOGGER.warning("blockchain: not adding block " + block.getHexHash() + " since its previous block is in the frozen part of the blockchain");
                    return false;
                }
                if (Blockchain.this.containsBlock(this.txn, hashOfBlock)) {
                    LOGGER.fine(() -> "blockchain: not adding block " + block.getHexHash() + " since it is already in blockchain");
                    return false;
                }
                Blockchain.this.putBlockInStore(this.txn, hashOfBlock, block);
                Blockchain.this.addToForwards(this.txn, ngb, hashOfBlock);
                if (Blockchain.this.isBetterThanHead(this.txn, ngb)) {
                    this.setHead(block, hashOfBlock);
                }
                LOGGER.fine(() -> "blockchain: height " + block.getDescription().getHeight() + ": added block " + block.getHexHash());
                return true;
            }
            if (Blockchain.this.isEmpty(this.txn)) {
                Blockchain.this.putBlockInStore(this.txn, hashOfBlock, block);
                Blockchain.this.setGenesisHash(this.txn, hashOfBlock);
                this.setHead(block, hashOfBlock);
                LOGGER.fine(() -> "blockchain: height " + block.getDescription().getHeight() + ": added block " + block.getHexHash());
                return true;
            }
            LOGGER.warning("blockchain: not adding genesis block " + block.getHexHash() + " since the database already contains a genesis block");
            return false;
        }

        private void setHead(Block newHead, byte[] newHeadHash) {
            try {
                this.updateChain(newHead, newHeadHash);
                Blockchain.this.storeOfBlocks.put(this.txn, HASH_OF_HEAD, ByteIterable.fromBytes((byte[])newHeadHash));
                Blockchain.this.storeOfBlocks.put(this.txn, STATE_ID_OF_HEAD, ByteIterable.fromBytes((byte[])newHead.getStateId()));
                Blockchain.this.storeOfBlocks.put(this.txn, POWER_OF_HEAD, ByteIterable.fromBytes((byte[])newHead.getDescription().getPower().toByteArray()));
                long heightOfHead = newHead.getDescription().getHeight();
                Blockchain.this.storeOfBlocks.put(this.txn, HEIGHT_OF_HEAD, ByteIterable.fromBytes((byte[])Blockchain.longToBytes(heightOfHead)));
                LOGGER.info(() -> "blockchain: height " + heightOfHead + ": block " + newHead.getHexHash() + " set as head");
            }
            catch (ExodusException e) {
                throw new LocalNodeException(e);
            }
        }

        private void updateChain(Block newHead, byte[] newHeadHash) {
            try {
                byte[] startOfNonFrozenPartHash;
                Block cursor = newHead;
                byte[] cursorHash = newHeadHash;
                long totalTimeOfNewHead = newHead.getDescription().getTotalWaitingTime();
                long height = newHead.getDescription().getHeight();
                this.removeDataHigherThan(this.txn, height);
                ByteIterable heightBI = ByteIterable.fromBytes((byte[])Blockchain.longToBytes(height));
                ByteIterable _new = ByteIterable.fromBytes((byte[])newHeadHash);
                ByteIterable old = Blockchain.this.storeOfChain.get(this.txn, heightBI);
                LinkedList<Block> blocksAddedToTheCurrentBestChain = new LinkedList<Block>();
                do {
                    Blockchain.this.storeOfChain.put(this.txn, heightBI, _new);
                    if (old != null) {
                        long heightCopy = height;
                        byte[] oldBytes = old.getBytes();
                        Block oldBlock = Blockchain.this.getBlock(this.txn, oldBytes).orElseThrow(() -> new LocalNodeException("The current best chain misses the block at height " + heightCopy + " with hash " + Hex.toHexString((byte[])oldBytes)));
                        this.removeReferencesToTransactionsInside(this.txn, oldBlock);
                    }
                    blocksAddedToTheCurrentBestChain.addFirst(cursor);
                    if (cursor instanceof NonGenesisBlock) {
                        NonGenesisBlock ngb = (NonGenesisBlock)cursor;
                        if (height <= 0L) {
                            throw new LocalNodeException("The current best chain contains the non-genesis block " + Hex.toHexString((byte[])cursorHash) + " at height " + height);
                        }
                        byte[] hashOfPrevious = ngb.getHashOfPreviousBlock();
                        byte[] cursorHashCopy = cursorHash;
                        cursor = Blockchain.this.getBlock(this.txn, hashOfPrevious).orElseThrow(() -> new LocalNodeException("Block " + Hex.toHexString((byte[])cursorHashCopy) + " has no previous block in the database"));
                        cursorHash = hashOfPrevious;
                        heightBI = ByteIterable.fromBytes((byte[])Blockchain.longToBytes(--height));
                        _new = ByteIterable.fromBytes((byte[])cursorHash);
                        old = Blockchain.this.storeOfChain.get(this.txn, heightBI);
                        continue;
                    }
                    if (height <= 0L) continue;
                    throw new LocalNodeException("The current best chain contains a genesis block " + Hex.toHexString((byte[])cursorHash) + " at height " + height);
                } while (cursor instanceof NonGenesisBlock && !_new.equals((Object)old));
                for (Block added : blocksAddedToTheCurrentBestChain) {
                    this.addReferencesToTransactionsInside(added);
                }
                Optional<byte[]> maybeStartOfNonFrozenPartHash = Blockchain.this.getStartOfNonFrozenPartHash(this.txn);
                if (maybeStartOfNonFrozenPartHash.isEmpty()) {
                    startOfNonFrozenPartHash = Blockchain.this.getGenesisHash(this.txn).orElseThrow(() -> new LocalNodeException("The head has changed but the genesis hash is missing"));
                    Blockchain.this.setStartOfNonFrozenPartHash(this.txn, startOfNonFrozenPartHash);
                } else {
                    startOfNonFrozenPartHash = maybeStartOfNonFrozenPartHash.get();
                }
                if (Blockchain.this.maximalHistoryChangeTime >= 0L) {
                    while (true) {
                        byte[] startOfNonFrozenPartHashCopy = startOfNonFrozenPartHash;
                        BlockDescription descriptionOfStartOfNonFrozenPart = Blockchain.this.getBlockDescription(this.txn, startOfNonFrozenPartHash).orElseThrow(() -> new LocalNodeException("Block " + Hex.toHexString((byte[])startOfNonFrozenPartHashCopy) + " should be the start of the non-frozen part of the blockchain, but it cannot be found in the database"));
                        if (totalTimeOfNewHead - descriptionOfStartOfNonFrozenPart.getTotalWaitingTime() > Blockchain.this.maximalHistoryChangeTime) {
                            ByteIterable aboveStartOfNonFrozenPartHash = Blockchain.this.storeOfChain.get(this.txn, ByteIterable.fromBytes((byte[])Blockchain.longToBytes(descriptionOfStartOfNonFrozenPart.getHeight() + 1L)));
                            if (aboveStartOfNonFrozenPartHash == null) {
                                throw new LocalNodeException("The block above the start of the non-frozen part of the blockchain is not in the database");
                            }
                            byte[] newStartOfNonFrozenPartHash = aboveStartOfNonFrozenPartHash.getBytes();
                            for (byte[] forward : (byte[][])Blockchain.this.getForwards(this.txn, startOfNonFrozenPartHash).toArray(x$0 -> new byte[x$0][])) {
                                if (Arrays.equals(forward, newStartOfNonFrozenPartHash)) continue;
                                Blockchain.this.gcBlocksRootedAt(this.txn, forward);
                            }
                            Blockchain.this.setStartOfNonFrozenPartHash(this.txn, newStartOfNonFrozenPartHash);
                            startOfNonFrozenPartHash = newStartOfNonFrozenPartHash;
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (ExodusException e) {
                throw new LocalNodeException(e);
            }
        }

        private void addReferencesToTransactionsInside(Block block) {
            if (block instanceof NonGenesisBlock) {
                NonGenesisBlock ngb = (NonGenesisBlock)block;
                long height = ngb.getDescription().getHeight();
                HashingAlgorithm hashingForTransactions = Blockchain.this.config.getHashingForTransactions();
                int count = ngb.getTransactionsCount();
                for (int pos = 0; pos < count; ++pos) {
                    TransactionRef ref = new TransactionRef(height, pos);
                    try {
                        Blockchain.this.storeOfTransactions.put(this.txn, ByteIterable.fromBytes((byte[])ngb.getTransaction(pos).getHash(hashingForTransactions)), ByteIterable.fromBytes((byte[])ref.toByteArray()));
                        continue;
                    }
                    catch (ExodusException e) {
                        throw new LocalNodeException(e);
                    }
                }
            }
        }

        private void forEachOrphanWithParent(byte[] hashOfParent, Consumer<NonGenesisBlock> action) {
            Stream.concat(Blockchain.this.orphans.stream(), this.blocksToAddAmongOrphans.stream()).filter(Objects::nonNull).filter(orphan -> Arrays.equals(orphan.getHashOfPreviousBlock(), hashOfParent)).filter(orphan -> !this.blocksToRemoveFromOrphans.contains(orphan)).forEach(action);
        }

        private void removeDataHigherThan(Transaction txn, long height) {
            Optional<Block> cursor = Blockchain.this.getHead(txn);
            if (cursor.isPresent()) {
                long blockHeight;
                Block block = cursor.get();
                while ((blockHeight = block.getDescription().getHeight()) > height) {
                    if (block instanceof NonGenesisBlock) {
                        NonGenesisBlock ngb = (NonGenesisBlock)block;
                        this.removeReferencesToTransactionsInside(txn, block);
                        try {
                            Blockchain.this.storeOfChain.delete(txn, ByteIterable.fromBytes((byte[])Blockchain.longToBytes(blockHeight)));
                        }
                        catch (ExodusException e) {
                            throw new LocalNodeException(e);
                        }
                        byte[] hashOfPrevious = ngb.getHashOfPreviousBlock();
                        Block blockCopy = block;
                        block = Blockchain.this.getBlock(txn, hashOfPrevious).orElseThrow(() -> new LocalNodeException("Block " + blockCopy.getHexHash() + " has no previous block in the database"));
                        continue;
                    }
                    throw new LocalNodeException("The current best chain contains a genesis block " + block.getHexHash() + " at height " + blockHeight);
                }
            }
        }

        private void removeReferencesToTransactionsInside(Transaction txn, Block block) {
            if (block instanceof NonGenesisBlock) {
                NonGenesisBlock ngb = (NonGenesisBlock)block;
                int count = ngb.getTransactionsCount();
                HashingAlgorithm hashingForTransactions = Blockchain.this.config.getHashingForTransactions();
                for (int pos = 0; pos < count; ++pos) {
                    try {
                        Blockchain.this.storeOfTransactions.delete(txn, ByteIterable.fromBytes((byte[])ngb.getTransaction(pos).getHash(hashingForTransactions)));
                        continue;
                    }
                    catch (ExodusException e) {
                        throw new LocalNodeException(e);
                    }
                }
            }
        }
    }

    private static class TransactionRef
    extends AbstractMarshallable {
        private final long height;
        private final int progressive;

        private TransactionRef(long height, int progressive) {
            this.height = height;
            this.progressive = progressive;
        }

        public void into(MarshallingContext context) throws IOException {
            context.writeCompactLong(this.height);
            context.writeCompactInt(this.progressive);
        }

        private static TransactionRef from(ByteIterable bi) throws IOException {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bi.getBytes());){
                TransactionRef transactionRef;
                block11: {
                    UnmarshallingContext context = UnmarshallingContexts.of((InputStream)bais);
                    try {
                        transactionRef = new TransactionRef(context.readCompactLong(), context.readCompactInt());
                        if (context == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (context != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    context.close();
                }
                return transactionRef;
            }
        }

        public String toString() {
            return "[" + this.height + ", " + this.progressive + "]";
        }
    }
}

