/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.hotmoka.marshalling.api.Marshallable;
import io.mokamint.application.api.Application;
import io.mokamint.application.api.ClosedApplicationException;
import io.mokamint.application.api.UnknownGroupIdException;
import io.mokamint.application.api.UnknownStateException;
import io.mokamint.node.api.ApplicationTimeoutException;
import io.mokamint.node.api.Block;
import io.mokamint.node.api.GenesisBlock;
import io.mokamint.node.api.GenesisBlockDescription;
import io.mokamint.node.api.NonGenesisBlock;
import io.mokamint.node.api.NonGenesisBlockDescription;
import io.mokamint.node.api.Transaction;
import io.mokamint.node.api.TransactionRejectedException;
import io.mokamint.node.local.LocalNodeException;
import io.mokamint.node.local.api.LocalNodeConfig;
import io.mokamint.node.local.internal.LocalNodeImpl;
import io.mokamint.node.local.internal.MisbehavingApplicationException;
import io.mokamint.node.local.internal.VerificationException;
import io.mokamint.nonce.api.Challenge;
import io.mokamint.nonce.api.ChallengeMatchException;
import io.mokamint.nonce.api.Deadline;
import io.mokamint.nonce.api.Prolog;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.TimeoutException;

public class BlockVerification {
    private final LocalNodeImpl node;
    private final io.hotmoka.xodus.env.Transaction txn;
    private final LocalNodeConfig config;
    private final Block block;
    private final Block previous;
    private final Deadline deadline;
    private final Mode mode;

    BlockVerification(io.hotmoka.xodus.env.Transaction txn, LocalNodeImpl node, LocalNodeConfig config, Block block, Optional<Block> previous, Mode mode) throws VerificationException, InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
        NonGenesisBlock ngb;
        this.txn = txn;
        this.node = node;
        this.mode = mode;
        this.config = config;
        this.block = block;
        this.previous = previous.orElse(null);
        if (block instanceof NonGenesisBlock) {
            ngb = (NonGenesisBlock)block;
            v0 = ngb.getDescription().getDeadline();
        } else {
            v0 = this.deadline = null;
        }
        if (block instanceof NonGenesisBlock) {
            ngb = (NonGenesisBlock)block;
            this.verifyAsNonGenesis(ngb);
        } else {
            this.verifyAsGenesis((GenesisBlock)block);
        }
    }

    private void verifyAsGenesis(GenesisBlock block) throws VerificationException, InterruptedException, ApplicationTimeoutException, ClosedApplicationException {
        this.creationTimeIsNotTooMuchInTheFuture();
        this.blockMatchesItsExpectedDescription(block);
        this.hasValidSignature();
        this.finalStateIsTheInitialStateOfTheApplication();
    }

    private void verifyAsNonGenesis(NonGenesisBlock block) throws VerificationException, InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
        this.creationTimeIsNotTooMuchInTheFuture();
        this.hasValidSignature();
        this.deadlineMatchesItsExpectedChallenge();
        this.deadlineHasValidProlog();
        this.deadlineHasValidSignature();
        this.deadlineIsValid();
        this.blockMatchesItsExpectedDescription(block);
        this.transactionsSizeIsNotTooBig(block);
        this.transactionsAreNotAlreadyInBlockchain(block);
        this.transactionsExecutionLeadsToFinalState(block);
    }

    private void deadlineIsValid() throws VerificationException {
        if (!(this.mode != Mode.COMPLETE && this.mode != Mode.ABSOLUTE || this.deadline.isValid())) {
            throw new VerificationException("Invalid deadline");
        }
    }

    private void deadlineHasValidSignature() throws VerificationException {
        if (this.mode == Mode.COMPLETE || this.mode == Mode.ABSOLUTE) {
            try {
                if (!this.deadline.signatureIsValid()) {
                    throw new VerificationException("Invalid deadline's signature");
                }
            }
            catch (InvalidKeyException e) {
                throw new VerificationException("Invalid key in the prolog of the deadline");
            }
            catch (SignatureException e) {
                throw new VerificationException("The signature of the deadline could not be verified");
            }
        }
    }

    private void hasValidSignature() throws VerificationException {
        if (this.mode == Mode.COMPLETE || this.mode == Mode.ABSOLUTE) {
            try {
                if (!this.block.signatureIsValid()) {
                    throw new VerificationException("Invalid block signature");
                }
            }
            catch (InvalidKeyException e) {
                throw new VerificationException("Invalid key in the description of the block");
            }
            catch (SignatureException e) {
                throw new VerificationException("The signature of the block could not be verified");
            }
        }
    }

    private void deadlineHasValidProlog() throws VerificationException, InterruptedException, ApplicationTimeoutException, ClosedApplicationException {
        if (this.mode == Mode.COMPLETE || this.mode == Mode.ABSOLUTE) {
            Prolog prolog = this.deadline.getProlog();
            if (!prolog.getChainId().equals(this.config.getChainId())) {
                throw new VerificationException("Deadline prolog's chainId mismatch");
            }
            if (!prolog.getSignatureForBlocks().equals((Object)this.config.getSignatureForBlocks())) {
                throw new VerificationException("Deadline prolog's signature algorithm for blocks mismatch");
            }
            if (!prolog.getSignatureForDeadlines().equals((Object)this.config.getSignatureForDeadlines())) {
                throw new VerificationException("Deadline prolog's signature algorithm for deadlines mismatch");
            }
            try {
                if (!this.node.getApplication().checkPrologExtra(prolog.getExtra())) {
                    throw new VerificationException("Invalid deadline prolog's extra");
                }
            }
            catch (TimeoutException e) {
                throw new ApplicationTimeoutException(e);
            }
        }
    }

    private void deadlineMatchesItsExpectedChallenge() throws VerificationException {
        if (this.mode == Mode.COMPLETE || this.mode == Mode.RELATIVE) {
            Challenge challenge = this.previous.getDescription().getNextChallenge();
            try {
                this.deadline.getChallenge().requireMatches(challenge);
            }
            catch (ChallengeMatchException e) {
                throw new VerificationException("Deadline mismatch: " + BlockVerification.toLowerInitial(e.getMessage()));
            }
        }
    }

    private static String toLowerInitial(String message) {
        if (message.isEmpty()) {
            return message;
        }
        return Character.toLowerCase(message.charAt(0)) + message.substring(1);
    }

    private void blockMatchesItsExpectedDescription(GenesisBlock block) throws VerificationException {
        HashingAlgorithm expectedHashingForGenerations;
        HashingAlgorithm expectedHashingForDeadlines;
        SignatureAlgorithm expectedSignatureForBlocks;
        int expectedOblivion;
        int expectedTargetBlockCreationTime;
        GenesisBlockDescription description = block.getDescription();
        int targetBlockCreationTime = description.getTargetBlockCreationTime();
        if (targetBlockCreationTime != (expectedTargetBlockCreationTime = this.config.getTargetBlockCreationTime())) {
            throw new VerificationException("Target block creation time mismatch (expected " + expectedTargetBlockCreationTime + " but found " + targetBlockCreationTime + ")");
        }
        int oblivion = description.getOblivion();
        if (oblivion != (expectedOblivion = this.config.getOblivion())) {
            throw new VerificationException("Oblivion mismatch (expected " + expectedOblivion + " but found " + oblivion + ")");
        }
        SignatureAlgorithm signatureForBlocks = description.getSignatureForBlocks();
        if (!signatureForBlocks.equals((Object)(expectedSignatureForBlocks = this.config.getSignatureForBlocks()))) {
            throw new VerificationException("Block signature algorithm mismatch (expected " + String.valueOf(expectedSignatureForBlocks) + " but found " + String.valueOf(signatureForBlocks) + ")");
        }
        HashingAlgorithm hashingForDeadlines = description.getHashingForDeadlines();
        if (!hashingForDeadlines.equals((Object)(expectedHashingForDeadlines = this.config.getHashingForDeadlines()))) {
            throw new VerificationException("Deadline hashing algorithm mismatch (expected " + String.valueOf(expectedHashingForDeadlines) + " but found " + String.valueOf(hashingForDeadlines) + ")");
        }
        HashingAlgorithm hashingForGenerations = description.getHashingForGenerations();
        if (!hashingForGenerations.equals((Object)(expectedHashingForGenerations = this.config.getHashingForGenerations()))) {
            throw new VerificationException("Generation hashing algorithm mismatch (expected " + String.valueOf(expectedHashingForGenerations) + " but found " + String.valueOf(hashingForGenerations) + ")");
        }
    }

    private void blockMatchesItsExpectedDescription(NonGenesisBlock block) throws VerificationException {
        if (this.mode == Mode.COMPLETE || this.mode == Mode.RELATIVE) {
            byte[] expectedHashOfPreviousBlock;
            long expectedTotalWaitingTime;
            BigInteger expectedPower;
            BigInteger expectedAcceleration;
            long expectedHeight;
            NonGenesisBlockDescription expectedDescription = this.previous.getNextBlockDescription(this.deadline);
            NonGenesisBlockDescription description = block.getDescription();
            long height = description.getHeight();
            if (height != (expectedHeight = expectedDescription.getHeight())) {
                throw new VerificationException("Height mismatch (expected " + expectedHeight + " but found " + height + ")");
            }
            BigInteger acceleration = description.getAcceleration();
            if (!acceleration.equals(expectedAcceleration = expectedDescription.getAcceleration())) {
                throw new VerificationException("Acceleration mismatch (expected " + String.valueOf(expectedAcceleration) + " but found " + String.valueOf(acceleration) + ")");
            }
            BigInteger power = description.getPower();
            if (!power.equals(expectedPower = expectedDescription.getPower())) {
                throw new VerificationException("Power mismatch (expected " + String.valueOf(expectedPower) + " but found " + String.valueOf(power) + ")");
            }
            long totalWaitingTime = description.getTotalWaitingTime();
            if (totalWaitingTime != (expectedTotalWaitingTime = expectedDescription.getTotalWaitingTime())) {
                throw new VerificationException("Total waiting time mismatch (expected " + expectedTotalWaitingTime + " but found " + totalWaitingTime + ")");
            }
            long weightedWaitingTime = description.getWeightedWaitingTime();
            if (weightedWaitingTime != expectedDescription.getWeightedWaitingTime()) {
                throw new VerificationException("Weighted waiting time mismatch (expected " + expectedDescription.getWeightedWaitingTime() + " but found " + weightedWaitingTime + ")");
            }
            byte[] hashOfPreviousBlock = description.getHashOfPreviousBlock();
            if (!Arrays.equals(hashOfPreviousBlock, expectedHashOfPreviousBlock = expectedDescription.getHashOfPreviousBlock())) {
                throw new VerificationException("Hash of previous block mismatch");
            }
        }
    }

    private void creationTimeIsNotTooMuchInTheFuture() throws VerificationException {
        long max;
        LocalDateTime now;
        long howMuchInTheFuture;
        if ((this.mode == Mode.COMPLETE || this.mode == Mode.RELATIVE) && (howMuchInTheFuture = ChronoUnit.MILLIS.between(now = this.node.getPeers().asNetworkDateTime(LocalDateTime.now(ZoneId.of("UTC"))), this.node.getBlockchain().creationTimeOf(this.txn, this.block).orElseThrow(() -> new NoSuchElementException("Cannot determine the creation time of the block under verification")))) > (max = this.config.getBlockMaxTimeInTheFuture())) {
            throw new VerificationException("Too much in the future (" + howMuchInTheFuture + " ms against an allowed maximum of " + max + " ms)");
        }
    }

    private void transactionsSizeIsNotTooBig(NonGenesisBlock block) throws VerificationException {
        if ((this.mode == Mode.COMPLETE || this.mode == Mode.ABSOLUTE) && block.getTransactions().mapToLong(Marshallable::size).sum() > (long)this.config.getMaxBlockSize()) {
            throw new VerificationException("The table of transactions is too big (maximum is " + this.config.getMaxBlockSize() + " bytes)");
        }
    }

    private void transactionsAreNotAlreadyInBlockchain(NonGenesisBlock block) throws VerificationException {
        if (this.mode == Mode.COMPLETE || this.mode == Mode.RELATIVE) {
            for (Transaction tx : (Transaction[])block.getTransactions().toArray(Transaction[]::new)) {
                byte[] txHash = tx.getHash(this.config.getHashingForTransactions());
                if (!this.node.getBlockchain().getTransactionAddress(this.txn, this.previous, txHash).isPresent()) continue;
                throw new VerificationException("Repeated transaction " + tx.getHexHash(this.config.getHashingForTransactions()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transactionsExecutionLeadsToFinalState(NonGenesisBlock block) throws VerificationException, InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
        if (this.mode == Mode.COMPLETE || this.mode == Mode.RELATIVE) {
            Application app = this.node.getApplication();
            LocalDateTime creationTimeOfPrevious = this.node.getBlockchain().creationTimeOf(this.txn, this.previous).orElseThrow(() -> new LocalNodeException("The previous of the block under verification was expected to be in blockchain"));
            try {
                int id;
                try {
                    id = app.beginBlock(block.getDescription().getHeight(), creationTimeOfPrevious, this.previous.getStateId());
                }
                catch (UnknownStateException e) {
                    throw new VerificationException("The initial state is unknown to the application: " + e.getMessage());
                }
                boolean success = false;
                try {
                    for (Transaction tx : (Transaction[])block.getTransactions().toArray(Transaction[]::new)) {
                        try {
                            app.checkTransaction(tx);
                        }
                        catch (TransactionRejectedException e) {
                            throw new VerificationException("Failed check of transaction " + tx.getHexHash(this.config.getHashingForTransactions()) + ": " + e.getMessage());
                        }
                        try {
                            app.deliverTransaction(id, tx);
                        }
                        catch (TransactionRejectedException e) {
                            throw new VerificationException("Failed delivery of transaction " + tx.getHexHash(this.config.getHashingForTransactions()) + ": " + e.getMessage());
                        }
                    }
                    byte[] finalStateId = app.endBlock(id, block.getDescription().getDeadline());
                    if (!Arrays.equals(block.getStateId(), finalStateId)) {
                        throw new VerificationException("Final state mismatch (expected " + Hex.toHexString((byte[])block.getStateId()) + " but found " + Hex.toHexString((byte[])finalStateId) + ")");
                    }
                    success = true;
                }
                finally {
                    if (success) {
                        app.commitBlock(id);
                    } else {
                        app.abortBlock(id);
                    }
                }
            }
            catch (TimeoutException e) {
                throw new ApplicationTimeoutException(e);
            }
            catch (UnknownGroupIdException e) {
                throw new MisbehavingApplicationException(e);
            }
        }
    }

    private void finalStateIsTheInitialStateOfTheApplication() throws VerificationException, InterruptedException, ApplicationTimeoutException, ClosedApplicationException {
        byte[] expected;
        try {
            expected = this.node.getApplication().getInitialStateId();
        }
        catch (TimeoutException e) {
            throw new ApplicationTimeoutException(e);
        }
        if (!Arrays.equals(this.block.getStateId(), expected)) {
            throw new VerificationException("Final state mismatch (expected " + Hex.toHexString((byte[])expected) + " but found " + Hex.toHexString((byte[])this.block.getStateId()) + ")");
        }
    }

    public static enum Mode {
        COMPLETE,
        ABSOLUTE,
        RELATIVE;

    }
}

