/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.local.internal;

import io.mokamint.application.api.ClosedApplicationException;
import io.mokamint.application.api.UnknownStateException;
import io.mokamint.miner.api.ClosedMinerException;
import io.mokamint.miner.api.Miner;
import io.mokamint.miner.remote.api.IllegalDeadlineException;
import io.mokamint.node.api.ApplicationTimeoutException;
import io.mokamint.node.api.Block;
import io.mokamint.node.api.ClosedNodeException;
import io.mokamint.node.api.NonGenesisBlock;
import io.mokamint.node.local.api.LocalNodeConfig;
import io.mokamint.node.local.internal.Blockchain;
import io.mokamint.node.local.internal.ClosedDatabaseException;
import io.mokamint.node.local.internal.LocalNodeImpl;
import io.mokamint.node.local.internal.Mempool;
import io.mokamint.node.local.internal.MinersSet;
import io.mokamint.node.local.internal.MisbehavingApplicationException;
import io.mokamint.node.local.internal.TaskRejectedExecutionException;
import io.mokamint.node.local.internal.TransactionsExecutionTask;
import io.mokamint.nonce.api.Challenge;
import io.mokamint.nonce.api.ChallengeMatchException;
import io.mokamint.nonce.api.Deadline;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockMiner {
    private final LocalNodeImpl node;
    private final Blockchain blockchain;
    private final LocalNodeConfig config;
    private final MinersSet miners;
    private final PriorityBlockingQueue<Mempool.TransactionEntry> mempool = new PriorityBlockingQueue(100, Comparator.reverseOrder());
    private final Block previous;
    private final String heightMessage;
    private final LocalDateTime creationTimeOfPrevious;
    private final Challenge challenge;
    private final ImprovableDeadline currentDeadline = new ImprovableDeadline();
    private final Semaphore endOfDeadlineArrivalPeriod = new Semaphore(0);
    private final Semaphore endOfWaitingPeriod = new Semaphore(0);
    private final Waker waker = new Waker();
    private final Set<Miner> minersThatDidNotAnswer = ConcurrentHashMap.newKeySet();
    private final TransactionsExecutionTask transactionExecutionTask;
    private volatile boolean created;
    private volatile boolean askedToCommit;
    private volatile boolean done;
    private volatile boolean interrupted;
    private static final Logger LOGGER = Logger.getLogger(BlockMiner.class.getName());

    public BlockMiner(LocalNodeImpl node) throws InterruptedException, ApplicationTimeoutException, ClosedNodeException, ClosedDatabaseException, UnknownStateException, ClosedApplicationException {
        this.node = node;
        this.blockchain = node.getBlockchain();
        this.previous = this.blockchain.getHead().get();
        this.config = node.getConfig();
        this.miners = node.getMiners();
        this.creationTimeOfPrevious = this.blockchain.creationTimeOf(this.previous).get();
        this.heightMessage = "mining: height " + (this.previous.getDescription().getHeight() + 1L) + ": ";
        this.challenge = this.previous.getDescription().getNextChallenge();
        this.transactionExecutionTask = new TransactionsExecutionTask(node, this.mempool::take, this.previous, this.creationTimeOfPrevious);
    }

    public void mine() throws InterruptedException, TaskRejectedExecutionException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException, ClosedDatabaseException, InvalidKeyException, SignatureException {
        LOGGER.info("mining: starting mining on top of block " + this.previous.getHexHash());
        this.transactionExecutionTask.start();
        try {
            if (!this.interrupted) {
                this.node.onMiningStarted(this.previous);
                this.node.forEachMempoolTransactionAt(this.previous, this.mempool::add);
                this.requestDeadlineToEveryMiner();
                if (!this.interrupted) {
                    if (this.waitUntilFirstDeadlineArrives()) {
                        this.waitUntilDeadlineExpires();
                        if (!this.interrupted) {
                            NonGenesisBlock block = this.createNewBlock();
                            this.created = true;
                            if (!this.interrupted) {
                                this.commitIfBetterThanHead(block);
                            }
                        }
                    } else {
                        LOGGER.warning(this.heightMessage + "no deadline found (timed out while waiting for a deadline)");
                        this.node.onNoDeadlineFound(this.previous);
                    }
                }
            }
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Mempool.TransactionEntry entry) throws ClosedDatabaseException {
        if (this.blockchain.getTransactionAddress(this.previous, entry.getHash()).isEmpty()) {
            PriorityBlockingQueue<Mempool.TransactionEntry> priorityBlockingQueue = this.mempool;
            synchronized (priorityBlockingQueue) {
                if (!this.mempool.contains(entry) && this.mempool.size() < this.config.getMempoolSize()) {
                    this.mempool.offer(entry);
                }
            }
        }
    }

    public void interrupt() {
        this.interrupted = true;
        this.endOfDeadlineArrivalPeriod.release();
        this.endOfWaitingPeriod.release();
        this.waker.turnOff();
    }

    private void requestDeadlineToEveryMiner() {
        for (Miner miner : (Miner[])this.miners.get().toArray(Miner[]::new)) {
            try {
                this.requestDeadlineTo(miner);
            }
            catch (ClosedMinerException e) {
                LOGGER.warning("mining: removing miner " + String.valueOf(miner.getUUID()) + " since it has been closed");
                this.miners.remove(miner);
            }
        }
    }

    private boolean waitUntilFirstDeadlineArrives() throws InterruptedException {
        return this.endOfDeadlineArrivalPeriod.tryAcquire(this.config.getDeadlineWaitTimeout(), TimeUnit.MILLISECONDS);
    }

    private void waitUntilDeadlineExpires() throws InterruptedException {
        this.endOfWaitingPeriod.acquire();
    }

    private NonGenesisBlock createNewBlock() throws InterruptedException, ApplicationTimeoutException, InvalidKeyException, SignatureException, MisbehavingApplicationException, ClosedApplicationException {
        Deadline deadline = this.currentDeadline.get();
        this.transactionExecutionTask.stop();
        this.done = true;
        return this.transactionExecutionTask.getBlock(deadline);
    }

    private void commitIfBetterThanHead(NonGenesisBlock block) throws InterruptedException, ApplicationTimeoutException, ClosedDatabaseException, ClosedApplicationException, MisbehavingApplicationException {
        if (this.blockchain.isBetterThanHead(block)) {
            this.askedToCommit = true;
            this.transactionExecutionTask.commitBlock();
            this.node.onMined(block);
            this.addToBlockchain((Block)block);
        } else {
            LOGGER.info(this.heightMessage + "not adding any block on top of " + this.previous.getHexHash() + " since it would not improve the head");
        }
    }

    private void cleanUp() throws InterruptedException, ApplicationTimeoutException, ClosedApplicationException, MisbehavingApplicationException {
        this.done = true;
        this.transactionExecutionTask.stop();
        try {
            if (this.created && !this.askedToCommit) {
                this.transactionExecutionTask.abortBlock();
            }
            this.node.onMiningCompleted(this.previous);
        }
        finally {
            this.punishMinersThatDidNotAnswer();
        }
    }

    private void requestDeadlineTo(Miner miner) throws ClosedMinerException {
        if (!this.interrupted) {
            LOGGER.info(this.heightMessage + "challenging miner " + String.valueOf(miner.getUUID()) + " with: " + String.valueOf(this.challenge));
            this.minersThatDidNotAnswer.add(miner);
            miner.requestDeadline(this.challenge, deadline -> this.onDeadlineComputed((Deadline)deadline, miner));
        }
    }

    private void addToBlockchain(Block block) throws InterruptedException, ApplicationTimeoutException, ClosedDatabaseException, ClosedApplicationException, MisbehavingApplicationException {
        if (!this.interrupted && this.blockchain.addVerified(block)) {
            this.node.whisperWithoutAddition(block);
        }
    }

    private void onDeadlineComputed(Deadline deadline, Miner miner) {
        LOGGER.info(this.heightMessage + "miner " + String.valueOf(miner.getUUID()) + " sent deadline " + String.valueOf(deadline));
        if (this.done) {
            LOGGER.warning(this.heightMessage + "discarding belated deadline " + String.valueOf(deadline));
        } else {
            try {
                deadline.getChallenge().requireMatches(this.challenge);
                this.node.check(deadline);
                if (this.minersThatDidNotAnswer.remove(miner)) {
                    this.miners.pardon(miner, this.config.getMinerPunishmentForTimeout());
                }
                this.currentDeadline.updateIfWorseThan(deadline);
            }
            catch (ChallengeMatchException e) {
                LOGGER.warning(this.heightMessage + "discarding deadline " + String.valueOf(deadline) + " for the wrong challenge: " + e.getMessage());
                this.node.onIllegalDeadlineComputed(deadline, miner);
                this.node.punish(miner, this.config.getMinerPunishmentForIllegalDeadline(), "it provided a deadline for the wrong challenge");
            }
            catch (IllegalDeadlineException e) {
                LOGGER.warning(this.heightMessage + "discarding illegal deadline " + String.valueOf(deadline) + ": " + e.getMessage());
                this.node.onIllegalDeadlineComputed(deadline, miner);
                this.node.punish(miner, this.config.getMinerPunishmentForIllegalDeadline(), "it provided an illegal deadline");
            }
            catch (ApplicationTimeoutException e) {
                LOGGER.warning(this.heightMessage + "couldn't check a deadline since the application is unresponsive: " + e.getMessage());
            }
            catch (ClosedApplicationException e) {
                LOGGER.log(Level.SEVERE, this.heightMessage + "couldn't check a deadline since the application is misbehaving", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void setWaker(Deadline deadline) {
        long millisecondsToWait = deadline.getMillisecondsToWait(this.previous.getDescription().getAcceleration());
        long millisecondsAlreadyPassed = Duration.between(this.creationTimeOfPrevious, LocalDateTime.now(ZoneId.of("UTC"))).toMillis();
        long stillToWait = millisecondsToWait - millisecondsAlreadyPassed;
        this.waker.set(stillToWait);
    }

    private void punishMinersThatDidNotAnswer() {
        long points = this.config.getMinerPunishmentForTimeout();
        this.minersThatDidNotAnswer.forEach(miner -> this.node.punish((Miner)miner, points, "it didn't answer to the challenge"));
    }

    private class ImprovableDeadline {
        private Deadline deadline;

        private ImprovableDeadline() {
        }

        private synchronized void updateIfWorseThan(Deadline other) {
            if (this.deadline == null || other.compareByValue(this.deadline) < 0) {
                this.deadline = other;
                BlockMiner.this.endOfDeadlineArrivalPeriod.release();
                LOGGER.info(BlockMiner.this.heightMessage + "improved deadline to " + String.valueOf(this.deadline));
                BlockMiner.this.setWaker(this.deadline);
            } else {
                LOGGER.info(BlockMiner.this.heightMessage + "discarding not improving deadline " + String.valueOf(this.deadline));
            }
        }

        private synchronized Deadline get() {
            return this.deadline;
        }
    }

    private class Waker {
        private Future<?> future;

        private Waker() {
        }

        private synchronized void set(long millisecondsToWait) {
            this.turnOff();
            if (millisecondsToWait <= 0L) {
                BlockMiner.this.endOfWaitingPeriod.release();
            } else {
                try {
                    this.future = BlockMiner.this.node.submit(() -> this.taskBody(millisecondsToWait), "waker set in " + millisecondsToWait + " ms");
                    LOGGER.info(BlockMiner.this.heightMessage + "set up a waker in " + millisecondsToWait + " ms");
                }
                catch (TaskRejectedExecutionException e) {
                    LOGGER.warning(BlockMiner.this.heightMessage + "could not set up a next waker, probably because the node is shutting down");
                }
            }
        }

        private void taskBody(long millisecondsToWait) {
            try {
                Thread.sleep(millisecondsToWait);
                BlockMiner.this.endOfWaitingPeriod.release();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private synchronized void turnOff() {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
    }
}

