/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.miner.remote.internal;

import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.hotmoka.websockets.api.FailedDeploymentException;
import io.hotmoka.websockets.beans.api.RpcMessage;
import io.hotmoka.websockets.server.AbstractRPCWebSocketServer;
import io.hotmoka.websockets.server.AbstractServerEndpoint;
import io.hotmoka.websockets.server.api.WebSocketServer;
import io.mokamint.miner.api.BalanceProvider;
import io.mokamint.miner.api.ClosedMinerException;
import io.mokamint.miner.api.MiningSpecification;
import io.mokamint.miner.messages.GetBalanceMessages;
import io.mokamint.miner.messages.GetBalanceResultMessages;
import io.mokamint.miner.messages.GetMiningSpecificationMessages;
import io.mokamint.miner.messages.GetMiningSpecificationResultMessages;
import io.mokamint.miner.messages.api.GetBalanceMessage;
import io.mokamint.miner.messages.api.GetMiningSpecificationMessage;
import io.mokamint.miner.remote.api.DeadlineValidityCheck;
import io.mokamint.miner.remote.api.DeadlineValidityCheckException;
import io.mokamint.miner.remote.api.IllegalDeadlineException;
import io.mokamint.miner.remote.api.RemoteMiner;
import io.mokamint.miner.remote.internal.ListOfMiningRequests;
import io.mokamint.nonce.Challenges;
import io.mokamint.nonce.Deadlines;
import io.mokamint.nonce.api.Challenge;
import io.mokamint.nonce.api.Deadline;
import jakarta.websocket.CloseReason;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class RemoteMinerImpl
extends AbstractRPCWebSocketServer
implements RemoteMiner {
    private final UUID uuid = UUID.randomUUID();
    private final int port;
    private final MiningSpecification miningSpecification;
    private final BalanceProvider balanceProvider;
    private final DeadlineValidityCheck check;
    private final Set<Session> sessions = ConcurrentHashMap.newKeySet();
    private final ListOfMiningRequests requests = new ListOfMiningRequests(10);
    private final String logPrefix;
    private static final Logger LOGGER = Logger.getLogger(RemoteMinerImpl.class.getName());

    public RemoteMinerImpl(int port, MiningSpecification miningSpecification, BalanceProvider balanceProvider, DeadlineValidityCheck check) throws FailedDeploymentException {
        this.port = port;
        this.miningSpecification = miningSpecification;
        this.balanceProvider = balanceProvider;
        this.check = Objects.requireNonNull(check);
        this.logPrefix = "remote miner listening at port " + port + ": ";
        this.startContainer("", port, new ServerEndpointConfig[]{GetBalanceEndpoint.config(this), GetMiningSpecificationEndpoint.config(this), MiningEndpoint.config(this)});
        LOGGER.info(this.logPrefix + "published at ws://localhost:" + port);
    }

    protected void processRequest(Session session, RpcMessage message) throws IOException, InterruptedException {
        String id = message.getId();
        try {
            RpcMessage rpcMessage = message;
            Objects.requireNonNull(rpcMessage);
            RpcMessage rpcMessage2 = rpcMessage;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GetMiningSpecificationMessage.class, GetBalanceMessage.class}, (Object)rpcMessage2, n)) {
                case 0: {
                    GetMiningSpecificationMessage gmsm = (GetMiningSpecificationMessage)rpcMessage2;
                    this.sendObjectAsync(session, GetMiningSpecificationResultMessages.of((MiningSpecification)this.getMiningSpecification(), (String)id));
                    break;
                }
                case 1: {
                    GetBalanceMessage gbm = (GetBalanceMessage)rpcMessage2;
                    this.sendObjectAsync(session, GetBalanceResultMessages.of(this.getBalance(gbm.getSignature(), gbm.getPublicKey()), (String)id));
                    break;
                }
                default: {
                    LOGGER.warning(this.logPrefix + "unexpected message of type " + message.getClass().getName());
                    break;
                }
            }
        }
        catch (ClosedMinerException e) {
            LOGGER.warning(this.logPrefix + "request processing failed since the serviced miner has been closed: " + e.getMessage());
        }
    }

    protected void onGetMiningSpecification(GetMiningSpecificationMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /get_mining_specification request");
        this.scheduleRequest(session, (RpcMessage)message);
    }

    protected void onGetBalance(GetBalanceMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /get_balance request");
        this.scheduleRequest(session, (RpcMessage)message);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void requestDeadline(Challenge challenge, Consumer<Deadline> onDeadlineComputed) throws ClosedMinerException {
        this.ensureIsOpen(ClosedMinerException::new);
        this.requests.add(challenge, onDeadlineComputed);
        LOGGER.info(this.logPrefix + "requesting " + String.valueOf(challenge) + " to " + this.sessions.size() + " open sessions");
        this.sessions.stream().filter(Session::isOpen).forEach(session -> this.sendChallenge((Session)session, challenge));
    }

    public MiningSpecification getMiningSpecification() throws ClosedMinerException {
        this.ensureIsOpen(ClosedMinerException::new);
        return this.miningSpecification;
    }

    public Optional<BigInteger> getBalance(SignatureAlgorithm signature, PublicKey publicKey) throws ClosedMinerException, InterruptedException {
        this.ensureIsOpen(ClosedMinerException::new);
        return this.balanceProvider.get(signature, publicKey);
    }

    private void sendChallenge(Session session, Challenge challenge) {
        try {
            this.sendObjectAsync(session, challenge);
        }
        catch (IOException e) {
            LOGGER.warning(this.logPrefix + "cannot send to session " + session.getId() + ": " + e.getMessage());
        }
    }

    protected void closeResources() {
        try {
            this.sessions.forEach(session -> this.close((Session)session, new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "The remote miner has been turned off.")));
            LOGGER.info(this.logPrefix + "unpublished from ws://localhost:" + this.port);
        }
        finally {
            super.closeResources();
        }
    }

    public String toString() {
        int sessionsCount = this.sessions.size();
        Object openSessions = sessionsCount == 1 ? "1 open session" : sessionsCount + " open sessions";
        return "a remote miner published at ws://localhost:" + this.port + ", with " + (String)openSessions;
    }

    private void addSession(Session session) {
        this.sessions.add(session);
        LOGGER.info(this.logPrefix + "bound miner service " + session.getId());
        this.requests.forAllChallenges(challenge -> this.sendChallenge(session, (Challenge)challenge));
    }

    private void removeSession(Session session) {
        this.sessions.remove(session);
        LOGGER.info(this.logPrefix + "unbound miner service " + session.getId());
    }

    private void processDeadline(Deadline deadline, Session session) {
        try {
            this.check.check(deadline);
            LOGGER.info(this.logPrefix + "notifying deadline: " + String.valueOf(deadline));
            this.requests.runAllActionsFor(deadline);
        }
        catch (IllegalDeadlineException e) {
            LOGGER.warning(this.logPrefix + "removing session " + session.getId() + " since it sent an illegal deadline: " + e.getMessage());
            this.removeSession(session);
            this.close(session, new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, e.getMessage()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (DeadlineValidityCheckException e) {
            LOGGER.warning(this.logPrefix + "the check of the validity of " + String.valueOf(deadline) + " failed: " + e.getMessage());
        }
    }

    private void close(Session session, CloseReason reason) {
        try {
            session.close(reason);
        }
        catch (IOException | IllegalStateException e) {
            LOGGER.warning(this.logPrefix + "cannot close session " + session.getId() + ": " + e.getMessage());
        }
    }

    public static class GetBalanceEndpoint
    extends AbstractServerEndpoint<RemoteMinerImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            RemoteMinerImpl server = (RemoteMinerImpl)this.getServer();
            this.addMessageHandler(session, message -> server.onGetBalance((GetBalanceMessage)message, session));
        }

        private static ServerEndpointConfig config(RemoteMinerImpl server) {
            return GetBalanceEndpoint.simpleConfig((WebSocketServer)server, GetBalanceEndpoint.class, (String)"/get_balance", (Class[])new Class[]{GetBalanceMessages.Decoder.class, GetBalanceResultMessages.Encoder.class});
        }
    }

    public static class GetMiningSpecificationEndpoint
    extends AbstractServerEndpoint<RemoteMinerImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            RemoteMinerImpl server = (RemoteMinerImpl)this.getServer();
            this.addMessageHandler(session, message -> server.onGetMiningSpecification((GetMiningSpecificationMessage)message, session));
        }

        private static ServerEndpointConfig config(RemoteMinerImpl server) {
            return GetMiningSpecificationEndpoint.simpleConfig((WebSocketServer)server, GetMiningSpecificationEndpoint.class, (String)"/get_mining_specification", (Class[])new Class[]{GetMiningSpecificationMessages.Decoder.class, GetMiningSpecificationResultMessages.Encoder.class});
        }
    }

    public static class MiningEndpoint
    extends AbstractServerEndpoint<RemoteMinerImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            RemoteMinerImpl server = (RemoteMinerImpl)this.getServer();
            server.addSession(session);
            this.addMessageHandler(session, deadline -> server.processDeadline((Deadline)deadline, session));
        }

        public void onClose(Session session, CloseReason closeReason) {
            ((RemoteMinerImpl)this.getServer()).removeSession(session);
        }

        private static ServerEndpointConfig config(RemoteMinerImpl server) {
            return MiningEndpoint.simpleConfig((WebSocketServer)server, MiningEndpoint.class, (String)"/mining", (Class[])new Class[]{Deadlines.Decoder.class, Challenges.Encoder.class});
        }
    }
}

