/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.miner.remote.internal;

import io.mokamint.nonce.api.Challenge;
import io.mokamint.nonce.api.Deadline;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Consumer;

public class ListOfMiningRequests {
    private final Deque<Challenge> challenges = new LinkedList<Challenge>();
    private final Deque<Consumer<Deadline>> actions = new LinkedList<Consumer<Deadline>>();
    private final Object lock = new Object();
    private final int max;

    public ListOfMiningRequests(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("max must be positive");
        }
        this.max = max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Challenge description, Consumer<Deadline> action) {
        Object object = this.lock;
        synchronized (object) {
            if (this.challenges.size() == this.max) {
                this.challenges.removeFirst();
                this.actions.removeFirst();
            }
            this.challenges.addLast(description);
            this.actions.addLast(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAllActionsFor(Deadline deadline) {
        ArrayList<Consumer> filtered = new ArrayList<Consumer>();
        Challenge challengeOfDeadline = deadline.getChallenge();
        Object object = this.lock;
        synchronized (object) {
            Iterator<Consumer<Deadline>> it = this.actions.iterator();
            for (Challenge challenge : this.challenges) {
                Consumer<Deadline> action2 = it.next();
                if (!challenge.equals((Object)challengeOfDeadline)) continue;
                filtered.add(action2);
            }
        }
        filtered.forEach(action -> action.accept(deadline));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forAllChallenges(Consumer<Challenge> what) {
        ArrayList<Challenge> copy;
        Object object = this.lock;
        synchronized (object) {
            copy = new ArrayList<Challenge>(this.challenges);
        }
        copy.forEach(what);
    }
}

