/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.raj;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;

public class RajRunner {
    private static final byte SUPER_SECRET_ENCRYPTION_CONSTANT = 43;

    public static void main(String[] args) throws Exception {
        Path tempFile = Files.createTempFile("raj", ".jar", new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        try (InputStream sourceIs = RajRunner.class.getClassLoader().getResourceAsStream("blob.raj");){
            if (sourceIs == null) {
                throw new IllegalStateException("Expected to find a blob.raj file as a resource within the current jar");
            }
            byte[] entryBytes = sourceIs.readAllBytes();
            int i = 0;
            while (i < entryBytes.length) {
                int n = i++;
                entryBytes[n] = (byte)(entryBytes[n] ^ 0x2B);
            }
            Files.write(tempFile, entryBytes, new OpenOption[0]);
        }
        String javaExecutable = System.getProperty("os.name").startsWith("Windows") ? System.getProperty("java.home") + "/bin/java.exe" : System.getProperty("java.home") + "/bin/java";
        if (!Files.exists(Paths.get(javaExecutable, new String[0]), new LinkOption[0])) {
            throw new IllegalStateException("Java executable does not exist at the expected location " + javaExecutable);
        }
        ArrayList<String> processArgs = new ArrayList<String>(args.length + 3);
        processArgs.add(javaExecutable);
        processArgs.add("-jar");
        processArgs.add(tempFile.toString());
        processArgs.addAll(Arrays.asList(args));
        new ProcessBuilder(processArgs).inheritIO().start().waitFor();
    }
}

