/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.render.views;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.Writable;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.fields.FormElement;
import io.micronaut.views.fields.render.FormElementRenderer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

@Internal
public class ViewsFormElementRenderer<T extends FormElement>
implements FormElementRenderer<T> {
    private final ViewsRenderer<Map<String, FormElement>, ?> viewsRenderer;
    private final String viewName;
    private final String modelKey;

    public ViewsFormElementRenderer(ViewsRenderer<Map<String, FormElement>, ?> viewsRenderer, String viewName, String modelKey) {
        this.viewsRenderer = viewsRenderer;
        this.viewName = viewName;
        this.modelKey = modelKey;
    }

    public ViewsFormElementRenderer(ViewsRenderer<Map<String, FormElement>, ?> viewsRenderer, String viewName) {
        this(viewsRenderer, viewName, "el");
    }

    @Override
    public String render(T formElement, Locale locale) {
        try {
            return ViewsFormElementRenderer.toString(this.viewsRenderer.render(this.viewName, Collections.singletonMap(this.modelKey, formElement), null));
        }
        catch (IOException e) {
            throw new ViewRenderingException("Could not render view " + this.viewName + "for form element", (Throwable)e);
        }
    }

    @NonNull
    private static String toString(@NonNull Writable writable) throws IOException {
        StringWriter stringWriter = new StringWriter();
        writable.writeTo((Writer)stringWriter);
        return stringWriter.toString();
    }
}

