/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.render.secondary;

import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.views.fields.HtmlAttribute;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.elements.Option;
import io.micronaut.views.fields.render.FormElementRenderer;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@Internal
@Secondary
@Singleton
public class OptionFormElementRenderer
implements FormElementRenderer<Option> {
    private final MessageSource messageSource;

    public OptionFormElementRenderer(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    @NonNull
    public String render(@NonNull Option el, @NonNull Locale locale) {
        return this.render(HtmlTag.OPTION, this.attributes(el), this.content(el.label(), this.messageSource, locale));
    }

    protected List<HtmlAttribute> attributes(@NonNull Option el) {
        ArrayList<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>(3);
        attributes.add(new HtmlAttribute("value", el.value()));
        if (el.selected()) {
            attributes.add(new HtmlAttribute("selected", null));
        }
        if (el.disabled()) {
            attributes.add(new HtmlAttribute("disabled", null));
        }
        return attributes;
    }
}

