/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.render.secondary;

import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.views.fields.HtmlAttribute;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.InputNumberFormElement;
import io.micronaut.views.fields.render.FormElementRenderer;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@Internal
@Secondary
@Singleton
public class InputNumberFormElementRenderer
implements FormElementRenderer<InputNumberFormElement> {
    private final MessageSource messageSource;

    public InputNumberFormElementRenderer(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public String render(InputNumberFormElement el, Locale locale) {
        StringBuilder sb = new StringBuilder();
        if (el.label() != null) {
            sb.append(this.renderLabel(el.id(), el.label(), this.messageSource, locale));
        }
        sb.append(this.render(HtmlTag.INPUT, this.attributes(el)));
        return sb.toString();
    }

    @NonNull
    protected List<HtmlAttribute> attributes(@NonNull InputNumberFormElement el) {
        ArrayList<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>(10);
        attributes.add(this.typeHtmlAttribute(InputType.NUMBER));
        attributes.add(new HtmlAttribute("name", el.name()));
        if (el.value() != null) {
            attributes.add(new HtmlAttribute("value", String.valueOf(el.value())));
        }
        if (el.id() != null) {
            attributes.add(new HtmlAttribute("id", el.id()));
        }
        if (el.min() != null) {
            attributes.add(new HtmlAttribute("min", String.valueOf(el.min())));
        }
        if (el.max() != null) {
            attributes.add(new HtmlAttribute("max", String.valueOf(el.max())));
        }
        if (el.placeholder() != null) {
            attributes.add(new HtmlAttribute("placeholder", el.placeholder()));
        }
        if (el.required()) {
            attributes.add(new HtmlAttribute("required", null));
        }
        if (el.readOnly()) {
            attributes.add(new HtmlAttribute("readonly", null));
        }
        if (el.step() != null) {
            attributes.add(new HtmlAttribute("step", el.step()));
        }
        return attributes;
    }
}

