/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.formelementresolvers;

import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.views.fields.FormElement;
import io.micronaut.views.fields.formelementresolvers.FormElementResolver;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;

@Primary
@Singleton
@Internal
public class CompositeFormElementResolver
implements FormElementResolver {
    private final List<FormElementResolver> formElementResolvers;

    public CompositeFormElementResolver(List<FormElementResolver> formElementResolvers) {
        this.formElementResolvers = formElementResolvers;
    }

    @Override
    public <B, T> Optional<Class<? extends FormElement>> resolve(BeanProperty<B, T> beanProperty) {
        return this.formElementResolvers.stream().map(resolver -> resolver.resolve(beanProperty)).flatMap(Optional::stream).findFirst();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

