/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.fetchers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.views.fields.elements.Radio;
import io.micronaut.views.fields.fetchers.RadioFetcher;
import io.micronaut.views.fields.messages.Message;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EnumRadioFetcher<T>
implements RadioFetcher<T> {
    private static final Logger LOG = LoggerFactory.getLogger(EnumRadioFetcher.class);

    @Override
    public List<Radio> generate(Class<T> type) {
        if (type.isEnum()) {
            return this.generateEnumRadioButtons(type, null);
        }
        LOG.warn("Type {} is not an enum", type);
        return Collections.emptyList();
    }

    @Override
    public List<Radio> generate(T instance) {
        if (instance.getClass().isEnum()) {
            return this.generateEnumRadioButtons(instance.getClass(), (Enum)instance);
        }
        LOG.warn("instance {} is not an enum", instance.getClass());
        return Collections.emptyList();
    }

    @NonNull
    private List<Radio> generateEnumRadioButtons(@NonNull Class<? extends Enum> type, @Nullable Enum instance) {
        return EnumSet.allOf(type).stream().map(it -> {
            Radio.Builder builder = this.radioButtonFromEnum(type, (Enum)it);
            if (instance != null && ((Enum)it).name().equals(instance.name())) {
                builder.checked(true);
            }
            return builder.build();
        }).toList();
    }

    @NonNull
    private Radio.Builder radioButtonFromEnum(@NonNull Class<? extends Enum> type, @NonNull Enum instance) {
        String name = instance.name();
        return Radio.builder().id(name.toLowerCase()).value(name).label(Message.of(type, name));
    }
}

