/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.fetchers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.views.fields.elements.Checkbox;
import io.micronaut.views.fields.fetchers.CheckboxFetcher;
import io.micronaut.views.fields.messages.Message;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EnumCheckboxFetcher<T>
implements CheckboxFetcher<T> {
    private static final Logger LOG = LoggerFactory.getLogger(EnumCheckboxFetcher.class);

    @Override
    public List<Checkbox> generate(Class<T> type) {
        if (type.isEnum()) {
            return this.generateEnumCheckboxButtons(type, null);
        }
        LOG.warn("Type {} is not an enum", type);
        return Collections.emptyList();
    }

    @Override
    public List<Checkbox> generate(T instance) {
        if (instance.getClass().isEnum()) {
            return this.generateEnumCheckboxButtons(instance.getClass(), (Enum)instance);
        }
        LOG.warn("instance {} is not an enum", instance.getClass());
        return Collections.emptyList();
    }

    @NonNull
    private List<Checkbox> generateEnumCheckboxButtons(@NonNull Class<? extends Enum> type, @Nullable Enum instance) {
        return EnumSet.allOf(type).stream().map(it -> {
            Checkbox.Builder builder = this.checkboxButtonFromEnum(type, (Enum)it);
            if (instance != null && ((Enum)it).name().equals(instance.name())) {
                builder.checked(true);
            }
            return builder.build();
        }).toList();
    }

    @NonNull
    private Checkbox.Builder checkboxButtonFromEnum(@NonNull Class<? extends Enum> type, @NonNull Enum instance) {
        String name = instance.name();
        return Checkbox.builder().id(name.toLowerCase()).value(name).label(Message.of(type, name));
    }
}

