/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.elements;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.views.fields.FormElement;
import io.micronaut.views.fields.messages.Message;

@Introspected(builder=@Introspected.IntrospectionBuilder(builderClass=Builder.class))
public record Radio(@NonNull String value, @Nullable String id, @NonNull Message label, @NonNull boolean checked, boolean disabled) implements FormElement
{
    @Deprecated(since="5.2.0", forRemoval=true)
    public Radio(@NonNull String value, @Nullable String id, @NonNull Message label, @NonNull boolean checked) {
        this(value, id, label, checked, false);
    }

    public boolean isChecked() {
        return this.checked;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public Message getLabel() {
        return this.label;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String value;
        private String id;
        private Message label;
        private boolean checked;
        private boolean disabled;

        public Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        @NonNull
        public Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder label(Message label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Builder checked(boolean checked) {
            this.checked = checked;
            return this;
        }

        @NonNull
        public Builder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @NonNull
        public Radio build() {
            return new Radio(this.value, this.id, this.label, this.checked, this.disabled);
        }
    }
}

