/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.elements;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.InputFormElement;
import io.micronaut.views.fields.elements.Radio;
import io.micronaut.views.fields.messages.Message;
import java.util.Collections;
import java.util.List;

@Introspected(builder=@Introspected.IntrospectionBuilder(builderClass=Builder.class))
public record InputRadioFormElement(@NonNull String name, boolean required, @NonNull List<Radio> buttons, @NonNull Message label) implements InputFormElement
{
    @Override
    @NonNull
    public InputType getType() {
        return InputType.RADIO;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Radio> buttons;
        private String name;
        private boolean required;
        private Message label;

        @NonNull
        public Builder label(Message label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder buttons(@NonNull List<Radio> buttons) {
            this.buttons = buttons;
            return this;
        }

        public InputRadioFormElement build() {
            return new InputRadioFormElement(this.name, this.required, this.buttons == null ? Collections.emptyList() : this.buttons, this.label);
        }
    }
}

