/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.elements;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.FormElementAttributes;
import io.micronaut.views.fields.elements.GlobalAttributes;
import io.micronaut.views.fields.elements.InputFormElement;
import io.micronaut.views.fields.messages.Message;
import java.util.Collections;
import java.util.List;

@Introspected(builder=@Introspected.IntrospectionBuilder(builderClass=Builder.class))
public record InputFileFormElement(@NonNull String name, @Nullable String id, @Nullable String accept, boolean required, @Nullable Message label, @NonNull List<Message> errors) implements InputFormElement,
GlobalAttributes,
FormElementAttributes
{
    @Override
    @NonNull
    public InputType getType() {
        return InputType.FILE;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String id;
        private String accept;
        private boolean required;
        private List<Message> errors;
        private Message label;

        @NonNull
        public Builder accept(@NonNull String accept) {
            this.accept = accept;
            return this;
        }

        @NonNull
        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @NonNull
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder id(@NonNull String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder label(Message label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Builder errors(@NonNull List<Message> errors) {
            this.errors = errors;
            return this;
        }

        @NonNull
        public InputFileFormElement build() {
            return new InputFileFormElement(this.name, this.id, this.accept, this.required, this.label, this.errors == null ? Collections.emptyList() : this.errors);
        }
    }
}

