/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.elements;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.views.fields.FormElement;
import io.micronaut.views.fields.elements.GlobalAttributes;
import io.micronaut.views.fields.messages.Message;

@Introspected(builder=@Introspected.IntrospectionBuilder(builderClass=Builder.class))
public record Checkbox(@NonNull String name, @NonNull String value, boolean checked, boolean disabled, boolean required, @Nullable String id, @Nullable Message label) implements FormElement,
GlobalAttributes
{
    @Deprecated(forRemoval=true, since="5.2.0")
    public Checkbox(@NonNull String name, @NonNull String value, boolean checked, boolean required, @Nullable String id, @Nullable Message label) {
        this(name, value, checked, false, required, id, label);
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String id;
        private boolean checked;
        private boolean disabled;
        private boolean required;
        private String value;
        private Message label;

        @NonNull
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder id(@NonNull String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder value(@NonNull String value) {
            this.value = value;
            return this;
        }

        @NonNull
        public Builder label(Message label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Builder checked(boolean checked) {
            this.checked = checked;
            return this;
        }

        @NonNull
        public Builder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @NonNull
        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @NonNull
        public Checkbox build() {
            return new Checkbox(this.name, this.value, this.checked, this.disabled, this.required, this.id, this.label);
        }
    }
}

