/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.render.secondary;

import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.views.fields.HtmlAttribute;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.elements.Option;
import io.micronaut.views.fields.elements.SelectFormElement;
import io.micronaut.views.fields.render.FormElementRenderer;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@Secondary
@Singleton
public class SelectFormElementRenderer
implements FormElementRenderer<SelectFormElement> {
    private final MessageSource messageSource;
    private final FormElementRenderer<Option> optionFormElementRenderer;

    public SelectFormElementRenderer(MessageSource messageSource, FormElementRenderer<Option> optionFormElementRenderer) {
        this.messageSource = messageSource;
        this.optionFormElementRenderer = optionFormElementRenderer;
    }

    @Override
    @NonNull
    public String render(@NonNull SelectFormElement el, @NonNull Locale locale) {
        StringBuilder html = new StringBuilder();
        if (el.label() != null) {
            html.append(this.renderLabel(el.id(), el.label(), this.messageSource, locale));
        }
        html.append(this.renderOpenTag(HtmlTag.SELECT, this.attributes(el)));
        for (Option option : el.options()) {
            html.append(this.optionFormElementRenderer.render(option, locale));
        }
        html.append(this.renderCloseTag(HtmlTag.SELECT));
        return html.toString();
    }

    protected List<HtmlAttribute> attributes(@NonNull SelectFormElement el) {
        ArrayList<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>(3);
        attributes.add(new HtmlAttribute("name", el.name()));
        if (el.required()) {
            attributes.add(new HtmlAttribute("required", null));
        }
        if (el.id() != null) {
            attributes.add(new HtmlAttribute("id", el.id()));
        }
        return attributes;
    }
}

