/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.render.secondary;

import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.views.fields.HtmlAttribute;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.InputSubmitFormElement;
import io.micronaut.views.fields.render.FormElementRenderer;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@Internal
@Secondary
@Singleton
public class InputSubmitFormElementRenderer
implements FormElementRenderer<InputSubmitFormElement> {
    private final MessageSource messageSource;

    public InputSubmitFormElementRenderer(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    @NonNull
    public String render(@NonNull InputSubmitFormElement formElement, @NonNull Locale locale) {
        return this.render(HtmlTag.INPUT, this.attributes(formElement, locale));
    }

    protected List<HtmlAttribute> attributes(@NonNull InputSubmitFormElement el, @NonNull Locale locale) {
        ArrayList<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>(2);
        attributes.add(this.typeHtmlAttribute(InputType.SUBMIT));
        attributes.add(new HtmlAttribute("value", this.content(el.value(), this.messageSource, locale)));
        return attributes;
    }
}

