/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.render.secondary;

import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.views.fields.HtmlAttribute;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.Checkbox;
import io.micronaut.views.fields.elements.InputCheckboxFormElement;
import io.micronaut.views.fields.render.FormElementRenderer;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

@Internal
@Singleton
@Secondary
public class InputCheckboxFormElementRenderer
implements FormElementRenderer<InputCheckboxFormElement> {
    private final MessageSource messageSource;

    public InputCheckboxFormElementRenderer(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public String render(@NonNull InputCheckboxFormElement formElement, @NonNull Locale locale) {
        StringBuilder sb = new StringBuilder();
        for (Checkbox checkbox : formElement.checkboxes()) {
            sb.append(this.renderOpenTag(HtmlTag.DIV, Collections.emptyList()));
            sb.append(this.render(HtmlTag.INPUT, this.attributes(checkbox)));
            sb.append(this.renderLabel(checkbox.id(), checkbox.label(), this.messageSource, locale));
            sb.append(this.renderCloseTag(HtmlTag.DIV));
        }
        return sb.toString();
    }

    protected List<HtmlAttribute> attributes(@NonNull Checkbox el) {
        ArrayList<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>(6);
        attributes.add(this.typeHtmlAttribute(InputType.CHECKBOX));
        attributes.add(new HtmlAttribute("name", el.name()));
        if (el.value() != null) {
            attributes.add(new HtmlAttribute("value", el.value()));
        }
        if (el.id() != null) {
            attributes.add(new HtmlAttribute("id", el.id()));
        }
        if (el.required()) {
            attributes.add(new HtmlAttribute("required", null));
        }
        if (el.checked()) {
            attributes.add(new HtmlAttribute("checked", null));
        }
        return attributes;
    }
}

