/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.messages;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.util.StringUtils;
import io.micronaut.views.fields.messages.ConstraintViolationUtils;
import jakarta.validation.ConstraintViolation;
import java.util.ArrayList;

public record Message(@NonNull String defaultMessage, @Nullable String code) implements Comparable<Message>
{
    private static final String REGEX = "(.)([A-Z])";
    private static final String REPLACEMENT = "$1 $2";
    private static final String DOT = ".";

    @Override
    public int compareTo(Message o) {
        int compare = this.defaultMessage().compareTo(o.defaultMessage());
        if (compare != 0) {
            return compare;
        }
        if (this.code() == null && o.code() != null) {
            return -1;
        }
        if (this.code() != null && o.code() == null) {
            return 1;
        }
        if (this.code() == null) {
            return 0;
        }
        return this.code().compareTo(o.code());
    }

    @NonNull
    public static Message of(@NonNull String defaultMessage, @Nullable String code) {
        return new Message(defaultMessage, code);
    }

    @NonNull
    public static Message of(@NonNull String defaultMessage) {
        return Message.of(defaultMessage, null);
    }

    @NonNull
    public static Message of(Class<?> type, String name) {
        String nameCode = Message.isAllUpperCase(name) ? name.toLowerCase() : name;
        String defaultMessage = StringUtils.capitalize((String)nameCode.replaceAll(REGEX, REPLACEMENT));
        String code = type.getSimpleName().toLowerCase() + DOT + nameCode;
        return Message.of(defaultMessage, code);
    }

    @NonNull
    public static Message of(@NonNull BeanProperty<?, ?> beanProperty) {
        return Message.of(beanProperty.getDeclaringBean().getBeanType(), beanProperty.getName());
    }

    @NonNull
    public static Message of(@NonNull ConstraintViolation<?> violation) {
        ArrayList<String> parts = new ArrayList<String>(3);
        parts.add(violation.getLeafBean().getClass().getSimpleName());
        ConstraintViolationUtils.lastNode(violation).ifPresent(parts::add);
        ConstraintViolationUtils.constraintCode(violation).ifPresent(parts::add);
        return Message.of(violation.getMessage(), String.join((CharSequence)DOT, parts.stream().map(String::toLowerCase).toList()));
    }

    private static boolean isAllUpperCase(@NonNull String input) {
        for (char c : input.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }
}

