/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.fetchers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.views.fields.elements.Option;
import io.micronaut.views.fields.fetchers.OptionFetcher;
import io.micronaut.views.fields.messages.Message;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EnumOptionFetcher<T>
implements OptionFetcher<T> {
    private static final Logger LOG = LoggerFactory.getLogger(EnumOptionFetcher.class);

    @Override
    public List<Option> generate(Class<T> type) {
        if (type.isEnum()) {
            return this.generateEnumOptions(type, null);
        }
        LOG.warn("Type {} is not an enum", type);
        return Collections.emptyList();
    }

    @Override
    public List<Option> generate(T instance) {
        if (instance.getClass().isEnum()) {
            return this.generateEnumOptions(instance.getClass(), (Enum)instance);
        }
        LOG.warn("instance {} is not an enum", instance.getClass());
        return Collections.emptyList();
    }

    @NonNull
    private List<Option> generateEnumOptions(@NonNull Class<? extends Enum> type, @Nullable Enum instance) {
        return EnumSet.allOf(type).stream().map(it -> {
            Option.Builder builder = this.optionFromEnum(type, (Enum)it);
            if (instance != null && ((Enum)it).name().equals(instance.name())) {
                builder.selected(true);
            }
            return builder.build();
        }).toList();
    }

    @NonNull
    private Option.Builder optionFromEnum(@NonNull Class<? extends Enum> type, @NonNull Enum instance) {
        String name = instance.name();
        return Option.builder().value(name).label(Message.of(type, name));
    }
}

