/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.elements;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.views.fields.FormElement;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.elements.FormElementAttributes;
import io.micronaut.views.fields.elements.GlobalAttributes;
import io.micronaut.views.fields.messages.Message;
import java.util.Collections;
import java.util.List;

@Introspected(builder=@Introspected.IntrospectionBuilder(builderClass=Builder.class))
public record TextareaFormElement(@NonNull String name, @Nullable String id, @Nullable Integer cols, @Nullable Integer rows, @Nullable String placeholder, boolean required, boolean readOnly, @Nullable String value, @Nullable Message label, @NonNull List<Message> errors) implements FormElement,
FormElementAttributes,
GlobalAttributes
{
    @Override
    public HtmlTag getTag() {
        return HtmlTag.TEXTAREA;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String id;
        private String placeholder;
        private boolean required;
        private boolean readOnly;
        private Integer rows;
        private Integer cols;
        private String value;
        private List<Message> errors;
        private Message label;

        @NonNull
        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @NonNull
        public Builder readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @NonNull
        public Builder rows(@NonNull Integer rows) {
            this.rows = rows;
            return this;
        }

        @NonNull
        public Builder cols(@NonNull Integer cols) {
            this.cols = cols;
            return this;
        }

        @NonNull
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder id(@NonNull String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder placeholder(@NonNull String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        @NonNull
        public Builder value(@NonNull String value) {
            this.value = value;
            return this;
        }

        @NonNull
        public Builder label(Message label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Builder errors(@NonNull List<Message> errors) {
            this.errors = errors;
            return this;
        }

        @NonNull
        public TextareaFormElement build() {
            return new TextareaFormElement(this.name, this.id, this.cols, this.rows, this.placeholder, this.required, this.readOnly, this.value, this.label, this.errors != null ? this.errors : Collections.emptyList());
        }
    }
}

