/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.elements;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.FormElementAttributes;
import io.micronaut.views.fields.elements.GlobalAttributes;
import io.micronaut.views.fields.elements.InputFormElement;
import io.micronaut.views.fields.messages.Message;
import java.util.Collections;
import java.util.List;

@Introspected(builder=@Introspected.IntrospectionBuilder(builderClass=Builder.class))
public record InputNumberFormElement(@NonNull String name, @Nullable String id, @Nullable Number value, @Nullable Number max, @Nullable Number min, @Nullable String placeholder, boolean required, boolean readOnly, @Nullable String step, @NonNull Message label, @NonNull List<Message> errors) implements InputFormElement,
GlobalAttributes,
FormElementAttributes
{
    @Override
    @NonNull
    public InputType getType() {
        return InputType.NUMBER;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @NonNull
        private String name;
        @Nullable
        private String id;
        @Nullable
        private Number value;
        @Nullable
        private Number max;
        @Nullable
        private Number min;
        @Nullable
        private String placeholder;
        @Nullable
        private String step;
        private boolean required;
        private boolean readOnly;
        private Message label;
        private List<Message> errors;

        @NonNull
        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @NonNull
        public Builder readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @NonNull
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder value(@Nullable Number value) {
            this.value = value;
            return this;
        }

        @NonNull
        public Builder max(@Nullable Number max) {
            this.max = max;
            return this;
        }

        @NonNull
        public Builder min(@Nullable Number min) {
            this.min = min;
            return this;
        }

        @NonNull
        public Builder placeholder(@Nullable String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        @NonNull
        public Builder step(@Nullable String step) {
            this.step = step;
            return this;
        }

        @NonNull
        public Builder label(Message label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Builder errors(@NonNull List<Message> errors) {
            this.errors = errors;
            return this;
        }

        @NonNull
        public InputNumberFormElement build() {
            return new InputNumberFormElement(this.name, this.id, this.value, this.max, this.min, this.placeholder, this.required, this.readOnly, this.step, this.label, this.errors == null ? Collections.emptyList() : this.errors);
        }
    }
}

