/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.elements;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.FormElementAttributes;
import io.micronaut.views.fields.elements.GlobalAttributes;
import io.micronaut.views.fields.elements.InputFormElement;
import io.micronaut.views.fields.messages.Message;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;

@Introspected(builder=@Introspected.IntrospectionBuilder(builderClass=Builder.class))
public record InputDateFormElement(@NonNull String name, @Nullable String id, boolean required, @Nullable LocalDate max, @Nullable LocalDate min, @Nullable LocalDate value, @Nullable String step, @Nullable Message label, @NonNull List<Message> errors) implements InputFormElement,
GlobalAttributes,
FormElementAttributes
{
    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @NonNull
    public InputType getType() {
        return InputType.DATE;
    }

    public static final class Builder {
        private String name;
        private String id;
        private boolean required;
        private LocalDate max;
        private LocalDate min;
        private LocalDate value;
        private String step;
        private List<Message> errors;
        private Message label;

        @NonNull
        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @NonNull
        public Builder max(@NonNull LocalDate max) {
            this.max = max;
            return this;
        }

        @NonNull
        public Builder min(@NonNull LocalDate min) {
            this.min = min;
            return this;
        }

        @NonNull
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder step(@NonNull String step) {
            this.step = step;
            return this;
        }

        @NonNull
        public Builder id(@NonNull String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder value(@NonNull LocalDate value) {
            this.value = value;
            return this;
        }

        @NonNull
        public Builder label(Message label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Builder errors(@NonNull List<Message> errors) {
            this.errors = errors;
            return this;
        }

        @NonNull
        public InputDateFormElement build() {
            return new InputDateFormElement(this.name, this.id, this.required, this.max, this.min, this.value, this.step, this.label, this.errors == null ? Collections.emptyList() : this.errors);
        }
    }
}

