/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.views.fields.Fieldset;
import io.micronaut.views.fields.FieldsetGenerator;
import io.micronaut.views.fields.Form;
import io.micronaut.views.fields.FormElement;
import io.micronaut.views.fields.FormGenerator;
import io.micronaut.views.fields.elements.InputSubmitFormElement;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;

@Internal
@Singleton
public class DefaultFormGenerator
implements FormGenerator {
    private final FieldsetGenerator fieldsetGenerator;

    public DefaultFormGenerator(FieldsetGenerator fieldsetGenerator) {
        this.fieldsetGenerator = fieldsetGenerator;
    }

    @Override
    public Form generateWithFieldset(@NonNull String action, @NonNull String method, @NonNull Fieldset fieldset, @NonNull InputSubmitFormElement inputSubmitFormElement) {
        return this.generate(action, method, fieldset, inputSubmitFormElement);
    }

    @Override
    public Form generate(String action, String method, Object instance, InputSubmitFormElement inputSubmitFormElement) {
        Fieldset fieldset = this.fieldsetGenerator.generate(instance);
        return this.generate(action, method, fieldset, inputSubmitFormElement);
    }

    @Override
    public Form generate(@NonNull String action, @NonNull String method, @NonNull Object instance, @NonNull ConstraintViolationException ex, @NonNull InputSubmitFormElement inputSubmitFormElement) {
        Fieldset fieldset = this.fieldsetGenerator.generate(instance, ex);
        return this.generate(action, method, fieldset, inputSubmitFormElement);
    }

    @Override
    public <T> Form generate(@NonNull @NotBlank String action, @NonNull @NotBlank String method, @NonNull @NotNull Class<T> type, @NonNull @NotNull InputSubmitFormElement inputSubmitFormElement) {
        Fieldset fieldset = this.fieldsetGenerator.generate(type);
        return this.generate(action, method, fieldset, inputSubmitFormElement);
    }

    private Form generate(@NonNull @NotBlank String action, @NonNull @NotBlank String method, @NonNull @NotNull Fieldset fieldset, @NonNull @NotNull InputSubmitFormElement inputSubmitFormElement) {
        ArrayList<? extends FormElement> fields = new ArrayList<FormElement>(fieldset.fields());
        fields.add(inputSubmitFormElement);
        return new Form(action, method, new Fieldset(fields, fieldset.errors()));
    }
}

