/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.views.fields.Fieldset;
import io.micronaut.views.fields.FieldsetGenerator;
import io.micronaut.views.fields.FormElement;
import io.micronaut.views.fields.annotations.InputCheckbox;
import io.micronaut.views.fields.annotations.InputEmail;
import io.micronaut.views.fields.annotations.InputHidden;
import io.micronaut.views.fields.annotations.InputPassword;
import io.micronaut.views.fields.annotations.InputRadio;
import io.micronaut.views.fields.annotations.InputTel;
import io.micronaut.views.fields.annotations.InputUrl;
import io.micronaut.views.fields.annotations.Select;
import io.micronaut.views.fields.annotations.Textarea;
import io.micronaut.views.fields.annotations.TrixEditor;
import io.micronaut.views.fields.elements.Checkbox;
import io.micronaut.views.fields.elements.InputCheckboxFormElement;
import io.micronaut.views.fields.elements.InputDateFormElement;
import io.micronaut.views.fields.elements.InputDateTimeLocalFormElement;
import io.micronaut.views.fields.elements.InputEmailFormElement;
import io.micronaut.views.fields.elements.InputHiddenFormElement;
import io.micronaut.views.fields.elements.InputNumberFormElement;
import io.micronaut.views.fields.elements.InputPasswordFormElement;
import io.micronaut.views.fields.elements.InputRadioFormElement;
import io.micronaut.views.fields.elements.InputTelFormElement;
import io.micronaut.views.fields.elements.InputTextFormElement;
import io.micronaut.views.fields.elements.InputTimeFormElement;
import io.micronaut.views.fields.elements.InputUrlFormElement;
import io.micronaut.views.fields.elements.SelectFormElement;
import io.micronaut.views.fields.elements.TextareaFormElement;
import io.micronaut.views.fields.elements.TrixEditorFormElement;
import io.micronaut.views.fields.fetchers.CheckboxFetcher;
import io.micronaut.views.fields.fetchers.EnumCheckboxFetcher;
import io.micronaut.views.fields.fetchers.EnumOptionFetcher;
import io.micronaut.views.fields.fetchers.EnumRadioFetcher;
import io.micronaut.views.fields.fetchers.OptionFetcher;
import io.micronaut.views.fields.fetchers.RadioFetcher;
import io.micronaut.views.fields.messages.ConstraintViolationUtils;
import io.micronaut.views.fields.messages.Message;
import jakarta.annotation.Nonnull;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.Size;
import java.lang.annotation.Annotation;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

@Internal
@Singleton
public class DefaultFieldGenerator
implements FieldsetGenerator {
    private static final String BUILDER_METHOD_NAME = "name";
    private static final String BUILDER_METHOD_REQUIRED = "required";
    private static final String BUILDER_METHOD_VALUE = "value";
    private static final String BUILDER_METHOD_ERRORS = "errors";
    private static final String BUILDER_METHOD_ID = "id";
    private static final String BUILDER_METHOD_LABEL = "label";
    private static final String BUILDER_METHOD_CHECKBOXES = "checkboxes";
    private static final String BUILDER_METHOD_CHECKED = "checked";
    private static final String BUILDER_METHOD_OPTIONS = "options";
    private static final String MEMBER_FETCHER = "fetcher";
    private static final String BUILDER_METHOD_BUTTONS = "buttons";
    private static final String BUILDER_METHOD_MIN = "min";
    private static final String BUILDER_METHOD_MAX = "max";
    private static final String BUILDER_METHOD_MAX_LENGTH = "maxLength";
    private static final String BUILDER_METHOD_MIN_LENGTH = "minLength";
    private static final Map<Class<? extends Annotation>, Class<? extends FormElement>> ANNOTATION_MAPPING = Map.ofEntries(Map.entry(InputHidden.class, InputHiddenFormElement.class), Map.entry(InputRadio.class, InputRadioFormElement.class), Map.entry(InputCheckbox.class, InputCheckboxFormElement.class), Map.entry(InputPassword.class, InputPasswordFormElement.class), Map.entry(InputEmail.class, InputEmailFormElement.class), Map.entry(Email.class, InputEmailFormElement.class), Map.entry(InputUrl.class, InputUrlFormElement.class), Map.entry(InputTel.class, InputTelFormElement.class), Map.entry(Select.class, SelectFormElement.class), Map.entry(Textarea.class, TextareaFormElement.class), Map.entry(TrixEditor.class, TrixEditorFormElement.class));
    private static final String MEMBER_MIN = "min";
    private static final String MEMBER_MAX = "max";
    private static final String CLASS_IO_MICRONAUT_DATA_ANNOTATION_AUTO_POPULATED = "io.micronaut.data.annotation.AutoPopulated";
    private final EnumOptionFetcher<?> enumOptionFetcher;
    private final EnumRadioFetcher<?> enumRadioFetcher;
    private final EnumCheckboxFetcher<?> enumCheckboxFetcher;
    private final BeanContext beanContext;
    private final ConcurrentHashMap<Class<? extends OptionFetcher>, OptionFetcher> optionFetcherCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends RadioFetcher>, RadioFetcher> radioFetcherCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends CheckboxFetcher>, CheckboxFetcher> checkboxFetcherCache = new ConcurrentHashMap();

    public DefaultFieldGenerator(EnumOptionFetcher<?> enumOptionFetcher, EnumRadioFetcher<?> enumRadioFetcher, EnumCheckboxFetcher<?> enumCheckboxFetcher, BeanContext beanContext) {
        this.enumOptionFetcher = enumOptionFetcher;
        this.enumRadioFetcher = enumRadioFetcher;
        this.enumCheckboxFetcher = enumCheckboxFetcher;
        this.beanContext = beanContext;
    }

    @Override
    @NonNull
    public <T> Fieldset generate(@NonNull Class<T> type) {
        BeanIntrospection introspection = BeanIntrospection.getIntrospection(type);
        return new Fieldset(this.formElements(introspection.getBeanProperties(), null), Collections.emptyList());
    }

    @Override
    public <T> Fieldset generate(@NonNull Class<T> type, @NonNull BiConsumer<String, BeanIntrospection.Builder<? extends FormElement>> builderConsumer) {
        BeanIntrospection introspection = BeanIntrospection.getIntrospection(type);
        return new Fieldset(this.formElements(introspection.getBeanProperties(), builderConsumer), Collections.emptyList());
    }

    @Override
    public Fieldset generate(@NonNull Object instance) {
        return new Fieldset(this.generateOfBeanWrapper(BeanWrapper.getWrapper((Object)instance), null, null), Collections.emptyList());
    }

    @Override
    @NonNull
    public Fieldset generate(@NonNull Object instance, @NonNull BiConsumer<String, BeanIntrospection.Builder<? extends FormElement>> builderConsumer) {
        return new Fieldset(this.generateOfBeanWrapper(BeanWrapper.getWrapper((Object)instance), null, builderConsumer), Collections.emptyList());
    }

    @Override
    public Fieldset generate(@NonNull Object instance, @NonNull ConstraintViolationException ex) {
        return this.generate(this.generateOfBeanWrapper(BeanWrapper.getWrapper((Object)instance), ex, null), ex);
    }

    @Override
    public Fieldset generate(Object instance, ConstraintViolationException ex, BiConsumer<String, BeanIntrospection.Builder<? extends FormElement>> builderConsumer) {
        return this.generate(this.generateOfBeanWrapper(BeanWrapper.getWrapper((Object)instance), ex, builderConsumer), ex);
    }

    @NonNull
    private Fieldset generate(@NonNull List<? extends FormElement> fields, @NonNull ConstraintViolationException ex) {
        return new Fieldset(fields, ex.getConstraintViolations().stream().filter(constraintViolationEx -> ConstraintViolationUtils.lastNode(constraintViolationEx).isEmpty()).map(Message::of).sorted().toList());
    }

    @NonNull
    private <T> List<? extends FormElement> generateOfBeanWrapper(@NonNull BeanWrapper<T> beanWrapper, @Nullable ConstraintViolationException ex, @Nullable BiConsumer<String, BeanIntrospection.Builder<? extends FormElement>> builderConsumer) {
        ArrayList result = new ArrayList(beanWrapper.getBeanProperties().size());
        for (BeanProperty beanProperty : beanWrapper.getBeanProperties()) {
            this.formElementClassForBeanProperty(beanProperty).ifPresent(formElementClazz -> {
                BeanIntrospection.Builder builder = this.formElementBuilderForBeanProperty((BeanProperty)beanProperty, (Class)formElementClazz, beanWrapper, ex, builderConsumer);
                result.add((FormElement)builder.build());
            });
        }
        return result;
    }

    @NonNull
    private <T> Optional<Class<? extends FormElement>> formElementClassForBeanProperty(@NonNull BeanProperty<T, ?> beanProperty) {
        if (beanProperty.hasStereotype(CLASS_IO_MICRONAUT_DATA_ANNOTATION_AUTO_POPULATED)) {
            return Optional.empty();
        }
        for (Map.Entry<Class<? extends Annotation>, Class<? extends FormElement>> mapping : ANNOTATION_MAPPING.entrySet()) {
            if (!beanProperty.hasAnnotation(mapping.getKey())) continue;
            return Optional.of(mapping.getValue());
        }
        if (beanProperty.getType() == LocalDate.class) {
            return Optional.of(InputDateFormElement.class);
        }
        if (beanProperty.getType() == LocalDateTime.class) {
            return Optional.of(InputDateTimeLocalFormElement.class);
        }
        if (beanProperty.getType() == LocalTime.class) {
            return Optional.of(InputTimeFormElement.class);
        }
        if (Number.class.isAssignableFrom(beanProperty.getType())) {
            return Optional.of(InputNumberFormElement.class);
        }
        if (beanProperty.getType() == Boolean.TYPE) {
            return Optional.of(InputCheckboxFormElement.class);
        }
        if (beanProperty.getType().isEnum()) {
            return Optional.of(SelectFormElement.class);
        }
        if (CharSequence.class.isAssignableFrom(beanProperty.getType())) {
            return Optional.of(InputTextFormElement.class);
        }
        return Optional.empty();
    }

    @NonNull
    private <T> Optional<RadioFetcher> radioFetcherForBeanProperty(@NonNull BeanProperty<T, ?> beanProperty) {
        AnnotationValue annotation;
        Optional radioFetcherClassOptional;
        if (beanProperty.hasAnnotation(InputRadio.class) && (radioFetcherClassOptional = (annotation = beanProperty.getAnnotation(InputRadio.class)).classValue(MEMBER_FETCHER)).isPresent()) {
            Class radioFetcherClass = (Class)radioFetcherClassOptional.get();
            if (this.radioFetcherCache.containsKey(radioFetcherClass)) {
                return Optional.of(this.radioFetcherCache.get(radioFetcherClass));
            }
            Optional radioFetcherOptional = this.beanContext.findBean(radioFetcherClass);
            if (radioFetcherOptional.isPresent()) {
                RadioFetcher radioFetcher = (RadioFetcher)radioFetcherOptional.get();
                this.radioFetcherCache.putIfAbsent(radioFetcherClass, radioFetcher);
                return Optional.of(radioFetcher);
            }
        }
        if (beanProperty.getType().isEnum()) {
            return Optional.of(this.enumRadioFetcher);
        }
        return Optional.empty();
    }

    @NonNull
    private <T> Optional<CheckboxFetcher> checkboxFetcherForBeanProperty(@NonNull BeanProperty<T, ?> beanProperty) {
        AnnotationValue annotation;
        Optional fetcherClassOptional;
        if (beanProperty.hasAnnotation(InputCheckbox.class) && (fetcherClassOptional = (annotation = beanProperty.getAnnotation(InputCheckbox.class)).classValue(MEMBER_FETCHER)).isPresent()) {
            Class fetcherClass = (Class)fetcherClassOptional.get();
            if (this.checkboxFetcherCache.containsKey(fetcherClass)) {
                return Optional.of(this.checkboxFetcherCache.get(fetcherClass));
            }
            Optional fetcherOptional = this.beanContext.findBean(fetcherClass);
            if (fetcherOptional.isPresent()) {
                CheckboxFetcher fetcher = (CheckboxFetcher)fetcherOptional.get();
                this.checkboxFetcherCache.putIfAbsent(fetcherClass, fetcher);
                return Optional.of(fetcher);
            }
        }
        if (beanProperty.getType().isEnum()) {
            return Optional.of(this.enumCheckboxFetcher);
        }
        return Optional.empty();
    }

    private <T> Optional<OptionFetcher> optionFetcherForBeanProperty(BeanProperty<T, ?> beanProperty) {
        AnnotationValue annotation;
        Optional optionFetcherClassOptional;
        if (beanProperty.hasAnnotation(Select.class) && (optionFetcherClassOptional = (annotation = beanProperty.getAnnotation(Select.class)).classValue(MEMBER_FETCHER)).isPresent()) {
            Class optionFetcherClass = (Class)optionFetcherClassOptional.get();
            if (this.optionFetcherCache.containsKey(optionFetcherClass)) {
                return Optional.of(this.optionFetcherCache.get(optionFetcherClass));
            }
            Optional optionFetcherOptional = this.beanContext.findBean(optionFetcherClass);
            if (optionFetcherOptional.isPresent()) {
                OptionFetcher optionFetcher = (OptionFetcher)optionFetcherOptional.get();
                this.optionFetcherCache.putIfAbsent(optionFetcherClass, optionFetcher);
                return Optional.of(optionFetcher);
            }
        }
        if (beanProperty.getType().isEnum()) {
            return Optional.of(this.enumOptionFetcher);
        }
        return Optional.empty();
    }

    private <T, E extends FormElement> BeanIntrospection.Builder<E> formElementBuilderForBeanProperty(BeanProperty<T, ?> beanProperty, Class<E> formElementClazz, @Nullable BeanWrapper<T> beanWrapper, @Nullable ConstraintViolationException ex, @Nullable BiConsumer<String, BeanIntrospection.Builder<? extends FormElement>> builderConsumer) {
        BeanIntrospection.Builder builder = BeanIntrospection.getIntrospection(formElementClazz).builder();
        if (formElementClazz == InputCheckboxFormElement.class) {
            builder.with(BUILDER_METHOD_CHECKBOXES, (Object)this.checkboxFetcherForBeanProperty(beanProperty).map(fetcher -> this.valueForBeanProperty(beanWrapper, beanProperty).map(fetcher::generate).orElseGet(() -> fetcher.generate(beanProperty.getType()))).orElseGet(() -> {
                Checkbox formElement = (Checkbox)this.formElementBuilderForBeanProperty(beanProperty, Checkbox.class, beanWrapper, ex, null).with(BUILDER_METHOD_CHECKED, (Object)this.valueForBeanProperty(beanWrapper, beanProperty).map(v -> Boolean.valueOf(v.toString())).orElse(false)).build();
                return Collections.singletonList(formElement);
            }));
        } else if (formElementClazz == SelectFormElement.class) {
            builder.with(BUILDER_METHOD_OPTIONS, this.optionFetcherForBeanProperty(beanProperty).map(optionFetcher -> this.valueForBeanProperty(beanWrapper, beanProperty).map(optionFetcher::generate).orElseGet(() -> optionFetcher.generate(beanProperty.getType()))).orElse(Collections.emptyList()));
        } else if (formElementClazz == InputRadioFormElement.class) {
            builder.with(BUILDER_METHOD_BUTTONS, this.radioFetcherForBeanProperty(beanProperty).map(fetcher -> this.valueForBeanProperty(beanWrapper, beanProperty).map(fetcher::generate).orElseGet(() -> fetcher.generate(beanProperty.getType()))).orElse(Collections.emptyList()));
        }
        builder.with(BUILDER_METHOD_NAME, (Object)beanProperty.getName()).with(BUILDER_METHOD_ID, (Object)this.idForBeanProperty(beanProperty)).with(BUILDER_METHOD_LABEL, (Object)Message.of(beanProperty)).with(BUILDER_METHOD_REQUIRED, (Object)this.requiredForBeanProperty(beanProperty));
        this.valueForBeanProperty(beanWrapper, beanProperty).ifPresent(value -> {
            try {
                builder.with(BUILDER_METHOD_VALUE, value);
            }
            catch (IllegalArgumentException e) {
                builder.with(BUILDER_METHOD_VALUE, (Object)value.toString());
            }
        });
        if (beanWrapper != null) {
            builder.with(BUILDER_METHOD_ERRORS, this.messagesForBeanProperty(beanProperty, ex));
        }
        this.minForBeanProperty(beanProperty).ifPresent(min -> builder.with("min", min));
        this.maxForBeanProperty(beanProperty).ifPresent(max -> builder.with("max", max));
        this.minLengthForBeanProperty(beanProperty).ifPresent(min -> builder.with(BUILDER_METHOD_MIN_LENGTH, min));
        this.maxLengthForBeanProperty(beanProperty).ifPresent(max -> builder.with(BUILDER_METHOD_MAX_LENGTH, max));
        if (builderConsumer != null) {
            builderConsumer.accept(beanProperty.getName(), (BeanIntrospection.Builder<? extends FormElement>)builder);
        }
        return builder;
    }

    private Optional<Object> maxForBeanProperty(BeanProperty<?, ?> beanProperty) {
        return this.annotationValueForBeanProperty(beanProperty, Max.class);
    }

    private Optional<Object> minForBeanProperty(BeanProperty<?, ?> beanProperty) {
        if (beanProperty.hasAnnotation(Positive.class)) {
            return Optional.of(1);
        }
        return this.annotationValueForBeanProperty(beanProperty, Min.class);
    }

    private Optional<Object> minLengthForBeanProperty(BeanProperty<?, ?> beanProperty) {
        return this.annotationValueForBeanProperty(beanProperty, Size.class, "min");
    }

    private Optional<Object> maxLengthForBeanProperty(BeanProperty<?, ?> beanProperty) {
        return this.annotationValueForBeanProperty(beanProperty, Size.class, "max");
    }

    private List<Message> messagesForBeanProperty(BeanProperty<?, ?> beanProperty, @Nullable ConstraintViolationException ex) {
        return ex == null ? Collections.emptyList() : ex.getConstraintViolations().stream().filter(violation -> {
            Optional<String> lastNodeOptional = ConstraintViolationUtils.lastNode(violation);
            return lastNodeOptional.isPresent() && lastNodeOptional.get().equals(beanProperty.getName());
        }).map(Message::of).sorted().toList();
    }

    private <T> List<? extends FormElement> formElements(Collection<BeanProperty<T, Object>> beanProperties, @Nullable BiConsumer<String, BeanIntrospection.Builder<? extends FormElement>> builderConsumer) {
        return beanProperties.stream().flatMap(beanProperty -> this.formElementOfBeanProperty((BeanProperty<?, ?>)beanProperty, builderConsumer).stream()).toList();
    }

    @Nullable
    private Optional<? extends FormElement> formElementOfBeanProperty(@NonNull BeanProperty<?, ?> beanProperty, @Nullable BiConsumer<String, BeanIntrospection.Builder<? extends FormElement>> builderConsumer) {
        return this.formElementClassForBeanProperty(beanProperty).map(formElementClass -> (FormElement)this.formElementBuilderForBeanProperty((BeanProperty)beanProperty, (Class)formElementClass, null, null, builderConsumer).build());
    }

    private <T> Optional<Object> valueForBeanProperty(@Nullable BeanWrapper<T> beanWrapper, BeanProperty<T, ?> beanProperty) {
        if (beanWrapper != null) {
            Object value = beanProperty.get(beanWrapper.getBean());
            if (beanProperty.getType() == Boolean.TYPE) {
                return Optional.of((Boolean)value != false ? "true" : "false");
            }
            return Optional.ofNullable(value);
        }
        if (beanProperty.getType() == Boolean.TYPE) {
            return Optional.of("false");
        }
        return Optional.empty();
    }

    private boolean requiredForBeanProperty(BeanProperty<?, ?> beanProperty) {
        return beanProperty.hasAnnotation(Nonnull.class) || beanProperty.hasAnnotation(NotNull.class) || beanProperty.hasAnnotation(NotBlank.class) || beanProperty.hasAnnotation(NonNull.class);
    }

    @NonNull
    private String idForBeanProperty(@NonNull BeanProperty<?, ?> beanProperty) {
        return beanProperty.getName();
    }

    private Optional<Object> annotationValueForBeanProperty(@NonNull BeanProperty<?, ?> beanProperty, @NonNull Class<? extends Annotation> annotation) {
        AnnotationValue ann;
        OptionalLong optionalLong;
        if (beanProperty.hasAnnotation(annotation) && (optionalLong = (ann = beanProperty.getAnnotation(annotation)).longValue()).isPresent()) {
            return Optional.of(optionalLong.getAsLong());
        }
        return Optional.empty();
    }

    private Optional<Object> annotationValueForBeanProperty(@NonNull BeanProperty<?, ?> beanProperty, @NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        AnnotationValue ann;
        OptionalInt optionalInt;
        if (beanProperty.hasAnnotation(annotation) && (optionalInt = (ann = beanProperty.getAnnotation(annotation)).intValue(member)).isPresent()) {
            return Optional.of(optionalInt.getAsInt());
        }
        return Optional.empty();
    }
}

