/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.mongodb;

import io.micronaut.testresources.testcontainers.AbstractTestContainersProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.utility.DockerImageName;

public class MongoDBTestResourceProvider
extends AbstractTestContainersProvider<MongoDBContainer> {
    public static final String MONGODB_SERVERS = "mongodb.servers";
    public static final String MONGODB_SERVER_URI = "mongodb.uri";
    public static final String DEFAULT_IMAGE = "mongo:5";
    public static final String SIMPLE_NAME = "mongodb";
    public static final String DB_NAME = "containers.mongodb.db-name";
    public static final String DISPLAY_NAME = "MongoDB";
    private String dbName;

    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        List servers = List.copyOf(propertyEntries.getOrDefault(MONGODB_SERVERS, Collections.emptySet()));
        if (servers.isEmpty()) {
            return Collections.singletonList(MONGODB_SERVER_URI);
        }
        return servers.stream().map(s -> "mongodb.servers." + s + ".uri").toList();
    }

    public List<String> getRequiredPropertyEntries() {
        return List.of(MONGODB_SERVERS);
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    protected String getSimpleName() {
        return SIMPLE_NAME;
    }

    protected String getDefaultImageName() {
        return DEFAULT_IMAGE;
    }

    protected MongoDBContainer createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        Object configuredDbName = testResourcesConfig.get(DB_NAME);
        if (configuredDbName != null) {
            this.dbName = configuredDbName.toString();
        }
        return new MongoDBContainer(imageName);
    }

    protected Optional<String> resolveProperty(String propertyName, MongoDBContainer container) {
        Optional<String> database = this.extractMongoDbServerFrom(propertyName);
        if (database.isPresent()) {
            return Optional.of(container.getReplicaSetUrl(database.get()));
        }
        String url = this.dbName == null ? container.getReplicaSetUrl() : container.getReplicaSetUrl(this.dbName);
        return Optional.of(url);
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        if (this.extractMongoDbServerFrom(propertyName).isPresent()) {
            return true;
        }
        return MONGODB_SERVER_URI.equals(propertyName);
    }

    private Optional<String> extractMongoDbServerFrom(String propertyName) {
        int nextDot;
        String suffix;
        int dot;
        if (propertyName.startsWith("mongodb.servers.") && (dot = (suffix = propertyName.substring(MONGODB_SERVERS.length() + 1)).indexOf(".")) > 0 && (nextDot = suffix.indexOf(".", dot + 1)) == -1) {
            String database = suffix.substring(0, dot);
            String property = suffix.substring(dot + 1);
            if ("uri".equals(property)) {
                return Optional.of(database);
            }
        }
        return Optional.empty();
    }
}

