/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.mongodb;

import io.micronaut.testresources.testcontainers.AbstractTestContainersProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.utility.DockerImageName;

public class MongoDBTestResourceProvider
extends AbstractTestContainersProvider<MongoDBContainer> {
    public static final String MONGODB_SERVER_URI = "mongodb.uri";
    public static final String DEFAULT_IMAGE = "mongo:5";
    public static final String SIMPLE_NAME = "mongodb";
    public static final String DB_NAME = "containers.mongodb.db-name";
    private String dbName;

    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        return Collections.singletonList(MONGODB_SERVER_URI);
    }

    protected String getSimpleName() {
        return SIMPLE_NAME;
    }

    protected String getDefaultImageName() {
        return DEFAULT_IMAGE;
    }

    protected MongoDBContainer createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfiguration) {
        Object configuredDbName = testResourcesConfiguration.get(DB_NAME);
        if (configuredDbName != null) {
            this.dbName = configuredDbName.toString();
        }
        return new MongoDBContainer(imageName);
    }

    protected Optional<String> resolveProperty(String propertyName, MongoDBContainer container) {
        String url = this.dbName == null ? container.getReplicaSetUrl() : container.getReplicaSetUrl(this.dbName);
        return Optional.of(url);
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfiguration) {
        return MONGODB_SERVER_URI.equals(propertyName);
    }
}

