/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.mongodb;

import io.micronaut.testresources.testcontainers.AbstractTestContainersProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.utility.DockerImageName;

public class MongoDBTestResourceProvider
extends AbstractTestContainersProvider<MongoDBContainer> {
    public static final String MONGODB_SERVER_URI = "mongodb.uri";
    public static final String DEFAULT_IMAGE = "mongo";

    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        return Collections.singletonList(MONGODB_SERVER_URI);
    }

    protected String getSimpleName() {
        return "mongodb";
    }

    protected String getDefaultImageName() {
        return DEFAULT_IMAGE;
    }

    protected MongoDBContainer createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfiguration) {
        return new MongoDBContainer(imageName);
    }

    protected Optional<String> resolveProperty(String propertyName, MongoDBContainer container) {
        return Optional.of(container.getReplicaSetUrl());
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfiguration) {
        return MONGODB_SERVER_URI.equals(propertyName);
    }
}

