/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.localstack.sns;

import io.micronaut.testresources.localstack.LocalStackService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.testcontainers.containers.localstack.LocalStackContainer;

public class LocalStackSNSService
implements LocalStackService {
    private static final String AWS_SNS_ENDPOINT_OVERRIDE = "aws.services.sns.endpoint-override";

    public LocalStackContainer.Service getServiceKind() {
        return LocalStackContainer.Service.SNS;
    }

    public List<String> getResolvableProperties() {
        return Collections.singletonList(AWS_SNS_ENDPOINT_OVERRIDE);
    }

    public Optional<String> resolveProperty(String propertyName, LocalStackContainer container) {
        if (AWS_SNS_ENDPOINT_OVERRIDE.equals(propertyName)) {
            return Optional.of(container.getEndpointOverride(LocalStackContainer.Service.SNS).toString());
        }
        return Optional.empty();
    }
}

