/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.elasticsearch;

import io.micronaut.testresources.testcontainers.AbstractTestContainersProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.utility.DockerImageName;

public class ElasticsearchTestResourceProvider
extends AbstractTestContainersProvider<ElasticsearchContainer> {
    public static final String ELASTICSEARCH_HOSTS = "elasticsearch.http-hosts";
    public static final String SIMPLE_NAME = "elasticsearch";
    public static final String DEFAULT_IMAGE = "docker.elastic.co/elasticsearch/elasticsearch";
    public static final String DEFAULT_TAG = "8.4.3";
    public static final String DISPLAY_NAME = "Elasticsearch";

    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        return Collections.singletonList(ELASTICSEARCH_HOSTS);
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    protected String getSimpleName() {
        return SIMPLE_NAME;
    }

    protected String getDefaultImageName() {
        return DEFAULT_IMAGE;
    }

    protected ElasticsearchContainer createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        if ("latest".equals(imageName.getVersionPart())) {
            imageName = imageName.withTag(DEFAULT_TAG);
        }
        ElasticsearchContainer elasticsearchContainer = new ElasticsearchContainer(imageName);
        elasticsearchContainer.withEnv("xpack.security.enabled", "false");
        return elasticsearchContainer;
    }

    protected Optional<String> resolveProperty(String propertyName, ElasticsearchContainer container) {
        if (ELASTICSEARCH_HOSTS.equals(propertyName)) {
            return Optional.of("http://" + container.getHttpHostAddress());
        }
        return Optional.empty();
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return ELASTICSEARCH_HOSTS.equals(propertyName);
    }
}

