/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.json.stream;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.JsonStreamConfig;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.ObjectMapper;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.DeserializationConfiguration;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.json.stream.JsonParserDecoder;
import io.micronaut.serde.json.stream.JsonStreamEncoder;
import io.micronaut.serde.support.util.BufferingJsonNodeProcessor;
import io.micronaut.serde.support.util.JsonNodeDecoder;
import io.micronaut.serde.support.util.JsonNodeEncoder;
import io.micronaut.serde.support.util.JsonViewUtil;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Consumer;
import org.reactivestreams.Processor;

@Singleton
@BootstrapContextCompatible
public class JsonStreamMapper
implements ObjectMapper {
    private final SerdeRegistry registry;
    @Nullable
    private final SerdeConfiguration serdeConfiguration;
    @Nullable
    private final Class<?> view;

    @Deprecated
    public JsonStreamMapper(@NonNull SerdeRegistry registry) {
        this(registry, (Class)null);
    }

    @Deprecated
    public JsonStreamMapper(@NonNull SerdeRegistry registry, @Nullable Class<?> view) {
        this(registry, null, view);
    }

    @Inject
    public JsonStreamMapper(@NonNull SerdeRegistry registry, @NonNull SerdeConfiguration serdeConfiguration) {
        this(registry, serdeConfiguration, null);
    }

    private JsonStreamMapper(@NonNull SerdeRegistry registry, @Nullable SerdeConfiguration serdeConfiguration, @Nullable Class<?> view) {
        this.registry = registry;
        this.serdeConfiguration = serdeConfiguration;
        this.view = view;
    }

    public SerdeRegistry getSerdeRegistry() {
        return this.registry;
    }

    public ObjectMapper cloneWithConfiguration(@Nullable SerdeConfiguration configuration, @Nullable SerializationConfiguration serializationConfiguration, @Nullable DeserializationConfiguration deserializationConfiguration) {
        return new JsonStreamMapper(this.registry.cloneWithConfiguration(configuration, serializationConfiguration, deserializationConfiguration), configuration == null ? this.serdeConfiguration : configuration, this.view);
    }

    public JsonMapper cloneWithViewClass(Class<?> viewClass) {
        return new JsonStreamMapper(this.registry, this.serdeConfiguration, viewClass);
    }

    public <T> T readValueFromTree(JsonNode tree, Argument<T> type) throws IOException {
        Deserializer.DecoderContext context = this.registry.newDecoderContext(JsonViewUtil.extractView((SerdeConfiguration)this.serdeConfiguration, type, this.view));
        Deserializer deserializer = context.findDeserializer(type).createSpecific(context, type);
        return (T)deserializer.deserialize((Decoder)JsonNodeDecoder.create((JsonNode)tree, (LimitingStream.RemainingLimits)this.limits()), context, type);
    }

    public <T> T readValue(InputStream inputStream, Argument<T> type) throws IOException {
        try (JsonParser parser = Json.createParser((InputStream)inputStream);){
            T t = this.readValue(parser, type);
            return t;
        }
    }

    public <T> T readValue(byte[] byteArray, Argument<T> type) throws IOException {
        try (JsonParser parser = Json.createParser((InputStream)new ByteArrayInputStream(byteArray));){
            T t = this.readValue(parser, type);
            return t;
        }
    }

    private <T> T readValue(JsonParser parser, Argument<T> type) throws IOException {
        JsonParserDecoder decoder = new JsonParserDecoder(parser, this.limits());
        Deserializer.DecoderContext context = this.registry.newDecoderContext(JsonViewUtil.extractView((SerdeConfiguration)this.serdeConfiguration, type, this.view));
        Deserializer deserializer = context.findDeserializer(type).createSpecific(context, type);
        return (T)deserializer.deserialize((Decoder)decoder, context, type);
    }

    public Processor<byte[], JsonNode> createReactiveParser(Consumer<Processor<byte[], JsonNode>> onSubscribe, boolean streamArray) {
        return new BufferingJsonNodeProcessor(onSubscribe, streamArray){

            @NonNull
            protected JsonNode parseOne(@NonNull InputStream is) throws IOException {
                try (JsonParser parser = Json.createParser((InputStream)is);){
                    JsonParserDecoder decoder = new JsonParserDecoder(parser, JsonStreamMapper.this.limits());
                    Object o = decoder.decodeArbitrary();
                    JsonNode jsonNode = JsonStreamMapper.this.writeValueToTree(o);
                    return jsonNode;
                }
            }
        };
    }

    public JsonNode writeValueToTree(Object value) throws IOException {
        JsonNodeEncoder encoder = JsonNodeEncoder.create((LimitingStream.RemainingLimits)this.limits());
        this.serialize((Encoder)encoder, value);
        return encoder.getCompletedValue();
    }

    public <T> JsonNode writeValueToTree(Argument<T> type, T value) throws IOException {
        JsonNodeEncoder encoder = JsonNodeEncoder.create((LimitingStream.RemainingLimits)this.limits());
        this.serialize((Encoder)encoder, value, type);
        return encoder.getCompletedValue();
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException {
        try (JsonGenerator generator = Json.createGenerator((OutputStream)Objects.requireNonNull(outputStream, "Output stream cannot be null"));){
            if (object == null) {
                generator.writeNull();
            } else {
                JsonStreamEncoder encoder = new JsonStreamEncoder(generator, this.limits());
                this.serialize(encoder, object);
            }
            generator.flush();
        }
    }

    public <T> void writeValue(OutputStream outputStream, Argument<T> type, T object) throws IOException {
        try (JsonGenerator generator = Json.createGenerator((OutputStream)Objects.requireNonNull(outputStream, "Output stream cannot be null"));){
            if (object == null) {
                generator.writeNull();
            } else {
                JsonStreamEncoder encoder = new JsonStreamEncoder(generator, this.limits());
                this.serialize(encoder, object, type);
            }
            generator.flush();
        }
    }

    @NonNull
    private LimitingStream.RemainingLimits limits() {
        return this.serdeConfiguration == null ? LimitingStream.DEFAULT_LIMITS : LimitingStream.limitsFromConfiguration((SerdeConfiguration)this.serdeConfiguration);
    }

    private void serialize(Encoder encoder, Object object) throws IOException {
        this.serialize(encoder, object, Argument.of(object.getClass()));
    }

    private void serialize(Encoder encoder, Object object, Argument type) throws IOException {
        Serializer.EncoderContext context = this.registry.newEncoderContext(JsonViewUtil.extractView((SerdeConfiguration)this.serdeConfiguration, (Argument)type, this.view));
        Serializer serializer = context.findSerializer(type).createSpecific(context, type);
        serializer.serialize(encoder, context, type, object);
    }

    public byte[] writeValueAsBytes(Object object) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.writeValue(output, object);
        return output.toByteArray();
    }

    public <T> byte[] writeValueAsBytes(Argument<T> type, T object) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.writeValue(output, type, object);
        return output.toByteArray();
    }

    public JsonStreamConfig getStreamConfig() {
        return JsonStreamConfig.DEFAULT;
    }
}

