/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.json.stream;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.util.BinaryCodecUtil;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

final class JsonStreamEncoder
extends LimitingStream
implements Encoder {
    private final JsonGenerator jsonGenerator;
    private final JsonStreamEncoder parent;
    private String currentKey;
    private int currentIndex;

    public JsonStreamEncoder(JsonGenerator jsonGenerator, LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
        this.jsonGenerator = jsonGenerator;
        this.parent = null;
    }

    private JsonStreamEncoder(JsonStreamEncoder parent, LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
        this.jsonGenerator = parent.jsonGenerator;
        this.parent = parent;
    }

    private void postEncodeValue() {
        ++this.currentIndex;
    }

    public Encoder encodeArray(Argument<?> type) throws IOException {
        this.jsonGenerator.writeStartArray();
        return new JsonStreamEncoder(this, this.childLimits());
    }

    public Encoder encodeObject(Argument<?> type) throws IOException {
        this.jsonGenerator.writeStartObject();
        return new JsonStreamEncoder(this, this.childLimits());
    }

    public void finishStructure() throws IOException {
        if (this.parent == null) {
            throw new IllegalStateException("Not a structure");
        }
        this.jsonGenerator.writeEnd();
        this.parent.postEncodeValue();
    }

    public void encodeKey(String key) throws IOException {
        this.jsonGenerator.writeKey(key);
        this.currentKey = key;
    }

    public void encodeString(String value) throws IOException {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeBoolean(boolean value) throws IOException {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeByte(byte value) throws IOException {
        this.jsonGenerator.write((int)value);
        this.postEncodeValue();
    }

    public void encodeShort(short value) throws IOException {
        this.jsonGenerator.write((int)value);
        this.postEncodeValue();
    }

    public void encodeChar(char value) throws IOException {
        this.jsonGenerator.write((int)value);
        this.postEncodeValue();
    }

    public void encodeInt(int value) throws IOException {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeLong(long value) throws IOException {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeFloat(float value) throws IOException {
        this.jsonGenerator.write((double)value);
        this.postEncodeValue();
    }

    public void encodeDouble(double value) throws IOException {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeBigInteger(BigInteger value) throws IOException {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeBigDecimal(BigDecimal value) throws IOException {
        this.jsonGenerator.write(value);
        this.postEncodeValue();
    }

    public void encodeBinary(byte @NonNull [] data) throws IOException {
        BinaryCodecUtil.encodeToBase64String((Encoder)this, (byte[])data);
    }

    public void encodeNull() throws IOException {
        this.jsonGenerator.writeNull();
        this.postEncodeValue();
    }

    @NonNull
    public String currentPath() {
        StringBuilder builder = new StringBuilder();
        JsonStreamEncoder enc = this;
        while (enc != null) {
            if (enc != this) {
                builder.insert(0, "->");
            }
            if (enc.currentKey == null) {
                if (enc.parent != null) {
                    builder.insert(0, enc.currentIndex);
                }
            } else {
                builder.insert(0, enc.currentKey);
            }
            enc = enc.parent;
        }
        return builder.toString();
    }
}

